/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.hyades.models.common.testprofile.TPFTimedEvent;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * @author jtoomey
 * @since 3.0.1
 */
public class TimedEventDetailPage 
extends DetailSection.DetailPage
{
	private StyledText endTime;
	private StyledText duration;

	private TPFTimedEvent timedEvent;
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		timedEvent = null;
	}

	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.DetailSection.DetailPage#createControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Control createControl(Composite parent, FormWidgetFactory factory)
	{
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(GridDataUtil.createFill());

		widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_END_TIME")); //$NON-NLS-1$
		endTime = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		endTime.setLayoutData(GridDataUtil.createHorizontalFill());
		endTime.setEditable(false);

		widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_DURATION")); //$NON-NLS-1$
		duration = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		duration.setLayoutData(GridDataUtil.createHorizontalFill());
		duration.setEditable(false);

		widgetFactory.paintBordersFor(composite);
		return composite;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		timedEvent = null;

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		boolean objectIsSet = false;
		if(object instanceof TPFTimedEvent)
		{
			timedEvent = (TPFTimedEvent)object;
			if(timedEvent != null)
			{		
				objectIsSet = true;
				endTime.setText(EventUtil.getTime(timedEvent.getEndTimestamp()));
				duration.setText(EventUtil.getDuration(timedEvent.getTimestamp(), timedEvent.getEndTimestamp()));
			}						
		}
		
		if(!objectIsSet)
		{
			endTime.setText(""); //$NON-NLS-1$
			duration.setText(""); //$NON-NLS-1$
			endTime.setEditable(false);
			duration.setEditable(false);
		}
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#getInput()
	 */
	public Object getInput()
	{
		return timedEvent;
	}
}
