/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.spinner.internal;

import java.text.DecimalFormat;

import org.eclipse.hyades.statistical.ui.*;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class Spinner extends Composite implements FocusListener, SelectionListener {

Text text;
Composite buttons;
Button up;
Button down;

double last_good_value = 0.0;

double min = 0;
double max = 100;
double increment = 1;
double decimals = 0;

DecimalFormat dformat;

	public Spinner(Composite parent, int style) {
		super(parent,style);	
		init();
	}

	public void focusGained(FocusEvent e) {
		validateText();
	} 
	public void focusLost(FocusEvent e) {
		validateText();
	}  

	public void configure(int decimals, double min, double max, double increment) {
		this.min = min;
		this.max = max;
		this.increment = increment;
		last_good_value = min;
		
		StringBuffer format = new StringBuffer("#");
		if (decimals > 0) {
			format.append(".");	
		}
		for (int i = 0; i < decimals; i++) {
			format.append("0");	
		}
		dformat = new DecimalFormat(format.toString());
	}
	
	public double getValue() {
		try {
			double d = Double.parseDouble(text.getText());
			return validate(d);
		} catch (Exception e) {
			return last_good_value;
		}
	}

	private void validateText() {
		try {
			double d = Double.parseDouble(text.getText());
			setValue(validate(d));
		} catch (Exception e) {
			setValue(last_good_value);
		}
	}
	
	private double validate(double d) {
		if (d < min) d = min;
		if (d > max) d = max;
		
		double mod = d%increment;
		
		d -= mod;
		
		if (mod > (increment/2)) d += increment;

		return d;
	}
	
	public void setValue(double d) {
		last_good_value = validate(d);
		text.setText(dformat.format(last_good_value));
	}

	private void init() {
		
		GridLayout glayout = new GridLayout();
		glayout.marginHeight = 0;
		glayout.marginWidth = 0;
		glayout.numColumns = 2;
		glayout.horizontalSpacing = 0;
		glayout.verticalSpacing = 0;

		setLayout(glayout);
		
		text = new Text(this,SWT.BORDER|SWT.SINGLE);
		text.setLayoutData(GData.getGridData(true,true,-1,16,1,1,GridData.FILL,GridData.FILL));

		buttons = new Composite(this,0);
		buttons.setLayoutData(GData.getGridData(false,true,-1,16,1,1,GridData.FILL,GridData.FILL));

		FillLayout rlayout = new FillLayout();
		rlayout.type = SWT.VERTICAL;

		buttons.setLayout(rlayout);

//		up = new Button(this,SWT.ARROW|SWT.UP);
		up = new Button(buttons,SWT.PUSH);
		up.setImage(EditorPlugin.img.getImage(ImageManager.IMG_UP));
		
//		down = new Button(this,SWT.ARROW|SWT.DOWN);
		down = new Button(buttons,SWT.PUSH);
		down.setImage(EditorPlugin.img.getImage(ImageManager.IMG_DOWN));
		
		text.setText("0");
		
		text.addFocusListener(this);
		up.addSelectionListener(this);
		down.addSelectionListener(this);
		
	}
	
	public void widgetSelected(SelectionEvent e) {
		if (e.getSource() == up) {
			double d = getValue();
			d += increment;
			if (d > max) d = min;
			setValue(d);
		} else if (e.getSource() == down) {
			double d = getValue();
			d -= increment;
			if (d < min) d = max;
			setValue(d);
		}
	} 
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	
	
	
}