/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.testgen.http;

/**
 * @author dhinson
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class TRCAsciifier
{

	static private final char C_DELIM = '`';
	static private final char C_ZERO = '0';

	public String encode (byte [] inBuf, int inDatOfs, int inDatLen)
	{
		StringBuffer outBuf = new StringBuffer();
		boolean isHex = false;
		for (int inOfs = inDatOfs; inOfs < inDatLen; ++inOfs) {
			char c = (char)inBuf[inOfs];
			if (Character.isISOControl(c) || c == '`') {
				if (!isHex)
					outBuf.append(C_DELIM);
				outBuf.append(Character.forDigit((c >> 4), 16));
				outBuf.append(Character.forDigit((c & 0xf), 16));
				if (inOfs == inDatLen - 1)
					outBuf.append(C_DELIM);				
				isHex = true;
			}
			else {
				if (isHex)
					outBuf.append(C_DELIM);
				outBuf.append(c);
				isHex = false;
			}
		}
		return outBuf.toString();			
	}

	public int decode (String inBuf, int inDatOfs, int inDatLen, byte [] outBuf)
	{
		boolean inHex = false;
		int outOfs = 0;
		char c;
		for (int inOfs = inDatOfs; inOfs < inDatLen; ++inOfs) {
			if ((c = inBuf.charAt(inOfs)) == C_DELIM)
				inHex = !inHex;
			else
				outBuf[outOfs++] = inHex ?
					(byte)((Character.digit(c, 16) << 4) |
					Character.digit(inBuf.charAt(++inOfs), 16)) :
					(byte)c;		
		}				
		return outOfs;
	}


	public static void main (String[] args)
	{
		TRCAsciifier asciifier = new TRCAsciifier();
		
		byte [] bytes;
		String encDat1;
		String encDat2;
		byte [] decBuf;
		int decLen;

		// encode
		bytes = new byte [] { '0', '`', '0', 1, '`', 1, '2', '`', '2', 3, '`', 3 };
		encDat1 = asciifier.encode(bytes, 0, bytes.length);
		System.out.println("[" + encDat1 + "]");
		
		// decode
		decBuf = new byte[encDat1.length()];
		decLen = asciifier.decode(encDat1, 0, encDat1.length(), decBuf); 

		// re-encode & compare
		encDat2 = asciifier.encode(decBuf, 0, decLen);
		System.out.println("[" + encDat2 + "]");
		if (encDat2.equals(encDat1))
			System.out.println("same");
		else
			System.out.println("wrong");
		
		// encode
		bytes = new byte [] { 0, '`', 0, '1', '`', '1', 2, '`', 2, '3', '`', '3' };
		encDat1 = asciifier.encode(bytes, 0, bytes.length);
		System.out.println("[" + encDat1 + "]");
		
		// decode
		decBuf = new byte[encDat1.length()];
		decLen = asciifier.decode(encDat1, 0, encDat1.length(), decBuf); 

		// re-encode & compare
		encDat2 = asciifier.encode(decBuf, 0, decLen);
		System.out.println("[" + encDat2 + "]");
		if (encDat2.equals(encDat1))
			System.out.println("same");
		else
			System.out.println("wrong");
		
	}
	
}

