/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.loaders.trace.ISnapshot;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCSignatureNotation;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Method</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodImpl#getSignature <em>Signature</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodImpl#getModifier <em>Modifier</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodImpl#getNotation <em>Notation</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodImpl#getLineNo <em>Line No</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodImpl#getBaseTime <em>Base Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodImpl#getCumulativeTime <em>Cumulative Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodImpl#getCalls <em>Calls</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodImpl#getDefiningClass <em>Defining Class</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodImpl#getInvocations <em>Invocations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodImpl#getSourceInfo <em>Source Info</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCMethodImpl extends EObjectImpl implements TRCMethod {
	private TRCMethodSnapshot _currentSnapshot;
	private TRCMethodSnapshot _previousSnapshot;
	/**
	 *
	 */
	public int computeDelta(IDelta delta) {
		TRCMethodSnapshot delta1 = (TRCMethodSnapshot) delta;
	
		if ((_currentSnapshot == null) || (_previousSnapshot == null)) {
			delta1.baseTime = 0;
			delta1.calls = 0;
			delta1.cumulativeTime = 0;
			return -1;
		}
	
		delta1.baseTime = _currentSnapshot.baseTime - _previousSnapshot.baseTime;
		delta1.calls = _currentSnapshot.calls - _previousSnapshot.calls;
		delta1.cumulativeTime =
			_currentSnapshot.cumulativeTime - _previousSnapshot.cumulativeTime;
	
		return 1;
	}
	public int computeDelta(IDelta delta, int featureID) {
		TRCMethodSnapshot delta1 = (TRCMethodSnapshot) delta;
	
		if ((_currentSnapshot == null) || (_previousSnapshot == null)) {
			switch (featureID) {
				case TracePackage.TRC_METHOD__BASE_TIME :
					delta1.baseTime = 0;
	
					break;
	
				case TracePackage.TRC_METHOD__CUMULATIVE_TIME :
					delta1.cumulativeTime = 0;
	
					break;
	
				case TracePackage.TRC_METHOD__CALLS :
					delta1.calls = 0;
	
					break;
	
			}
	
			return -1;
		}
	
		switch (featureID) {
			case TracePackage.TRC_METHOD__BASE_TIME :
				delta1.baseTime =
					_currentSnapshot.baseTime - _previousSnapshot.baseTime;
	
				break;
	
			case TracePackage.TRC_METHOD__CUMULATIVE_TIME :
				delta1.cumulativeTime =
					_currentSnapshot.cumulativeTime
						- _previousSnapshot.cumulativeTime;
	
				break;
	
			case TracePackage.TRC_METHOD__CALLS :
				delta1.calls = _currentSnapshot.calls - _previousSnapshot.calls;
	
				break;
	
		}
	
		return 1;
	}
	/**
	 *
	 */
	public void removeSnapshot() {
		_currentSnapshot = null;
		_previousSnapshot = null;
	}
	/**
	 *
	 */
	public ISnapshot retrieveSnapshot() {
		if(_currentSnapshot==null)
		{
			takeSnapshot();
		}
		return _currentSnapshot;
	}
	/**
	 *
	 */
	public void takeSnapshot() {
		TRCMethodSnapshot temp = _previousSnapshot;
	
		_previousSnapshot = _currentSnapshot;
		_currentSnapshot = temp;
	
		if (_currentSnapshot == null) {
			_currentSnapshot = new TRCMethodSnapshot();
		}
	
		_currentSnapshot.baseTime = baseTime;
		_currentSnapshot.calls = calls;
		_currentSnapshot.cumulativeTime = cumulativeTime;
	}
	
	/**
	 * @author slavescu
	 */
	public static class TRCMethodSnapshot implements IDelta,ISnapshot {
		protected double baseTime = BASE_TIME_EDEFAULT;
		protected int calls = CALLS_EDEFAULT;
		protected double cumulativeTime = CUMULATIVE_TIME_EDEFAULT;
		public Object get(int featureID) {
			switch (featureID) {
				case TracePackage.TRC_METHOD__BASE_TIME:
					return new Double(getBaseTime());
				case TracePackage.TRC_METHOD__CUMULATIVE_TIME:
					return new Double(getCumulativeTime());
				case TracePackage.TRC_METHOD__CALLS:
					return new Integer(getCalls());
			}
			return null;
		}

		public double getBaseTime() {
			return baseTime;
		}

		public int getCalls() {
			return calls;
		}

		public double getCumulativeTime() {
			return cumulativeTime;
		}

	}

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final int ID_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected int id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getSignature() <em>Signature</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSignature()
	 * @generated
	 * @ordered
	 */
	protected static final String SIGNATURE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSignature() <em>Signature</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSignature()
	 * @generated
	 * @ordered
	 */
	protected String signature = SIGNATURE_EDEFAULT;

	/**
	 * The default value of the '{@link #getModifier() <em>Modifier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModifier()
	 * @generated
	 * @ordered
	 */
	protected static final int MODIFIER_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getModifier() <em>Modifier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModifier()
	 * @generated
	 * @ordered
	 */
	protected int modifier = MODIFIER_EDEFAULT;

	/**
	 * The default value of the '{@link #getNotation() <em>Notation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNotation()
	 * @generated
	 * @ordered
	 */
	protected static final TRCSignatureNotation NOTATION_EDEFAULT = TRCSignatureNotation.JNI_LITERAL;

	/**
	 * The cached value of the '{@link #getNotation() <em>Notation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNotation()
	 * @generated
	 * @ordered
	 */
	protected TRCSignatureNotation notation = NOTATION_EDEFAULT;

	/**
	 * The default value of the '{@link #getLineNo() <em>Line No</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLineNo()
	 * @generated
	 * @ordered
	 */
	protected static final int LINE_NO_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLineNo() <em>Line No</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLineNo()
	 * @generated
	 * @ordered
	 */
	protected int lineNo = LINE_NO_EDEFAULT;

	/**
	 * The default value of the '{@link #getBaseTime() <em>Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBaseTime()
	 * @generated
	 * @ordered
	 */
	protected static final double BASE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getBaseTime() <em>Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBaseTime()
	 * @generated
	 * @ordered
	 */
	protected double baseTime = BASE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCumulativeTime() <em>Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected static final double CUMULATIVE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getCumulativeTime() <em>Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected double cumulativeTime = CUMULATIVE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCalls() <em>Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCalls()
	 * @generated
	 * @ordered
	 */
	protected static final int CALLS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCalls() <em>Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCalls()
	 * @generated
	 * @ordered
	 */
	protected int calls = CALLS_EDEFAULT;

	/**
	 * The cached value of the '{@link #getInvocations() <em>Invocations</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInvocations()
	 * @generated
	 * @ordered
	 */
	protected EList invocations = null;

	/**
	 * The cached value of the '{@link #getSourceInfo() <em>Source Info</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceInfo()
	 * @generated
	 * @ordered
	 */
	protected TRCSourceInfo sourceInfo = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCMethodImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCMethod();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(int newId) {
		int oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getSignature() {
		return signature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSignature(String newSignature) {
		String oldSignature = signature;
		signature = newSignature;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD__SIGNATURE, oldSignature, signature));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getModifier() {
		return modifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setModifier(int newModifier) {
		int oldModifier = modifier;
		modifier = newModifier;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD__MODIFIER, oldModifier, modifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCSignatureNotation getNotation() {
		return notation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNotation(TRCSignatureNotation newNotation) {
		TRCSignatureNotation oldNotation = notation;
		notation = newNotation == null ? NOTATION_EDEFAULT : newNotation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD__NOTATION, oldNotation, notation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getLineNo() {
		return lineNo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLineNo(int newLineNo) {
		int oldLineNo = lineNo;
		lineNo = newLineNo;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD__LINE_NO, oldLineNo, lineNo));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getBaseTime() {
		return baseTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBaseTime(double newBaseTime) {
		double oldBaseTime = baseTime;
		baseTime = newBaseTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD__BASE_TIME, oldBaseTime, baseTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getCumulativeTime() {
		return cumulativeTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCumulativeTime(double newCumulativeTime) {
		double oldCumulativeTime = cumulativeTime;
		cumulativeTime = newCumulativeTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD__CUMULATIVE_TIME, oldCumulativeTime, cumulativeTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCalls() {
		return calls;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCalls(int newCalls) {
		int oldCalls = calls;
		calls = newCalls;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD__CALLS, oldCalls, calls));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClass getDefiningClass() {
		if (eContainerFeatureID != TracePackage.TRC_METHOD__DEFINING_CLASS) return null;
		return (TRCClass)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDefiningClass(TRCClass newDefiningClass) {
		if (newDefiningClass != eContainer || (eContainerFeatureID != TracePackage.TRC_METHOD__DEFINING_CLASS && newDefiningClass != null)) {
			if (EcoreUtil.isAncestor(this, newDefiningClass))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newDefiningClass != null)
				msgs = ((InternalEObject)newDefiningClass).eInverseAdd(this, TracePackage.TRC_CLASS__METHODS, TRCClass.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newDefiningClass, TracePackage.TRC_METHOD__DEFINING_CLASS, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD__DEFINING_CLASS, newDefiningClass, newDefiningClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getInvocations() {
		if (invocations == null) {
			invocations = new EObjectWithInverseResolvingEList(TRCMethodInvocation.class, this, TracePackage.TRC_METHOD__INVOCATIONS, TracePackage.TRC_METHOD_INVOCATION__METHOD);
		}
		return invocations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCSourceInfo getSourceInfo() {
		if (sourceInfo != null && sourceInfo.eIsProxy()) {
			TRCSourceInfo oldSourceInfo = sourceInfo;
			sourceInfo = (TRCSourceInfo)eResolveProxy((InternalEObject)sourceInfo);
			if (sourceInfo != oldSourceInfo) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_METHOD__SOURCE_INFO, oldSourceInfo, sourceInfo));
			}
		}
		return sourceInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCSourceInfo basicGetSourceInfo() {
		return sourceInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSourceInfo(TRCSourceInfo newSourceInfo) {
		TRCSourceInfo oldSourceInfo = sourceInfo;
		sourceInfo = newSourceInfo;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD__SOURCE_INFO, oldSourceInfo, sourceInfo));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_METHOD__DEFINING_CLASS:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_METHOD__DEFINING_CLASS, msgs);
				case TracePackage.TRC_METHOD__INVOCATIONS:
					return ((InternalEList)getInvocations()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_METHOD__DEFINING_CLASS:
					return eBasicSetContainer(null, TracePackage.TRC_METHOD__DEFINING_CLASS, msgs);
				case TracePackage.TRC_METHOD__INVOCATIONS:
					return ((InternalEList)getInvocations()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_METHOD__DEFINING_CLASS:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_CLASS__METHODS, TRCClass.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_METHOD__ID:
				return new Integer(getId());
			case TracePackage.TRC_METHOD__NAME:
				return getName();
			case TracePackage.TRC_METHOD__SIGNATURE:
				return getSignature();
			case TracePackage.TRC_METHOD__MODIFIER:
				return new Integer(getModifier());
			case TracePackage.TRC_METHOD__NOTATION:
				return getNotation();
			case TracePackage.TRC_METHOD__LINE_NO:
				return new Integer(getLineNo());
			case TracePackage.TRC_METHOD__BASE_TIME:
				return new Double(getBaseTime());
			case TracePackage.TRC_METHOD__CUMULATIVE_TIME:
				return new Double(getCumulativeTime());
			case TracePackage.TRC_METHOD__CALLS:
				return new Integer(getCalls());
			case TracePackage.TRC_METHOD__DEFINING_CLASS:
				return getDefiningClass();
			case TracePackage.TRC_METHOD__INVOCATIONS:
				return getInvocations();
			case TracePackage.TRC_METHOD__SOURCE_INFO:
				if (resolve) return getSourceInfo();
				return basicGetSourceInfo();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_METHOD__ID:
				setId(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_METHOD__NAME:
				setName((String)newValue);
				return;
			case TracePackage.TRC_METHOD__SIGNATURE:
				setSignature((String)newValue);
				return;
			case TracePackage.TRC_METHOD__MODIFIER:
				setModifier(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_METHOD__NOTATION:
				setNotation((TRCSignatureNotation)newValue);
				return;
			case TracePackage.TRC_METHOD__LINE_NO:
				setLineNo(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_METHOD__BASE_TIME:
				setBaseTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_METHOD__CUMULATIVE_TIME:
				setCumulativeTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_METHOD__CALLS:
				setCalls(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_METHOD__DEFINING_CLASS:
				setDefiningClass((TRCClass)newValue);
				return;
			case TracePackage.TRC_METHOD__INVOCATIONS:
				getInvocations().clear();
				getInvocations().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_METHOD__SOURCE_INFO:
				setSourceInfo((TRCSourceInfo)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_METHOD__ID:
				setId(ID_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD__NAME:
				setName(NAME_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD__SIGNATURE:
				setSignature(SIGNATURE_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD__MODIFIER:
				setModifier(MODIFIER_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD__NOTATION:
				setNotation(NOTATION_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD__LINE_NO:
				setLineNo(LINE_NO_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD__BASE_TIME:
				setBaseTime(BASE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD__CUMULATIVE_TIME:
				setCumulativeTime(CUMULATIVE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD__CALLS:
				setCalls(CALLS_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD__DEFINING_CLASS:
				setDefiningClass((TRCClass)null);
				return;
			case TracePackage.TRC_METHOD__INVOCATIONS:
				getInvocations().clear();
				return;
			case TracePackage.TRC_METHOD__SOURCE_INFO:
				setSourceInfo((TRCSourceInfo)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_METHOD__ID:
				return id != ID_EDEFAULT;
			case TracePackage.TRC_METHOD__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case TracePackage.TRC_METHOD__SIGNATURE:
				return SIGNATURE_EDEFAULT == null ? signature != null : !SIGNATURE_EDEFAULT.equals(signature);
			case TracePackage.TRC_METHOD__MODIFIER:
				return modifier != MODIFIER_EDEFAULT;
			case TracePackage.TRC_METHOD__NOTATION:
				return notation != NOTATION_EDEFAULT;
			case TracePackage.TRC_METHOD__LINE_NO:
				return lineNo != LINE_NO_EDEFAULT;
			case TracePackage.TRC_METHOD__BASE_TIME:
				return baseTime != BASE_TIME_EDEFAULT;
			case TracePackage.TRC_METHOD__CUMULATIVE_TIME:
				return cumulativeTime != CUMULATIVE_TIME_EDEFAULT;
			case TracePackage.TRC_METHOD__CALLS:
				return calls != CALLS_EDEFAULT;
			case TracePackage.TRC_METHOD__DEFINING_CLASS:
				return getDefiningClass() != null;
			case TracePackage.TRC_METHOD__INVOCATIONS:
				return invocations != null && !invocations.isEmpty();
			case TracePackage.TRC_METHOD__SOURCE_INFO:
				return sourceInfo != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", name: ");
		result.append(name);
		result.append(", signature: ");
		result.append(signature);
		result.append(", modifier: ");
		result.append(modifier);
		result.append(", notation: ");
		result.append(notation);
		result.append(", lineNo: ");
		result.append(lineNo);
		result.append(", baseTime: ");
		result.append(baseTime);
		result.append(", cumulativeTime: ");
		result.append(cumulativeTime);
		result.append(", calls: ");
		result.append(calls);
		result.append(')');
		return result.toString();
	}

} //TRCMethodImpl
