package org.eclipse.hyades.ui.sample.svg.generator;
/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

/**
 * Representation of a Data Set
 * 
 * @version 1.6
 */
public class DataSet {
    private int position = 0;
    private String label = null;
    private String flyoverLabel = null;
    private String dataRange1Ref = null;
    private String dataRange2Ref = null;
    private double total = 0;
    private DataPoint[] dataPoints= null;
    

    /**
     *  Constructor
     * @param position order of the data set. The first dataset is at position 0.
     */        
    public DataSet(int position) {
        setPosition(position);
    }
    
    /**
     *  Getter for label
     */
    public String getLabel() { return label; }
    /**
     *  Setter for label
     */
    public void setLabel(String label) { this.label = label; }
   
    /**
     *  Getter for fly-over label
     */
    public String getFlyoverLabel() { return flyoverLabel; }
    /**
     *  Setter for fly-over label
     */
    public void setFlyoverLabel(String flyoverLabel) { this.flyoverLabel = flyoverLabel; }
   
    /**
     *  Getter for DataRange1Ref
     */
    public String getDataRange1Ref() { return dataRange1Ref; }
    /**
     *  Setter for DataRange1Ref
     */
    public void setDataRange1Ref(String dataRange1Ref) { this.dataRange1Ref = dataRange1Ref; }
   
    /**
     *  Getter for DataRange2Ref
     */
    public String getDataRange2Ref() { return dataRange2Ref; }
    /**
     *  Setter for DataRange2Ref
     */
    public void setDataRange2Ref(String dataRange2Ref) { this.dataRange2Ref = dataRange2Ref; }
   
    /**
     *  Getter for Position
     */
    public int getPosition() { return position; }
    /**
     *  Setter for Position
     */
    public void setPosition(int position) { this.position = position; }
    
    /**
     *  Getter for Total
     */
    public double getTotal() { return total; }
    /**
     *  Setter for Total
     */
    public void setTotal(double total) { this.total = total; }

    /**
     *  Getter for data points
     */
    public DataPoint[] getDataPoints() { return dataPoints; }
    /**
     *  Setter for data points
     */
    public void setDataPoints(DataPoint[] dataPoints) { this.dataPoints = dataPoints; }
    
	/**
	 *  Return the data point with the given value1 string
	 *  @param value1 the value to match
	 *  @return DataPoint the data point with the given value1. Returns null if none found.
	 */
	public DataPoint findDataPoint(double value1) {
		for(int i=0; i < dataPoints.length; i++) {
			if (dataPoints[i].getValue1() == value1) {
				return dataPoints[i];
			}
		}
		return null;
	}

}
