/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.SaveUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

/*
* CONTEXT_ID save0000 for save to local action
*/
public class SaveAction extends SelectionProviderAction
	implements ISelectionChangedListener, IRunnableWithProgress {
	
	private INavigator fViewer;
	private Object[] fSelections;
	private IResource fResSelection;
	private IResource[] fResSelections;
	private Shell fShell;

	public SaveAction(INavigator viewer) {
		super(viewer.getViewer(), UIPlugin.getResourceString("SAVE"));
		setDescription(UIPlugin.getResourceString("SAVE"));
		PDPluginImages.setImageDescriptors(this, PDPluginImages.T_LCL, PDPluginImages.IMG_SAVE);
		fViewer = viewer;

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			this,
			UIPlugin.getPluginId() + ".save0000");

	}
	public void run() {
		String title = UIPlugin.getResourceString("TRACE_MSG");
		String msg = "";

		ISelection sel =
			(ISelection) getSelection();
		if(sel instanceof IStructuredSelection)
			fSelections = ((IStructuredSelection)sel).toArray();
		else
			return;
		
		fShell = fViewer.getViewSite().getShell();
		
		if(sel != null && !sel.isEmpty())
		{
			if(((IStructuredSelection)sel).size()==1 && ((IStructuredSelection)sel).getFirstElement()!=null && ((IStructuredSelection)sel).getFirstElement() instanceof IProject){
				msg = UIPlugin.getResourceString("SAVE_PROJECT_Q");
			}else{
				msg = UIPlugin.getResourceString("SAVE_RES_Q");
			}
		}

		if (!MessageDialog
			.openQuestion(
				fShell,
				UIPlugin.getResourceString("SAVTOLOCACT_DIA_TITLE"),
				msg))
			return;

		int j = 0;
		int s = ((IStructuredSelection)sel).size();
		fResSelections = new IResource[s];
		for (Iterator iter = ((IStructuredSelection)sel).iterator(); iter.hasNext();) {
			fResSelections[j++] =
				HyadesUtil.getSelectionFolder(iter.next());
			
		}		

		fResSelection = fResSelections[0];

		try {
			new ProgressMonitorDialog(fShell).run(
				true,
				true,
				new WorkspaceModifyDelegatingOperation(this));
		} catch (InterruptedException e) {
			try {
				if (fResSelection != null && fResSelection.exists())
					fResSelection.getProject().refreshLocal(
						IResource.DEPTH_INFINITE,
						null);
			} catch (CoreException exc) {
				exc.printStackTrace();
			}

			fResSelection = null;
			fResSelections = null;

			return;

		} catch (InvocationTargetException e) {
			e.printStackTrace();

			fResSelection = null;
			fResSelections = null;

			return;
		}

		try {
			if (fResSelection != null && fResSelection.exists())
				fResSelection.getProject().refreshLocal(
					IResource.DEPTH_INFINITE,
					null);
		} catch (CoreException exc) {
			exc.printStackTrace();
		}

		fResSelection = null;
		fResSelections = null;

	}

	protected INavigator getViewer(){
		return fViewer;
	}
	public ISelection getSelection(){
		return fViewer.getViewer().getSelection();
	}
	
	public void run(IProgressMonitor monitor) {
		SaveUtil.save(Arrays.asList(fSelections), monitor, fViewer.getID());
	}
	
	public void selectionChanged(IStructuredSelection selection) {
		setEnabled(true);
	}

	public void dispose() {
		super.dispose();
		fViewer = null;
		fResSelection = null;
		fResSelections = null;
		fShell = null;
		fSelections = null;
	}
}
