/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;

public class ProfileJavaApplicationDelegate extends AbstractJavaLaunchConfigurationDelegate {

	public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
		try {
			monitor.beginTask("", 4);
			boolean success = performProfilingTypesLaunch(conf);
			monitor.worked(1);
			
			if (!success) {
				monitor.setCanceled(true);
				return;
			}
	
			ProfilingSetsManager manager = ProfilingSetsManager.instance();
			IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
	
			TraceArguments args = new TraceArguments(getMainTypeName(conf));
			args.setClassPath(getClasspathString(conf));
			args.setParameters(getProgramArguments(conf));
			args.setVMArguments(getVMArguments(conf));
			args.setEnvironmentVariable(manager.getEnvironmentVariables(conf));
			args.setAutoMonitoring(manager.getAutoMonitoring(conf));
			monitor.worked(1);
			
			String hostName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
			int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt(HyadesConstants.LOCALHOST_PORT));
			String projectName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString(TraceConstants.TRACE_PROJECT_NAME));
			String monitorName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString(TraceConstants.TRACE_MONITOR_NAME));
	
			args.setHostName(hostName);
			args.setPortNumber(port);
	
			if (conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false))
				args.setProfileFile(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String) null));
	
			ArrayList filters = manager.getFilters(conf);
			Vector options = manager.getOptions(conf);
			monitor.worked(1);
			
			PDCoreUtil.launchTrace(args, filters, options, projectName, monitorName, launch);
			monitor.worked(1);
		}
		catch (CoreException e) {
			monitor.setCanceled(true);
			throw e;
		}
	}

	public static boolean performProfilingTypesLaunch(ILaunchConfiguration config) {
		boolean success = true;

		ProfilingSetsManager manager = ProfilingSetsManager.instance();
		IProfilingSet set = null;
		try {
			String setID = config.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, (String)null);
			set = (IProfilingSet)manager.getProfilingSets().get(setID);
		}
		catch (CoreException e) {
			HyadesUIPlugin.logError(e);
		}

		if (set == null) {
			return true;
		}

		IProfilingSetType[] profilingTypes = new ProfilingSetType[manager.getProfilingTypes().size()];
		profilingTypes = (IProfilingSetType[]) manager.getProfilingTypes().values().toArray(profilingTypes);

		List types = set.getProfilingTypes();
		for (int i = 0; i < profilingTypes.length; i++) {
			if (types.contains(profilingTypes[i].getId())) {
				IProfilingType type = profilingTypes[i].getProfilingType();
				final String msg = type.launch(config);
				if (msg != null) {
					Display.getDefault().asyncExec(new Runnable() {
						public void run() {
							MessageDialog.openError(Display.getDefault().getActiveShell(), UIPlugin.getResourceString("ERROR_DLG_CONFLICTS_TITLE"), msg);
						}
					});
					return false;
				}
			}
		}
		return true;
	}

	private String getClasspathString(ILaunchConfiguration conf) throws CoreException {
		String classPath = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, (String) null);

		if (classPath == null) {
			StringBuffer buf = new StringBuffer();
			String[] entries = getClasspath(conf);
			for (int i = 0; i < entries.length - 1; ++i) {
				buf.append(entries[i]);
				buf.append(File.pathSeparatorChar);
			}
			buf.append(entries[entries.length - 1]);
			return buf.toString();
		}
		else {
			return classPath;
		}
	}
}
