/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.piclient;

import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.swt.widgets.Display;


public class PIAttachListener extends PIProcessListener
{   
  /**
 * PIProcessListener constructor comment.
 */
public PIAttachListener(TRCNode node)
{
	super(node);
}
public PIAttachListener(TRCNode node, TRCProcessProxy process)
{
	super(node, process);
}
/**
 * Insert the method's description here.
 * Creation date: (11/9/00 10:36:06 AM)
 * @param command com.ibm.etools.logging.tracing.control.Agent
 */
public synchronized void agentActive(Agent ag)
{
	if(fProcess == null)
	  return;
    if(_monitoredAgents.contains(ag.getName()))
        _monitor = false; 
    else
    	_monitoredAgents.add(ag.getName());    	        
    if(!_monitor)
      return;

	TRCAgentProxy agentProxy = PDCoreUtil.getCorrespondingAgent(fProcess,ag,true);
	
	if(agentProxy == null)
	  return;

	/* set the runtime UUID of the agent */
	agentProxy.setRuntimeId(ag.getUUID());
	agentProxy.setActive(true);
	agentProxy.setAttached(true);
	agentProxy.setProfileFile(ag.getProfileFile());
		
//	agent.setAgentInstance(ag);
	LoadersUtils.registerAgentInstance(agentProxy,ag);

	giveControl(agentProxy, true, true);
	
	final TRCAgentProxy agentTemp = agentProxy;
	Display.getDefault().asyncExec(new Runnable() {
	public void run()
	{
		//update ui
		ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
		event.setSource(agentTemp);
		event.setType(ProfileEvent.START_MONITOR);
		UIPlugin.getDefault().notifyProfileEventListener(event);	            
	}});
	giveControl(agentProxy, false, true);
	
}
}
