/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import java.util.Map;

import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;
import org.eclipse.hyades.models.hierarchy.impl.UnresolvedCorrelationImpl;


/**
 * @author slavescu
 */
public class HierarchyLookupService extends GenericLookupService {
    //~ Constructors -------------------------------------------------------------------------------

    /**
     *
     */
    public HierarchyLookupService() {
        super();

        types.add(AgentsContext.class);
        types.add(AgentProxyContext.class);
        types.add(HierarchyContext.class);
        types.add(UnresolvedCorrelationImpl.class);
		types.add(CorrelationEngine.class);
    }

    //~ Methods ------------------------------------------------------------------------------------

    protected boolean doProcessObject(Map typeMap, Class type, Object object, boolean remove) {
        if (object == null) {
            return false;
        }

        if (type == HierarchyContext.class) {
            HierarchyContext c = (HierarchyContext) object;

            String uri = c.getContextURI();

            if (uri != null) {
                addOrRemove(typeMap, uri, object, remove);

                return true;
            }
        } else if (type == AgentsContext.class) {
            if (((AgentsContext) object).getId() != null) {
                addOrRemove(typeMap, LoadersUtils.getLookUpKey(((AgentsContext) object).getId()), object, remove);

                return true;
            }
        } else if (type == AgentProxyContext.class) {
            AgentProxyContext c = (AgentProxyContext) object;

            if ((c.getAgentProxy() != null)) {
                addOrRemove(typeMap, LoadersUtils.getLookUpKey(c.getAgentProxy().hashCode()), object, remove);

                return true;
            }
		} else if (type == CorrelationEngine.class) {
			CorrelationEngine c = (CorrelationEngine) object;

			addOrRemove(typeMap, c.getId(), object, remove);

			return true;
        } else if (type == UnresolvedCorrelationImpl.class) {
            UnresolvedCorrelation c = (UnresolvedCorrelation) object;

            if ((c.getContextId() != null)) {
                addOrRemove(typeMap, c.getContextId(), object, remove);

                return true;
            }
        }

        return false;
    }
}
