/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Abstract TRC Collection Boundary</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.AbstractTRCCollectionBoundaryImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.AbstractTRCCollectionBoundaryImpl#getStartTime <em>Start Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.AbstractTRCCollectionBoundaryImpl#getCollectionMode <em>Collection Mode</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.AbstractTRCCollectionBoundaryImpl#getConfiguration <em>Configuration</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class AbstractTRCCollectionBoundaryImpl extends EObjectImpl  implements AbstractTRCCollectionBoundary {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartTime()
	 * @generated
	 * @ordered
	 */
	protected static final double START_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartTime()
	 * @generated
	 * @ordered
	 */
	protected double startTime = START_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCollectionMode() <em>Collection Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectionMode()
	 * @generated
	 * @ordered
	 */
	protected static final TRCCollectionMode COLLECTION_MODE_EDEFAULT = TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL;

	/**
	 * The cached value of the '{@link #getCollectionMode() <em>Collection Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectionMode()
	 * @generated
	 * @ordered
	 */
	protected TRCCollectionMode collectionMode = COLLECTION_MODE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getConfiguration() <em>Configuration</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConfiguration()
	 * @generated
	 * @ordered
	 */
	protected TRCConfiguration configuration = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AbstractTRCCollectionBoundaryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return HierarchyPackage.eINSTANCE.getAbstractTRCCollectionBoundary();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getStartTime() {
		return startTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartTime(double newStartTime) {
		double oldStartTime = startTime;
		startTime = newStartTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__START_TIME, oldStartTime, startTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCCollectionMode getCollectionMode() {
		return collectionMode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCollectionMode(TRCCollectionMode newCollectionMode) {
		TRCCollectionMode oldCollectionMode = collectionMode;
		collectionMode = newCollectionMode == null ? COLLECTION_MODE_EDEFAULT : newCollectionMode;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__COLLECTION_MODE, oldCollectionMode, collectionMode));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCConfiguration getConfiguration() {
		if (configuration != null && configuration.eIsProxy()) {
			TRCConfiguration oldConfiguration = configuration;
			configuration = (TRCConfiguration)eResolveProxy((InternalEObject)configuration);
			if (configuration != oldConfiguration) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__CONFIGURATION, oldConfiguration, configuration));
			}
		}
		return configuration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCConfiguration basicGetConfiguration() {
		return configuration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConfiguration(TRCConfiguration newConfiguration) {
		TRCConfiguration oldConfiguration = configuration;
		configuration = newConfiguration;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__CONFIGURATION, oldConfiguration, configuration));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__NAME:
				return getName();
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__START_TIME:
				return new Double(getStartTime());
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__COLLECTION_MODE:
				return getCollectionMode();
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__CONFIGURATION:
				if (resolve) return getConfiguration();
				return basicGetConfiguration();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__NAME:
				setName((String)newValue);
				return;
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__START_TIME:
				setStartTime(((Double)newValue).doubleValue());
				return;
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__COLLECTION_MODE:
				setCollectionMode((TRCCollectionMode)newValue);
				return;
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__CONFIGURATION:
				setConfiguration((TRCConfiguration)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__NAME:
				setName(NAME_EDEFAULT);
				return;
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__START_TIME:
				setStartTime(START_TIME_EDEFAULT);
				return;
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__COLLECTION_MODE:
				setCollectionMode(COLLECTION_MODE_EDEFAULT);
				return;
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__CONFIGURATION:
				setConfiguration((TRCConfiguration)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__START_TIME:
				return startTime != START_TIME_EDEFAULT;
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__COLLECTION_MODE:
				return collectionMode != COLLECTION_MODE_EDEFAULT;
			case HierarchyPackage.ABSTRACT_TRC_COLLECTION_BOUNDARY__CONFIGURATION:
				return configuration != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", startTime: ");
		result.append(startTime);
		result.append(", collectionMode: ");
		result.append(collectionMode);
		result.append(')');
		return result.toString();
	}

} //AbstractTRCCollectionBoundaryImpl
