package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * A representation of the 'Msg Catalog Token'. A string used as substitution 
 * value for resolving an internationalized message into formatted text. 
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see IMsgCatalogToken 
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */

public interface IMsgCatalogToken {

    /**
     * Returns the value.
     * 
     * The value of the message catalog token.
     * 
     * @return String The value.
     */
    public String getValue();

    /**
     * Sets the value.
     * 
     * The value of the message catalog token.
     * 
     * @param value The value to set.
     */
    public void setValue(String value);

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * @since 1.0.1
     */
    public void init();
}
