/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.trace.CallStackPerThread;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader;
import org.eclipse.hyades.loaders.trace.XMLmethodExitLoader;
import org.eclipse.hyades.models.hierarchy.util.FastList;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCInputOutputContainer;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectValue;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TraceFactory;

public class TraceMethodBaseLoader
extends TraceXMLFragmentLoader {
    protected static final String TICKET = "ticket";
    protected static final String STACK_DEPTH = "stackDepth";
    protected static final String PARAMETER = "parameter";
    protected static final String RETURN_VALUE = "returnValue";
    protected static final String VALUE = "value";
    protected CallStackPerThread cs;
    protected TraceUtils.InvocationPool invocationPool;
    protected TRCClass invokerClass;
    protected TRCClass invokerObjectClass;
    protected TRCFullMethodInvocation fullInvocation;
    protected TRCFullMethodInvocation fullInvoker;
    protected TRCFullTraceObject invokerObject;
    protected TRCMethod invokerMethod;
    protected double deltaBaseTime;
    protected double lastChildExitTime;
    protected double previousSiblingExitTime;
    protected long ticket;
    protected short stackDepth;
    protected TRCObjectValue objectValue;
    protected int childCount;
    protected List inputValues = new FastList();
    protected List outputValues = new FastList();

    protected void updateTimeStatistics() {
        this.invokerMethod.setBaseTime(this.invokerMethod.getBaseTime() + this.deltaBaseTime);
        if (this.invokerObject != null) {
            this.invokerObject.setBaseTime(this.invokerObject.getBaseTime() + this.deltaBaseTime);
            if (this.invokerObjectClass != null) {
                this.invokerObjectClass.setInheritedBaseTime(this.invokerObjectClass.getInheritedBaseTime() + this.deltaBaseTime);
                this.invokerObjectClass.getPackage().setInheritedBaseTime(this.invokerObjectClass.getPackage().getInheritedBaseTime() + this.deltaBaseTime);
                this.invokerObjectClass.getPackage().getProcess().setInheritedBaseTime(this.invokerObjectClass.getPackage().getProcess().getInheritedBaseTime() + this.deltaBaseTime);
            }
        }
        this.invokerClass.setBaseTime(this.invokerClass.getBaseTime() + this.deltaBaseTime);
        this.invokerClass.getPackage().setBaseTime(this.invokerClass.getPackage().getBaseTime() + this.deltaBaseTime);
        this.invokerClass.getPackage().getProcess().setBaseTime(this.invokerClass.getPackage().getProcess().getBaseTime() + this.deltaBaseTime);
        Iterator stackIter = this.cs.iterator();
        while (stackIter.hasNext()) {
            TRCClass objectClass;
            TraceUtils.InvocationInfo invocationInfo = (TraceUtils.InvocationInfo)stackIter.next();
            if (!invocationInfo.isObjectLocked()) {
                TRCFullTraceObject obj = invocationInfo.getObject();
                obj.setCumulativeTime(obj.getCumulativeTime() + this.deltaBaseTime);
            }
            if ((objectClass = invocationInfo.getObjectClass()) != null && !invocationInfo.isObjectClassLocked()) {
                objectClass.setInheritedCumulativeTime(objectClass.getInheritedCumulativeTime() + this.deltaBaseTime);
                objectClass.getPackage().setInheritedCumulativeTime(objectClass.getPackage().getInheritedCumulativeTime() + this.deltaBaseTime);
                objectClass.getPackage().getProcess().setInheritedCumulativeTime(objectClass.getPackage().getProcess().getInheritedCumulativeTime() + this.deltaBaseTime);
            }
            if (!invocationInfo.isMethodLocked()) {
                invocationInfo.getMethod().setCumulativeTime(invocationInfo.getMethod().getCumulativeTime() + this.deltaBaseTime);
            }
            if (invocationInfo.isClassLocked()) continue;
            this.invokerClass = invocationInfo.getTheClass();
            this.invokerClass.setCumulativeTime(this.invokerClass.getCumulativeTime() + this.deltaBaseTime);
            this.invokerClass.getPackage().setCumulativeTime(this.invokerClass.getPackage().getCumulativeTime() + this.deltaBaseTime);
            this.invokerClass.getPackage().getProcess().setCumulativeTime(this.invokerClass.getPackage().getProcess().getCumulativeTime() + this.deltaBaseTime);
        }
    }

    protected TRCClass getExtendedClass(TRCObject anObject, TRCClass aClass) {
        if (anObject != null && anObject.getIsA() != aClass && anObject.getIsA() != this.theProcess.getClassClass()) {
            return anObject.getIsA();
        }
        return null;
    }

    protected void setMaxStackDepth(TRCThread theThread) {
        if (theThread == null) {
            return;
        }
        if (this.stackDepth > theThread.getMaxStackDepth()) {
            theThread.setMaxStackDepth(this.stackDepth);
        }
    }

    public void startChild(String name) {
        ++this.childCount;
        if (name.equals(PARAMETER)) {
            this.objectValue = TraceFactory.eINSTANCE.createTRCObjectValue();
            this.inputValues.add(this.objectValue);
        } else if (name.equals(RETURN_VALUE)) {
            this.objectValue = TraceFactory.eINSTANCE.createTRCObjectValue();
            this.outputValues.add(this.objectValue);
        }
    }

    public void endChild(String name) {
        this.objectValue = null;
    }

    public void addInputOutputValues() {
        List l = (List)this.getInputOutputContainer().getEntries().get((Object)this.fullInvocation);
        if (l == null) {
            l = new FastList();
            this.getInputOutputContainer().getEntries().put((Object)this.fullInvocation, (Object)l);
            l = (List)this.getInputOutputContainer().getEntries().get((Object)this.fullInvocation);
        }
        if (!this.outputValues.isEmpty()) {
            this.getInputOutputContainer().getInputOutputValues().add(this.outputValues.get(this.outputValues.size() - 1));
            l.set(0, this.outputValues.get(this.outputValues.size() - 1));
        } else if (l.isEmpty()) {
            TRCObjectValue objectValue = TraceFactory.eINSTANCE.createTRCObjectValue();
            this.getInputOutputContainer().getInputOutputValues().add((Object)objectValue);
            l.add(objectValue);
        }
        if (!this.inputValues.isEmpty()) {
            this.getInputOutputContainer().getInputOutputValues().addAll((Collection)this.inputValues);
            if (this instanceof XMLmethodExitLoader && l.size() < this.inputValues.size() + 1) {
                for (int i = 0; i < this.inputValues.size(); ++i) {
                    l.add(TraceFactory.eINSTANCE.createTRCObjectValue());
                }
            }
            l.addAll(this.inputValues);
        }
    }

    protected TRCInputOutputContainer getInputOutputContainer() {
        TRCInputOutputContainer inputOutputContainer = this.getProcess().getInputOutputContainer();
        if (inputOutputContainer == null) {
            inputOutputContainer = TraceFactory.eINSTANCE.createTRCInputOutputContainer();
            inputOutputContainer.setProcess(this.getProcess());
            Resource r = this.createInputOutputContainerResource(inputOutputContainer);
            r.getContents().add((Object)inputOutputContainer);
        }
        return inputOutputContainer;
    }

    private Resource createInputOutputContainerResource(TRCInputOutputContainer inputOutputContainer) {
        String uri = inputOutputContainer.getProcess().eResource().getURI().toString();
        String newUri = uri.substring(0, uri.indexOf(".trca"));
        newUri = newUri.concat(".trciov").concat(uri.substring(uri.indexOf(".trca") + 5));
        return HierarchyResourceSetImpl.getInstance().createResource(SaveUtil.createURI((String)newUri));
    }
}

