/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.editors.IDetails;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditor;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;

public class DirectiveDetails
extends Composite
implements IDetails,
Listener {
    private CCombo cmbDirective;
    private Text txtInfo;
    private Text txtFFDC;
    private ArrayList directiveRegistry = null;
    private SymptomDBEditor editor;
    private SDBFactoryImpl objFactory = null;
    private SDBDirective currentSel = null;
    private boolean isDisplaying = false;
    private final String NL = System.getProperties().getProperty("line.separator");

    public DirectiveDetails(RASWidgetFactory factory, Composite composite, int style) {
        super(composite, style);
        GridLayout solLayout = new GridLayout();
        solLayout.numColumns = 1;
        this.setLayout((Layout)solLayout);
        this.setLayoutData(GridUtil.createFill());
        Label lblDirective = factory.createLabel(this, SDbPlugin.getResourceString("STR_DIRECTIVE_LABEL"), 0);
        this.cmbDirective = factory.createCombo(this, 8);
        GridData cmbGrid = new GridData(768);
        cmbGrid.widthHint = 350;
        this.cmbDirective.setLayoutData((Object)cmbGrid);
        factory.createCompositeSeparator(this);
        Label lblInfo = factory.createLabel(this, SDbPlugin.getResourceString("STR_DIRECTIVE_DESC_LABEL"), 0);
        GridData lblInfoGrid = new GridData(768);
        lblInfo.setLayoutData((Object)lblInfoGrid);
        this.txtInfo = factory.createText(this, "", 770);
        GridData infoGrid = new GridData(1808);
        infoGrid.widthHint = 350;
        this.txtInfo.setLayoutData((Object)infoGrid);
        Label lblFFDC = factory.createLabel(this, SDbPlugin.getResourceString("STR_FFDC_LABEL"), 0);
        lblInfoGrid = new GridData(768);
        lblFFDC.setLayoutData((Object)lblInfoGrid);
        this.txtFFDC = factory.createText(this, "", 0);
        infoGrid = new GridData(768);
        infoGrid.widthHint = 350;
        this.txtFFDC.setLayoutData((Object)infoGrid);
        WorkbenchHelp.setHelp((Control)this.cmbDirective, (String)ContextIds.SYMDB_EDITOR_DIRECTIVE);
        WorkbenchHelp.setHelp((Control)this.txtInfo, (String)ContextIds.SYMDB_EDITOR_DIRECTIVE_DESCRIPTION);
        WorkbenchHelp.setHelp((Control)this.txtFFDC, (String)ContextIds.SYMDB_EDITOR_DIRECTIVE_FFDC);
        this.cmbDirective.addListener(13, (Listener)this);
        this.txtInfo.addListener(24, (Listener)this);
        this.txtFFDC.addListener(24, (Listener)this);
    }

    public void init(SymptomDBEditor editor) {
        this.editor = editor;
        this.objFactory = SDbPlugin.getDefault().getSDBFactory();
        EList directives = editor.getModel().getDirectives();
        this.cmbDirective.add(SDbPlugin.getResourceString("STR_NEW_DIRECTIVE_LABEL"));
        for (int i = 0; i < directives.size(); ++i) {
            this.cmbDirective.add(this.getFirstLineFrom(((SDBDirective)directives.get(i)).getDescription()));
        }
        this.directiveRegistry = new ArrayList();
        SDBDirective newDir = this.objFactory.createSDBDirective();
        newDir.setDescription(SDbPlugin.getResourceString("STR_NEW_DIRECTIVE_LABEL"));
        newDir.setDirectiveString("");
        this.directiveRegistry.add(0, newDir);
        this.directiveRegistry.addAll(directives);
    }

    public void display(EObject object) {
        this.isDisplaying = true;
        this.currentSel = (SDBDirective)object;
        String desc = this.currentSel.getDescription();
        this.txtInfo.setText(desc);
        this.cmbDirective.setText(this.getFirstLineFrom(desc));
        this.txtFFDC.setText(this.currentSel.getDirectiveString());
        if (this.directiveRegistry.indexOf(this.currentSel) > -1) {
            this.txtInfo.setText(desc);
            this.cmbDirective.setText(this.getFirstLineFrom(desc));
            this.cmbDirective.setEnabled(false);
            this.txtFFDC.setText(this.currentSel.getDirectiveString());
        } else {
            this.cmbDirective.setEnabled(true);
            this.cmbDirective.select(0);
        }
        this.isDisplaying = false;
    }

    public void setFocusToTextBox() {
        this.txtInfo.setFocus();
        this.txtInfo.setSelection(0, this.txtInfo.getText().length());
    }

    public boolean updateCurrentSelection(EObject currentSelection) {
        if (this.cmbDirective.getSelectionIndex() == 0) {
            this.currentSel = (SDBDirective)currentSelection;
            this.currentSel.setDescription(this.txtInfo.getText());
            this.currentSel.setDirectiveString(this.txtFFDC.getText());
            if (this.directiveRegistry.indexOf(this.currentSel) < 0) {
                this.updateDirectiveRegistry(this.currentSel, true);
            }
        } else if (this.cmbDirective.isEnabled()) {
            SDBSolution parent = (SDBSolution)this.editor.detailsPage.getParentOfCurrentSel();
            SDBRuntime db = (SDBRuntime)this.editor.detailsPage.getTreeRoot();
            this.updateDirectiveRegistry(this.currentSel, false);
            this.currentSel.setDescription(this.txtInfo.getText());
            this.currentSel.setDirectiveString(this.txtFFDC.getText());
            this.currentSel.getSolutions().add((Object)parent);
            this.updateDirectiveRegistry(this.currentSel, true);
            this.removeNewDirective((SDBDirective)currentSelection, parent, db);
        } else {
            this.updateDirectiveRegistry(this.currentSel, false);
            this.currentSel = (SDBDirective)currentSelection;
            this.currentSel.setDescription(this.txtInfo.getText());
            this.currentSel.setDirectiveString(this.txtFFDC.getText());
            this.updateDirectiveRegistry(this.currentSel, true);
        }
        return true;
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.cmbDirective || source == this.txtInfo || source == this.txtFFDC) {
            boolean status = false;
            if (source == this.cmbDirective) {
                int i = this.cmbDirective.getSelectionIndex();
                this.currentSel = (SDBDirective)this.directiveRegistry.get(i);
                this.txtInfo.setText(this.currentSel.getDescription());
                this.txtFFDC.setText(this.currentSel.getDirectiveString());
            }
            if (source == this.txtInfo && !this.isDisplaying) {
                status = this.editor.validateState((Widget)this.txtInfo, this, this.currentSel.getDescription());
            }
            if (source == this.txtFFDC && !this.isDisplaying) {
                status = this.editor.validateState((Widget)this.txtFFDC, this, this.currentSel.getDirectiveString());
            }
            if (this.currentSel != null && !this.isDisplaying && status) {
                this.editor.updateUIDirtyStatus(true);
                this.editor.updateModelDirtyStatus(true);
            }
        }
    }

    private void removeNewDirective(SDBDirective current, SDBSolution parent, SDBRuntime root) {
        parent.getDirectives().remove((Object)current);
        root.getDirectives().remove((Object)current);
        current.getSolutions().remove((Object)parent);
        this.directiveRegistry.remove(current);
    }

    protected void updateDirectiveRegistry(SDBDirective object, boolean add) {
        if (add) {
            this.directiveRegistry.add(object);
            this.cmbDirective.add(this.getFirstLineFrom(object.getDescription()));
        } else if (this.directiveRegistry.indexOf(object) > -1) {
            this.cmbDirective.remove(this.directiveRegistry.indexOf(object));
            this.directiveRegistry.remove(object);
        }
    }

    private String getFirstLineFrom(String input) {
        int i = 0;
        String line = input;
        i = input.indexOf("\r\n");
        if (i > -1) {
            line = input.substring(0, i);
        } else {
            i = input.indexOf("\n");
            if (i > -1) {
                line = input.substring(0, i);
            }
        }
        return line;
    }

    private String getDirectiveStringFrom(String input) {
        int i = 0;
        String line = "";
        i = input.indexOf("\r\n");
        if (i > -1) {
            line = input.substring(i + 2);
        } else {
            i = input.indexOf("\n");
            if (i > -1) {
                line = input.substring(i + 1);
            }
        }
        return line;
    }
}

