/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.util;

import java.security.Key;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import org.eclipse.hyades.security.SecurityPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CertificateProperties
extends Dialog {
    private String alias;
    private Object cert;

    public CertificateProperties(Shell parentShell) {
        super(parentShell);
    }

    public void init(String alias, Object cert) {
        this.alias = alias;
        this.cert = cert;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(SecurityPlugin.getResourceString("STR_CERTIFICATE_PROP_TITLE"));
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData data = GridUtil.createFill();
        data.widthHint = 450;
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)data);
        Label lblAlias = new Label(content, 0);
        lblAlias.setText(SecurityPlugin.getResourceString("STR_PROP_ALIAS_LBL"));
        data = new GridData();
        data.horizontalIndent = 5;
        lblAlias.setLayoutData((Object)data);
        Label lblAliasValue = new Label(content, 0);
        lblAliasValue.setText(this.alias);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblAliasValue.setLayoutData((Object)data);
        Label lblVersion = new Label(content, 0);
        lblVersion.setText(SecurityPlugin.getResourceString("STR_CERTIF_VERSION_LBL"));
        data = new GridData();
        data.horizontalIndent = 5;
        lblVersion.setLayoutData((Object)data);
        Label lblVersionValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblVersionValue.setLayoutData((Object)data);
        Label lblIssuedTo = new Label(content, 0);
        lblIssuedTo.setText(SecurityPlugin.getResourceString("STR_ISSUED_TO_LBL"));
        data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalIndent = 5;
        lblIssuedTo.setLayoutData((Object)data);
        Text lblIssuedToValue = new Text(content, 2120);
        data = new GridData(768);
        data.heightHint = 60;
        data.horizontalIndent = 5;
        lblIssuedToValue.setLayoutData((Object)data);
        Label lblIssuedBy = new Label(content, 0);
        lblIssuedBy.setText(SecurityPlugin.getResourceString("STR_ISSUED_BY_LBL"));
        data = new GridData();
        data.horizontalIndent = 5;
        data.verticalAlignment = 1;
        lblIssuedBy.setLayoutData((Object)data);
        Text lblIssuedByValue = new Text(content, 2120);
        data = new GridData(768);
        data.horizontalIndent = 5;
        data.heightHint = 60;
        lblIssuedByValue.setLayoutData((Object)data);
        Label lblValidity = new Label(content, 0);
        lblValidity.setText(SecurityPlugin.getResourceString("STR_VALIDITY_LBL"));
        data = new GridData();
        data.horizontalIndent = 5;
        lblValidity.setLayoutData((Object)data);
        Label lblValidityValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblValidityValue.setLayoutData((Object)data);
        Label lblAlgorithm = new Label(content, 0);
        lblAlgorithm.setText(SecurityPlugin.getResourceString("STR_ALGORITHM_LBL"));
        data = new GridData();
        data.horizontalIndent = 5;
        lblAlgorithm.setLayoutData((Object)data);
        Label lblAlgorithmValue = new Label(content, 0);
        data = new GridData(768);
        data.horizontalIndent = 5;
        lblAlgorithmValue.setLayoutData((Object)data);
        if (this.cert instanceof X509Certificate) {
            lblVersionValue.setText(((X509Certificate)this.cert).getType() + " V." + ((X509Certificate)this.cert).getVersion());
            lblIssuedToValue.setText(((X509Certificate)this.cert).getSubjectDN().getName());
            lblIssuedByValue.setText(((X509Certificate)this.cert).getIssuerDN().getName());
            DateFormat df = DateFormat.getDateInstance(1);
            String validity = SecurityPlugin.getResourceString("STR_VALIDITY_PERIOD");
            validity = TString.change(validity, "%1", df.format(((X509Certificate)this.cert).getNotBefore()));
            validity = TString.change(validity, "%2", df.format(((X509Certificate)this.cert).getNotAfter()));
            lblValidityValue.setText(validity);
            lblAlgorithmValue.setText(((X509Certificate)this.cert).getSigAlgName());
        } else if (this.cert instanceof Key) {
            lblVersionValue.setText(((Key)this.cert).getFormat());
            lblAlgorithmValue.setText(((Key)this.cert).getAlgorithm());
        }
        return content;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

