/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.preferences;

import java.util.Vector;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class HttpPreferenceUtil {
    private static HttpPreferenceUtil instance;
    private static String MAXSAVEDIMPORTINFILEPREF;
    private static String MAXSAVEDIMPORTTARGETPREF;
    private static String MAXTHREADSPREF;
    private static String IMPORTASSEPARATEPREF;
    private static String SAVEDIMPORTINFILEROOTPREF;
    private static String SAVEDIMPORTTARGETROOTPREF;
    private static String SAVEDIMPORTTARGETBASENAME;
    private static String DEFAULTHOSTNAME;
    private static String DEFAULTHOSTPORT;
    private static String DEFAULTABSOLUTEPATH;
    private static String DEFAULTTHINKTIME;
    private static String DEFAULTVARIANCE;
    private IPreferenceStore preferenceStore = TestHttpPlugin.getInstance().getPreferenceStore();

    private HttpPreferenceUtil() {
        this.setDefaultValues();
    }

    public static HttpPreferenceUtil getInstance() {
        if (instance == null) {
            instance = new HttpPreferenceUtil();
        }
        return instance;
    }

    private void setDefaultValues() {
        this.preferenceStore.setDefault(MAXTHREADSPREF, 10);
        this.preferenceStore.setDefault(MAXSAVEDIMPORTINFILEPREF, 5);
        this.preferenceStore.setDefault(MAXSAVEDIMPORTTARGETPREF, 5);
        this.preferenceStore.setDefault(DEFAULTHOSTNAME, "");
        this.preferenceStore.setDefault(DEFAULTHOSTPORT, "80");
        this.preferenceStore.setDefault(DEFAULTABSOLUTEPATH, "/");
        this.preferenceStore.setDefault(DEFAULTTHINKTIME, 200L);
        this.preferenceStore.setDefault(DEFAULTVARIANCE, "10");
        this.preferenceStore.setDefault(IMPORTASSEPARATEPREF, false);
        this.preferenceStore.setDefault(SAVEDIMPORTTARGETBASENAME, TestHttpPlugin.getString("preference.TestcaseBaseName"));
    }

    public int getMaxThreads() {
        return this.getMaxThreads(false);
    }

    public int getMaxThreads(boolean bl) {
        if (bl) {
            return this.preferenceStore.getDefaultInt(MAXTHREADSPREF);
        }
        return this.preferenceStore.getInt(MAXTHREADSPREF);
    }

    public void setMaxThreads(int n) {
        this.preferenceStore.setValue(MAXTHREADSPREF, n);
    }

    public String getImportTestcaseBaseName() {
        return this.getImportTestcaseBaseName(false);
    }

    public String getImportTestcaseBaseName(boolean bl) {
        if (bl) {
            return this.preferenceStore.getDefaultString(SAVEDIMPORTTARGETBASENAME);
        }
        return this.preferenceStore.getString(SAVEDIMPORTTARGETBASENAME);
    }

    public void setImportTestcaseBaseName(String string) {
        this.preferenceStore.setValue(SAVEDIMPORTTARGETBASENAME, string);
    }

    public boolean getImportAsSeparate() {
        return this.getImportAsSeparate(false);
    }

    public boolean getImportAsSeparate(boolean bl) {
        if (bl) {
            return this.preferenceStore.getDefaultBoolean(IMPORTASSEPARATEPREF);
        }
        return this.preferenceStore.getBoolean(IMPORTASSEPARATEPREF);
    }

    public void setImportAsSeparate(boolean bl) {
        this.preferenceStore.setValue(IMPORTASSEPARATEPREF, bl);
    }

    public int getSavedInfileHistorySize() {
        return this.getSavedInfileHistorySize(false);
    }

    public int getSavedInfileHistorySize(boolean bl) {
        if (bl) {
            return this.preferenceStore.getDefaultInt(MAXSAVEDIMPORTINFILEPREF);
        }
        return this.preferenceStore.getInt(MAXSAVEDIMPORTINFILEPREF);
    }

    public void setSavedInfileHistorySize(int n) {
        this.preferenceStore.setValue(MAXSAVEDIMPORTINFILEPREF, n);
    }

    public String[] getInfileHistory() {
        int n;
        int n2 = this.getSavedInfileHistorySize();
        Vector<String> vector = new Vector<String>();
        for (n = 1; n <= n2; ++n) {
            String string = this.preferenceStore.getString(SAVEDIMPORTINFILEROOTPREF + "." + n);
            if (string == null || string.equals("")) continue;
            vector.addElement(string);
        }
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    public void addToInfileHistory(String string) {
        int n;
        int n2;
        String[] stringArray = this.getInfileHistory();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals(string)) continue;
            return;
        }
        int n3 = this.preferenceStore.getInt(MAXSAVEDIMPORTINFILEPREF);
        if (n3 < 1) {
            n3 = this.getSavedInfileHistorySize(true);
        }
        if ((n = stringArray.length) < n3) {
            this.preferenceStore.setValue(SAVEDIMPORTINFILEROOTPREF + "." + (n + 1), string);
        } else {
            n2 = n - n3;
            for (int i = 1; i < n3; ++i) {
                this.preferenceStore.setValue(SAVEDIMPORTINFILEROOTPREF + "." + i, stringArray[i + n2]);
            }
            this.preferenceStore.setValue(SAVEDIMPORTINFILEROOTPREF + "." + n3, string);
        }
    }

    public int getSavedTargetHistorySize() {
        return this.getSavedTargetHistorySize(false);
    }

    public int getSavedTargetHistorySize(boolean bl) {
        if (bl) {
            return this.preferenceStore.getDefaultInt(MAXSAVEDIMPORTTARGETPREF);
        }
        return this.preferenceStore.getInt(MAXSAVEDIMPORTTARGETPREF);
    }

    public void setSavedTargetHistorySize(int n) {
        this.preferenceStore.setValue(MAXSAVEDIMPORTTARGETPREF, n);
    }

    public String[] getTargetHistory() {
        int n;
        int n2 = this.getSavedTargetHistorySize();
        Vector<String> vector = new Vector<String>();
        for (n = 1; n <= n2; ++n) {
            String string = this.preferenceStore.getString(SAVEDIMPORTTARGETROOTPREF + "." + n);
            if (string == null || string.equals("")) continue;
            vector.addElement(string);
        }
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    public void addToTargetHistory(String string) {
        int n;
        int n2;
        String[] stringArray = this.getTargetHistory();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals(string)) continue;
            return;
        }
        int n3 = this.preferenceStore.getInt(MAXSAVEDIMPORTTARGETPREF);
        if (n3 < 1) {
            n3 = this.getSavedTargetHistorySize(true);
        }
        if ((n = stringArray.length) < n3) {
            this.preferenceStore.setValue(SAVEDIMPORTTARGETROOTPREF + "." + (n + 1), string);
        } else {
            n2 = n - n3;
            for (int i = 1; i < n3; ++i) {
                this.preferenceStore.setValue(SAVEDIMPORTTARGETROOTPREF + "." + i, stringArray[i + n2]);
            }
            this.preferenceStore.setValue(SAVEDIMPORTTARGETROOTPREF + "." + n3, string);
        }
    }

    public String getDefaultHostName() {
        return this.getDefaultHostName(false);
    }

    public String getDefaultHostName(boolean bl) {
        if (bl) {
            return this.preferenceStore.getDefaultString(DEFAULTHOSTNAME);
        }
        return this.preferenceStore.getString(DEFAULTHOSTNAME);
    }

    public void setDefaultHostName(String string) {
        this.preferenceStore.setValue(DEFAULTHOSTNAME, string);
    }

    public String getDefaultHostPort() {
        return this.getDefaultHostPort(false);
    }

    public String getDefaultHostPort(boolean bl) {
        if (bl) {
            return this.preferenceStore.getDefaultString(DEFAULTHOSTPORT);
        }
        return this.preferenceStore.getString(DEFAULTHOSTPORT);
    }

    public void setDefaultHostPort(String string) {
        this.preferenceStore.setValue(DEFAULTHOSTPORT, string);
    }

    public String getDefaultThinkTime() {
        return this.getDefaultThinkTime(false);
    }

    public String getDefaultThinkTime(boolean bl) {
        if (bl) {
            return this.preferenceStore.getDefaultString(DEFAULTTHINKTIME);
        }
        return this.preferenceStore.getString(DEFAULTTHINKTIME);
    }

    public void setDefaultThinkTime(String string) {
        this.preferenceStore.setValue(DEFAULTTHINKTIME, string);
    }

    public String getDefaultVariance() {
        return this.getDefaultVariance(false);
    }

    public String getDefaultVariance(boolean bl) {
        if (bl) {
            return this.preferenceStore.getDefaultString(DEFAULTVARIANCE);
        }
        return this.preferenceStore.getString(DEFAULTVARIANCE);
    }

    public void setDefaultVariance(String string) {
        this.preferenceStore.setValue(DEFAULTVARIANCE, string);
    }

    public String getDefaultAbsolutePath() {
        return this.getDefaultAbsolutePath(false);
    }

    public String getDefaultAbsolutePath(boolean bl) {
        if (bl) {
            return this.preferenceStore.getDefaultString(DEFAULTABSOLUTEPATH);
        }
        return this.preferenceStore.getString(DEFAULTABSOLUTEPATH);
    }

    public void setDefaultAbsolutePath(String string) {
        this.preferenceStore.setValue(DEFAULTABSOLUTEPATH, string);
    }

    static {
        MAXSAVEDIMPORTINFILEPREF = "MaxSavedImportInfile";
        MAXSAVEDIMPORTTARGETPREF = "MaxSavedImportTarget";
        MAXTHREADSPREF = "MaximumThreadsInGeneratedCode";
        IMPORTASSEPARATEPREF = "ImportAsSeparate";
        SAVEDIMPORTINFILEROOTPREF = "SavedImportInfile";
        SAVEDIMPORTTARGETROOTPREF = "SavedImportTarget";
        SAVEDIMPORTTARGETBASENAME = "SavedImportTCBaseName";
        DEFAULTHOSTNAME = "DefaultHostName";
        DEFAULTHOSTPORT = "DefaultHostPort";
        DEFAULTABSOLUTEPATH = "DefaultAbsolutePath";
        DEFAULTTHINKTIME = "DefaultThinkTime";
        DEFAULTVARIANCE = "DefaultVariance";
    }
}

