/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.reports.hitrate;

import org.eclipse.hyades.test.http.internal.reports.IReportGraphDataProvider;

public class HitRateData
implements IReportGraphDataProvider {
    private static int counter = 1;
    String id = null;
    long count = 0L;
    long numberHits = 0L;
    long elapsedTime = 0L;
    static long elapsedTimeForTest = 0L;
    static long totalNumberHits = 0L;

    public HitRateData(String string) {
        this.id = string;
    }

    public void addHit(long l) {
        ++this.numberHits;
        ++totalNumberHits;
        this.elapsedTime += l;
        elapsedTimeForTest += l;
    }

    public static int getNextCounter() {
        return ++counter;
    }

    public static void resetCounter() {
        counter = 1;
        totalNumberHits = 0L;
        elapsedTimeForTest = 0L;
    }

    public String getId() {
        return this.id;
    }

    public String getValue() {
        double d = new Double(this.numberHits);
        double d2 = new Double(elapsedTimeForTest);
        double d3 = 1000.0;
        double d4 = d / (d2 / d3);
        return new Double(d4).toString();
    }

    public static void setTestElapsedTime(long l) {
        elapsedTimeForTest = l;
    }

    public static String getOverallHitRate() {
        return new Double((double)totalNumberHits / new Double((double)elapsedTimeForTest / 1000.0)).toString();
    }

    static class OverallHitRate
    implements IReportGraphDataProvider {
        OverallHitRate() {
        }

        public String getId() {
            return "Overall Hit Rate";
        }

        public String getValue() {
            return HitRateData.getOverallHitRate();
        }
    }
}

