/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.ReferenceTablePage;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.part.IPage;

public class ReferenceTableViewer
extends TraceViewer {
    protected Action _openSource;
    protected Action _referee;
    protected Action _referands;
    protected final String _title = TraceUIPlugin.getString("STR_REFERENCE_TABLE");

    public TraceViewerPage createPage(EObject mofObject) {
        return new ReferenceTablePage(mofObject, this);
    }

    public void dispose() {
        Enumeration pages = this._pages.elements();
        while (pages.hasMoreElements()) {
            IPage page = (IPage)pages.nextElement();
            if (!(page instanceof ReferenceTablePage)) continue;
            ((ReferenceTablePage)page).dispose();
        }
        this._referands = null;
        this._referee = null;
        super.dispose();
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        String referandsStr = TraceUIPlugin.getString("STR_REFERANDS");
        this._referands = new Action(referandsStr){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("obj_ref_display", 0);
                TraceUIPlugin.getDefault().notifyRefChangedEventListener();
            }
        };
        this._referands.setText(referandsStr);
        this._referands.setDescription(referandsStr);
        this._referands.setToolTipText(referandsStr);
        int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        this._referands.setChecked(ref == 0);
        String refereeStr = TraceUIPlugin.getString("STR_REFEREE");
        this._referee = new Action(refereeStr){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("obj_ref_display", 1);
                TraceUIPlugin.getDefault().notifyRefChangedEventListener();
            }
        };
        this._referee.setText(refereeStr);
        this._referee.setDescription(refereeStr);
        this._referee.setToolTipText(refereeStr);
        this._referee.setChecked(ref == 1);
        String openSourceStr = TraceUIPlugin.getString("STR_SOURCE");
        this._openSource = new Action(openSourceStr){

            public void run() {
                ReferenceTablePage page = (ReferenceTablePage)ReferenceTableViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(page.getMOFObject()).getFirstElement());
            }
        };
        this._openSource.setText(openSourceStr);
        TracePluginImages.setImageDescriptors((IAction)this._openSource, "tool16", "opensource_co.gif");
        this._openSource.setDescription(openSourceStr);
        this._openSource.setToolTipText(openSourceStr);
        IMenuManager menum = this.getViewSite().getActionBars().getMenuManager();
        menum.add((IAction)this._referands);
        menum.add((IAction)this._referee);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._openSource);
        tbm.add((IContributionItem)new Separator());
        this.getViewSite().getActionBars().updateActionBars();
    }

    public Action openSource() {
        return this._openSource;
    }

    public Action referands() {
        return this._referands;
    }

    public Action referee() {
        return this._referee;
    }

    public void setFocus() {
        if (this.getCurrentPage() != null) {
            ((ReferenceTablePage)this.getCurrentPage()).setFocus();
        }
    }

    public boolean isValidObject(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof TRCMonitor || object instanceof TRCNode) {
            return true;
        }
        if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Profiler")) {
            return true;
        }
        if (object instanceof TRCProcessProxy) {
            EList agents = ((TRCProcessProxy)object).getAgentProxies();
            for (int idx = 0; idx < agents.size(); ++idx) {
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (agent == null || agent.eIsProxy() || !agent.getType().equals("Profiler")) continue;
                return true;
            }
        }
        return false;
    }

    public EObject getObjectToView(EObject selObject) {
        if (selObject == null) {
            return selObject;
        }
        if (selObject instanceof TRCProcessProxy) {
            int nbOfAgents = 0;
            TRCAgentProxy a = null;
            EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
            for (int idx = 0; idx < agents.size(); ++idx) {
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (agent == null || agent.eIsProxy() || !agent.getType().equals("Profiler")) continue;
                ++nbOfAgents;
                a = agent;
            }
            if (nbOfAgents == 1) {
                return a;
            }
        }
        return selObject;
    }

    public String getViewTitle() {
        return this._title;
    }
}

