/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.internal.util.ColorEditor;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.SpectrumColorMap;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class GraphColorUI {
    private FontFieldEditor fontEditor;
    private ColorEditor fClassColorEditor;
    private ColorEditor fBackgroundColorEditor;
    private Button fBackgroundDefaultRadioButton;
    private Button fBackgroundCustomRadioButton;
    private Button fBackgroundColorButton;
    private Button fClassCustomRadioButton;
    private Button fClassDefaultRadioButton;
    private Button fClassColorButton;
    private ColorEditor fSelectionColorEditor;
    private Button fSelectionColorButton;
    private ColorEditor fUnknownColorEditor;
    private Button fUnknownColorButton;

    public Control createContents(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Composite backgroundComposite = new Composite(colorComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        backgroundComposite.setLayout((Layout)layout);
        Label label = new Label(backgroundComposite, 0);
        label.setText(TraceUIPlugin.getString("BACKGROUND_COLOR_GRP"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        SelectionListener backgroundSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean custom = GraphColorUI.this.fBackgroundCustomRadioButton.getSelection();
                GraphColorUI.this.fBackgroundColorButton.setEnabled(custom);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fBackgroundDefaultRadioButton = new Button(backgroundComposite, 16400);
        this.fBackgroundDefaultRadioButton.setText(TraceUIPlugin.getString("BACKGROUND_DEFAULT"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fBackgroundDefaultRadioButton.setLayoutData((Object)gd);
        this.fBackgroundDefaultRadioButton.addSelectionListener(backgroundSelectionListener);
        this.fBackgroundCustomRadioButton = new Button(backgroundComposite, 16400);
        this.fBackgroundCustomRadioButton.setText(TraceUIPlugin.getString("BACKGROUND_CUSTOM"));
        this.fBackgroundCustomRadioButton.addSelectionListener(backgroundSelectionListener);
        this.fBackgroundColorEditor = new ColorEditor(backgroundComposite);
        this.fBackgroundColorButton = this.fBackgroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        this.fBackgroundColorButton.setLayoutData((Object)gd);
        Composite classComposite = new Composite(colorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        classComposite.setLayout((Layout)layout);
        label = new Label(classComposite, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label = new Label(classComposite, 0);
        label.setText(TraceUIPlugin.getString("CLASS_COLOR_GRP"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        SelectionListener classSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean custom = GraphColorUI.this.fClassCustomRadioButton.getSelection();
                GraphColorUI.this.fClassColorButton.setEnabled(custom);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fClassDefaultRadioButton = new Button(classComposite, 16400);
        this.fClassDefaultRadioButton.setText(TraceUIPlugin.getString("CLASS_COLOR_RANDOM"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fClassDefaultRadioButton.setLayoutData((Object)gd);
        this.fClassDefaultRadioButton.addSelectionListener(classSelectionListener);
        this.fClassCustomRadioButton = new Button(classComposite, 16400);
        this.fClassCustomRadioButton.setText(TraceUIPlugin.getString("CLASS_COLOR_ONE"));
        this.fClassCustomRadioButton.addSelectionListener(classSelectionListener);
        this.fClassColorEditor = new ColorEditor(classComposite);
        this.fClassColorButton = this.fClassColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        this.fClassColorButton.setLayoutData((Object)gd);
        Composite otherComposite = new Composite(colorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        otherComposite.setLayout((Layout)layout);
        label = new Label(otherComposite, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label = new Label(otherComposite, 16384);
        label.setText(TraceUIPlugin.getString("UNKNOWN_CLASS_COLOR"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fUnknownColorEditor = new ColorEditor(otherComposite);
        this.fUnknownColorButton = this.fUnknownColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        this.fUnknownColorButton.setLayoutData((Object)gd);
        label = new Label(otherComposite, 16384);
        label.setText(TraceUIPlugin.getString("SELECTION_COLOR"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fSelectionColorEditor = new ColorEditor(otherComposite);
        this.fSelectionColorButton = this.fClassColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        this.fSelectionColorButton.setLayoutData((Object)gd);
        label = new Label(otherComposite, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite textComposite = new Composite(colorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        textComposite.setLayout((Layout)layout);
        this.fontEditor = this.createFontFieldEditor("graph.font", TraceUIPlugin.getString("GRAPH_FONT"), textComposite);
        this.initializeValues();
        return colorComposite;
    }

    private FontFieldEditor createFontFieldEditor(String preferenceName, String label, Composite parent) {
        FontFieldEditor editor = new FontFieldEditor(preferenceName, label, parent);
        editor.setPreferenceStore(this.getPreferenceStore());
        return editor;
    }

    public IPreferenceStore getPreferenceStore() {
        return TraceUIPlugin.getDefault().getPreferenceStore();
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fontEditor.load();
        String backgroundValue = store.getString("bg_option");
        if (backgroundValue.equals("system_default")) {
            this.fBackgroundDefaultRadioButton.setSelection(true);
            this.fBackgroundColorButton.setEnabled(false);
        } else {
            this.fBackgroundCustomRadioButton.setSelection(true);
            this.fBackgroundColorButton.setEnabled(true);
        }
        String classesValue = store.getString("class_option");
        if (!classesValue.equals("class_one_color")) {
            this.fClassDefaultRadioButton.setSelection(true);
            this.fClassColorButton.setEnabled(false);
        } else {
            this.fClassCustomRadioButton.setSelection(true);
            this.fClassColorButton.setEnabled(true);
        }
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"background_rgb");
        this.fBackgroundColorEditor.setColorValue(rgb);
        rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"selection_rgb");
        this.fSelectionColorEditor.setColorValue(rgb);
        rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"unknown_rgb");
        this.fUnknownColorEditor.setColorValue(rgb);
        rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"classes_rgb");
        this.fClassColorEditor.setColorValue(rgb);
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridUtil.createFill());
        return composite;
    }

    public static Color getPreferenceColor(String type) {
        IPreferenceStore pstore = TraceUIPlugin.getDefault().getPreferenceStore();
        RGB outRGB = PreferenceConverter.getColor((IPreferenceStore)pstore, (String)type);
        return SpectrumColorMap.getColor(outRGB);
    }

    public void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fontEditor.loadDefault();
        String backgroundValue = store.getDefaultString("bg_option");
        if (backgroundValue.equals("system_default")) {
            this.fBackgroundDefaultRadioButton.setSelection(true);
            this.fBackgroundCustomRadioButton.setSelection(false);
            this.fBackgroundColorButton.setEnabled(false);
        } else {
            this.fBackgroundCustomRadioButton.setSelection(true);
            this.fBackgroundDefaultRadioButton.setSelection(false);
            this.fBackgroundColorButton.setEnabled(true);
        }
        String classesValue = store.getDefaultString("class_option");
        if (!classesValue.equals("class_one_color")) {
            this.fClassDefaultRadioButton.setSelection(true);
            this.fClassCustomRadioButton.setSelection(false);
            this.fClassColorButton.setEnabled(false);
        } else {
            this.fClassCustomRadioButton.setSelection(true);
            this.fClassDefaultRadioButton.setSelection(false);
            this.fClassColorButton.setEnabled(true);
        }
        RGB rgb = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)"background_rgb");
        this.fBackgroundColorEditor.setColorValue(rgb);
        rgb = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)"selection_rgb");
        this.fSelectionColorEditor.setColorValue(rgb);
        rgb = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)"unknown_rgb");
        this.fUnknownColorEditor.setColorValue(rgb);
        rgb = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)"classes_rgb");
        this.fClassColorEditor.setColorValue(rgb);
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fontEditor.store();
        if (this.fBackgroundDefaultRadioButton.getSelection()) {
            store.setValue("bg_option", "system_default");
            this.fBackgroundColorButton.setEnabled(false);
        } else {
            store.setValue("bg_option", "bg_custom");
            PreferenceConverter.setValue((IPreferenceStore)store, (String)"background_rgb", (RGB)this.fBackgroundColorEditor.getColorValue());
        }
        if (!this.fClassDefaultRadioButton.getSelection()) {
            store.setValue("class_option", "class_one_color");
            PreferenceConverter.setValue((IPreferenceStore)store, (String)"classes_rgb", (RGB)this.fClassColorEditor.getColorValue());
        } else {
            store.setValue("class_option", "class_default_color");
        }
        PreferenceConverter.setValue((IPreferenceStore)store, (String)"selection_rgb", (RGB)this.fSelectionColorEditor.getColorValue());
        PreferenceConverter.setValue((IPreferenceStore)store, (String)"unknown_rgb", (RGB)this.fUnknownColorEditor.getColorValue());
        SpectrumColorMap.updateColors();
        TraceUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    public static FontData getConsoleFontData() {
        IPreferenceStore pstore = TraceUIPlugin.getDefault().getPreferenceStore();
        return PreferenceConverter.getFontData((IPreferenceStore)pstore, (String)"graph.font");
    }
}

