/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class StatisticTableColumnInfo {
    private boolean _isSortColumn = false;
    private boolean _isDeltaColumn = false;
    private int _mapColumn;
    private ColumnData _columnData;

    public ColumnData getColumnData() {
        return this._columnData;
    }

    public boolean isSortColumn() {
        return this._isSortColumn;
    }

    public boolean isDeltaColumn() {
        return this._isDeltaColumn;
    }

    public void setSortColumn(boolean flag) {
        this._isSortColumn = flag;
    }

    public void setDeltaColumn(boolean flag) {
        this._isDeltaColumn = flag;
    }

    public static StatisticTableColumnInfo getStatisticTableColumnInfo(TableColumn col) {
        if (col.getData() != null && col.getData() instanceof StatisticTableColumnInfo) {
            return (StatisticTableColumnInfo)col.getData();
        }
        return null;
    }

    private StatisticTableColumnInfo(StatisticView statisticView, ColumnData data) {
        TableColumn tableColumn = new TableColumn(statisticView.getTable(), 0x40000 | data.getAlignment());
        tableColumn.setData((Object)this);
        this.initializeTableColumn(statisticView, tableColumn, data, true);
    }

    public StatisticTableColumnInfo(StatisticView statisticView, ColumnData data, boolean deltaColumnsEnabled) {
        TableColumn tableColumn = new TableColumn(statisticView.getTable(), 0x40000 | data.getAlignment());
        tableColumn.setData((Object)this);
        this.initializeTableColumn(statisticView, tableColumn, data, false);
        if (deltaColumnsEnabled && data.supportsDelta()) {
            new StatisticTableColumnInfo(statisticView, data);
        }
    }

    private void initializeTableColumn(StatisticView statisticView, TableColumn tableColumn, ColumnData data, boolean isDeltaColumn) {
        Table table = statisticView.getTable();
        this._columnData = data;
        this._isDeltaColumn = isDeltaColumn;
        tableColumn.setResizable(data.isResizable());
        if (isDeltaColumn) {
            tableColumn.setText(TraceUIPlugin.getString("STR_ST_DELTA") + ":" + data.name());
        } else {
            tableColumn.setText(data.name());
        }
        tableColumn.setWidth(data.width());
        tableColumn.addSelectionListener((SelectionListener)statisticView);
        tableColumn.addControlListener((ControlListener)statisticView);
    }
}

