/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.text.DateFormat;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceNodeUI {
    protected Text _nodeAddress;
    protected Text _nodeName;
    protected Text _portNumber;
    protected Text _hour;
    protected Text _min;
    protected Text _sec;
    protected Text _micsec;
    protected Group deltaTime;
    private boolean _haveSeperator = true;

    public TraceNodeUI(boolean haveSeperator) {
        this._haveSeperator = haveSeperator;
    }

    public TraceNodeUI() {
    }

    public Composite createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        content.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 500;
        content.setLayoutData((Object)gd);
        if (this._haveSeperator) {
            Label sep = new Label(content, 258);
            GridData sepGrid = new GridData(768);
            sepGrid.horizontalSpan = 1;
            sep.setLayoutData((Object)sepGrid);
        }
        Composite group = new Composite(content, 0);
        group.setLayoutData((Object)GridUtil.createHorizontalFill());
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        group.setLayout((Layout)layout);
        Label label1 = new Label(group, 0);
        label1.setText(UIPlugin.getResourceString("NODE_NAME"));
        this._nodeName = new Text(group, 2052);
        this._nodeName.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label2 = new Label(group, 0);
        label2.setText(UIPlugin.getResourceString("NODE_ADDRESS"));
        this._nodeAddress = new Text(group, 2052);
        this._nodeAddress.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label3 = new Label(group, 0);
        label3.setText(UIPlugin.getResourceString("RAC_PORT_TEXT"));
        this._portNumber = new Text(group, 2052);
        this._portNumber.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._portNumber.setText(String.valueOf(10002));
        this.deltaTime = new Group(content, 0);
        layout = new GridLayout();
        layout.numColumns = 9;
        layout.verticalSpacing = 5;
        this.deltaTime.setLayout((Layout)layout);
        this.deltaTime.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.deltaTime.setText(UIPlugin.getResourceString("STR_SYNCH_NODE_TIME"));
        Label label = new Label((Composite)this.deltaTime, 0);
        label.setText(UIPlugin.getResourceString("STR_DELTA_TIME"));
        this._hour = new Text((Composite)this.deltaTime, 2048);
        gd = new GridData();
        gd.widthHint = 20;
        this._hour.setLayoutData((Object)gd);
        this._hour.setTextLimit(3);
        label = new Label((Composite)this.deltaTime, 0);
        label.setText(":");
        this._min = new Text((Composite)this.deltaTime, 2048);
        gd = new GridData();
        gd.widthHint = 20;
        this._min.setLayoutData((Object)gd);
        this._min.setTextLimit(2);
        label = new Label((Composite)this.deltaTime, 0);
        label.setText(":");
        this._sec = new Text((Composite)this.deltaTime, 2048);
        gd = new GridData();
        gd.widthHint = 20;
        this._sec.setLayoutData((Object)gd);
        this._sec.setTextLimit(2);
        label.setText(":");
        this._micsec = new Text((Composite)this.deltaTime, 2048);
        gd = new GridData();
        gd.widthHint = 40;
        this._micsec.setLayoutData((Object)gd);
        this._micsec.setTextLimit(6);
        label = new Label((Composite)this.deltaTime, 0);
        label.setText(UIPlugin.getResourceString("STR_DELTA_HMS"));
        this._nodeName.setFocus();
        WorkbenchHelp.setHelp((Control)this._nodeAddress, (String)(UIPlugin.getPluginId() + ".nnwp0000"));
        WorkbenchHelp.setHelp((Control)this._nodeName, (String)(UIPlugin.getPluginId() + ".nnwp0001"));
        WorkbenchHelp.setHelp((Control)this._portNumber, (String)(UIPlugin.getPluginId() + ".nnwp0002"));
        WorkbenchHelp.setHelp((Control)this._hour, (String)(UIPlugin.getPluginId() + ".nnwp0003"));
        return content;
    }

    public Text getAddressUI() {
        return this._nodeAddress;
    }

    public Text getNodeNameUI() {
        return this._nodeName;
    }

    public Text getPortNumberUI() {
        return this._portNumber;
    }

    public Text getHourUI() {
        return this._hour;
    }

    public Text getMinUI() {
        return this._min;
    }

    public Text getSecUI() {
        return this._sec;
    }

    public Text getMicSecUI() {
        return this._micsec;
    }

    public void setEnabled(boolean enable) {
        this._nodeName.setEnabled(enable);
        this._nodeAddress.setEnabled(enable);
    }

    public double getDeltaTime() {
        int hours = 0;
        try {
            hours = Integer.parseInt(this._hour.getText());
        }
        catch (Exception exc) {
            // empty catch block
        }
        int min = 0;
        try {
            min = Integer.parseInt(this._min.getText());
        }
        catch (Exception exc) {
            // empty catch block
        }
        int sec = 0;
        try {
            sec = Integer.parseInt(this._sec.getText());
        }
        catch (Exception exc) {
            // empty catch block
        }
        int micsec = 0;
        try {
            micsec = Integer.parseInt(this._micsec.getText());
        }
        catch (Exception exc) {
            // empty catch block
        }
        return ((double)hours * 3600.0 + (double)(min * 60) + (double)sec) * 1000000.0 + (double)micsec;
    }

    public void setDeltaTime(double delta) {
        DateFormat df = DateFormat.getTimeInstance();
        try {
            int micsec = (int)(delta % 1000000.0);
            int hour = (int)((delta /= 1000000.0) / 3600.0);
            int min = (int)(delta % 3600.0 / 60.0);
            int sec = (int)(delta % 3600.0 % 60.0);
            this._hour.setText(hour == 0 ? "" : String.valueOf(hour));
            this._min.setText(min == 0 ? "" : String.valueOf(min));
            this._sec.setText(sec == 0 ? "" : String.valueOf(sec));
            this._micsec.setText(micsec == 0 ? "" : String.valueOf(micsec));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void setShowDelta(boolean enable) {
        this.deltaTime.setVisible(enable);
    }
}

