/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.EnvTableElement;
import org.eclipse.hyades.trace.ui.internal.core.LaunchProcessUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceProcessUI;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProcessWizard;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenProcessWizardPage
extends WizardPage
implements ModifyListener {
    private TraceProcessUI _processUI;
    private boolean _refresh = false;

    public OpenProcessWizardPage(String name) {
        super(name);
        this.setTitle(UIPlugin.getResourceString("OPENPROCESSWIZARDPAGE_PROCESS_PROPERTY"));
        this.setDescription(UIPlugin.getResourceString("OPENPROCESSWIZARDPAGE_PROCESS_DESC"));
    }

    public void createControl(Composite parent) {
        this._processUI = new TraceProcessUI();
        Composite content = this._processUI.createControl(parent);
        this._processUI.getLocationUI().setEnabled(false);
        this._processUI.getLaunchProcessUI().enable(false);
        this._processUI.getProcessIdUI().setEnabled(false);
        this._processUI.getNodeNameUI().setEnabled(false);
        this.initData();
        this.setControl((Control)content);
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".opwp0000"));
    }

    public boolean finish() {
        TRCProcessProxy process = ((OpenProcessWizard)this.getWizard()).getProcess();
        if (process == null) {
            return false;
        }
        process.setClasspath(this._processUI.getLaunchProcessUI().getClassPath());
        process.setName(this._processUI.getLaunchProcessUI().getClassName());
        String params = this._processUI.getLaunchProcessUI().getParametersUI().getText().trim();
        String vmArgs = this._processUI.getLaunchProcessUI().getVMArgs();
        process.setParameters(params);
        process.setVmArguments(vmArgs);
        if (this._refresh) {
            UIPlugin.getDefault().getViewer().getViewer().refresh();
        }
        return true;
    }

    private void initData() {
        TRCProcessProxy process = ((OpenProcessWizard)this.getWizard()).getProcess();
        IResource sel = HyadesUtil.getSelectionFolder((INavigator)((OpenProcessWizard)this.getWizard()).getViewer());
        if (sel != null) {
            this._processUI.getLocationUI().setLocation(sel.getFullPath().toOSString());
        }
        this._processUI.getLocationUI().setMonitor(process.getNode().getMonitor().getName());
        String name = process.getName();
        if (name != null) {
            this._processUI.getLaunchProcessUI().getClassUI().setText(name);
            if (process.getLaunchMode() != 1) {
                this._processUI.getLaunchProcessUI().getClassUI().setEnabled(true);
                this._refresh = true;
            }
        }
        this._processUI.getProcessIdUI().setText(String.valueOf(process.getPid()));
        this._processUI.getNodeNameUI().setText(process.getNode().getName());
        if (process.getClasspath() != null) {
            this._processUI.getLaunchProcessUI().getClassPathUI().setText(process.getClasspath());
        }
        if (process.getParameters() != null) {
            this._processUI.getLaunchProcessUI().getParametersUI().setText(process.getParameters());
        }
        if (process.getVmArguments() != null) {
            this._processUI.getLaunchProcessUI().getVMArgsUI().setText(process.getVmArguments());
        }
        if (process.getEnvironmentVariables() != null) {
            this.setEnvironment(this._processUI.getLaunchProcessUI(), process);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(!this._processUI.getLaunchProcessUI().getClassUI().getText().trim().equals(""));
    }

    public void setEnvironment(LaunchProcessUI processUI, TRCProcessProxy process) {
        ArrayList<EnvTableElement> envData = new ArrayList<EnvTableElement>();
        EList environments = process.getEnvironmentVariables();
        for (int i = 0; i < environments.size(); ++i) {
            TRCEnvironmentVariable env = (TRCEnvironmentVariable)environments.get(i);
            EnvTableElement envTblElement = new EnvTableElement(env.getName(), env.getValue());
            envData.add(envTblElement);
        }
        processUI.setEnvData(envData);
    }
}

