/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.io.File;
import java.util.Map;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.IImportWizardWidget;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ImportWizardTextField
implements IImportWizardWidget,
Listener,
ModifyListener {
    protected Button btn;
    protected Map _filtersTable;
    protected Text text;
    private ParserField _field;

    public ImportWizardTextField(Map _filtersTable, ParserField field) {
        this._filtersTable = _filtersTable;
        this._field = field;
    }

    public String getValue() {
        return this.text.getText().trim();
    }

    public void setValue(String newValue) {
        this.text.setText(newValue);
    }

    public void createControl(Composite composite, String prefix) {
        Label label = new Label(composite, 64);
        GridData data = new GridData();
        data.widthHint = 400;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(this._field.getName());
        this.text = new Text(composite, 2048);
        this.text.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.text.addModifyListener((ModifyListener)this);
        this.text.setToolTipText(this._field.getTooltip());
        this.btn = new Button(composite, 8);
        this.btn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_BROWSE1"));
        this.btn.addListener(13, (Listener)this);
        if (this._field.useBrowse()) {
            this.btn.setVisible(true);
            String filters = this._field.getFilters();
            if (filters != null) {
                this._filtersTable.put(this.btn, filters);
            }
        } else {
            this.btn.setVisible(false);
        }
    }

    public void handleEvent(Event event) {
        if (event.widget == this.btn) {
            Object filters = this._filtersTable.get(this.btn);
            if (filters != null) {
                FileDialog fileDialog = new FileDialog(this.btn.getParent().getShell());
                fileDialog.setFilterPath(this.text.getText().trim());
                fileDialog.setFilterExtensions(new String[]{filters.toString(), "*"});
                fileDialog.open();
                String fileName = fileDialog.getFileName();
                if (fileName != null && !fileName.trim().equals("")) {
                    this.text.setText(fileDialog.getFilterPath().concat(File.separator).concat(fileName));
                }
            } else {
                String wasHomeDir;
                DirectoryDialog directoryDialog = new DirectoryDialog(this.btn.getParent().getShell());
                directoryDialog.setMessage(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_LOC_BROWSE"));
                if (this.text.getText().trim().length() > 0) {
                    directoryDialog.setFilterPath(this.text.getText().trim());
                }
                if ((wasHomeDir = directoryDialog.open()) != null && !wasHomeDir.trim().equals("")) {
                    this.text.setText(wasHomeDir);
                }
            }
        }
    }

    public void modifyText(ModifyEvent e) {
    }

    public boolean isValid() {
        return !this.text.getVisible() || !this.text.getText().trim().equals("");
    }

    public Text getText() {
        return this.text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public Button getBtn() {
        return this.btn;
    }

    public void setBtn(Button btn) {
        this.btn = btn;
    }

    public ParserField getField() {
        return this._field;
    }
}

