/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.TraceMergeUI;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizardPage;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileElement;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class LogDestinationUI
implements Listener {
    private TraceLocationUI locationUI;
    private TraceMergeUI mergeUI;
    private TRCAgentProxy currentAgentProxy;
    private ImportLogWizardPage page;
    private boolean bTextHasChanged = true;

    public LogDestinationUI(ImportLogWizardPage page) {
        this.page = page;
    }

    public Composite createControl(Composite parent) {
        Composite btnGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)GridUtil.createFill());
        this.locationUI = new TraceLocationUI();
        this.locationUI.createControl(btnGroup);
        this.locationUI.setLocation("LogAnalyzerProject");
        this.locationUI.getLocationLabel().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_DES_PROJECT"));
        this.locationUI.getLocation().addListener(24, (Listener)this);
        this.locationUI.getMonitor().addListener(24, (Listener)this);
        Label space = new Label(btnGroup, 0);
        GridData data = new GridData(768);
        this.mergeUI = new TraceMergeUI();
        this.mergeUI.createControl(btnGroup);
        this.mergeUI.getTree().addListener(13, (Listener)this);
        this.mergeUI.getMergeButton().addListener(13, (Listener)this);
        return btnGroup;
    }

    public void handleEvent(Event event) {
        LogFileElement element = this.page.getSelectedElement();
        if (event.type == 24) {
            if (this.bTextHasChanged) {
                this.page.setPageComplete(this.isTabItemComplete());
            }
        } else if (event.widget == this.mergeUI.getMergeButton()) {
            TreeItem selection;
            TreeItem[] sel;
            this.mergeUI.getTree().setEnabled(this.mergeUI.getMergeButton().getSelection());
            if (this.mergeUI.getMergeButton().getSelection() && (sel = this.mergeUI.getTree().getSelection()).length > 0 && (selection = sel[0]) != null && selection.getData() != null && selection.getData() instanceof TRCAgentProxy) {
                this.currentAgentProxy = (TRCAgentProxy)selection.getData();
                return;
            }
            this.currentAgentProxy = null;
        } else {
            TreeItem selection;
            TreeItem[] sel = this.mergeUI.getTree().getSelection();
            if (sel.length > 0 && (selection = sel[0]) != null && selection.getData() != null && selection.getData() instanceof TRCAgentProxy) {
                TRCMonitor monitor = ((TRCAgentProxy)selection.getData()).getProcessProxy().getNode().getMonitor();
                this.locationUI.setMonitor(monitor.getName());
                String path = this.resourcePath(monitor.eResource().getURI());
                IWorkspace workbench = ResourcesPlugin.getWorkspace();
                Path filePath = new Path(path);
                IResource fres = workbench.getRoot().findMember((IPath)filePath);
                if (fres != null && fres.exists()) {
                    this.locationUI.setLocation(fres.getProject().getName());
                }
                this.currentAgentProxy = (TRCAgentProxy)selection.getData();
                return;
            }
            this.currentAgentProxy = null;
        }
        this.bTextHasChanged = true;
    }

    public void initialize() {
        this.locationUI.initialize();
        this.setMergedAgent(null);
        this.setUseLargeLogSupport(false);
    }

    public void initializeUIFromLogElement(LogFileElement element) {
        if (element.getProject() == null || element.getMonitor() == null) {
            this.locationUI.initialize();
        } else {
            this.setProject(element.getProject());
            this.setMonitor(element.getMonitor());
        }
        this.setMergedAgent(this.page.getSelectedElement().getMergedAgent());
        this.setUseLargeLogSupport(this.page.getSelectedElement().isUseLargeLogSupport());
    }

    public String getProject() {
        return this.locationUI.getLocation().getText().trim();
    }

    public String getMonitor() {
        return this.locationUI.getMonitor().getText().trim();
    }

    public TRCAgentProxy getAgentProxy() {
        return this.currentAgentProxy;
    }

    public boolean getSelection() {
        return this.mergeUI.getMergeButton().getSelection();
    }

    private String resourcePath(URI uri) {
        String path = uri.path();
        if (path.startsWith("/resource")) {
            return path.substring(9);
        }
        if (path.startsWith("platform:/resource")) {
            return path.substring(18);
        }
        return path;
    }

    public void setProject(String project) {
        this.bTextHasChanged = false;
        this.locationUI.setLocation(project);
    }

    public void setMonitor(String monitor) {
        this.bTextHasChanged = false;
        this.locationUI.setMonitor(monitor);
    }

    public void setMergedAgent(TRCAgentProxy mergedAgent) {
        if (mergedAgent == null) {
            this.mergeUI.getMergeButton().setSelection(false);
            this.mergeUI.getTree().setEnabled(false);
        } else {
            this.mergeUI.getMergeButton().setSelection(true);
            this.mergeUI.getTree().setEnabled(true);
            this.mergeUI.selectMergedAgent(mergedAgent);
            this.currentAgentProxy = mergedAgent;
        }
    }

    public boolean isTabItemComplete() {
        return this.locationUI.getMonitor().getText().length() != 0 && this.locationUI.getLocation().getText().length() != 0;
    }

    public boolean finish() {
        LogFileElement element = this.page.getSelectedElement();
        element.setMonitor(this.locationUI.getMonitor().getText());
        element.setProject(this.locationUI.getLocation().getText());
        element.setMergedAgent(this.currentAgentProxy);
        element.setUseLargeLogSupport(this.mergeUI.getLargeLogSupport());
        return this.locationUI.getMonitor().getText().length() > 0 && this.locationUI.getLocation().getText().length() > 0;
    }

    public void setUseLargeLogSupport(boolean b) {
        if (this.mergeUI != null) {
            this.mergeUI.setUseLargeLogSupport(b);
        }
    }
}

