/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.TypeMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Constraint;
import org.eclipse.hyades.resources.database.internal.dbmodel.Database;
import org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelFactory;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.impl.DBMapImpl;
import org.eclipse.hyades.resources.database.internal.impl.RDBHelper;

public class DBMapBuilder {
    protected boolean debug = false;
    public static final int CONSTRAINT_NAME_LENGTH = 18;
    public static final String PRIMARY_KEY_NAME = "PrimaryKey_";
    public static final String INDEX_NAME = "Index_";
    public static final String SOURCE_ID_COLUMN_NAME = "Source_Id";
    public static final String TARGET_ID_COLUMN_NAME = "Target_Id";
    public static final String TARGET_ORDER_COLUMN_NAME = "Target_Order";
    public static final String SOURCE_ORDER_COLUMN_NAME = "Source_Order";
    public static final String VALUE_COLUMN_NAME = "Value";
    public static final String ID_COLUMN_NAME = "Id";
    public static final String ORDER_COLUMN_NAME = "Order";
    public static final String RESOURCE_TABLE_NAME = "Resource_Table";
    public static final String URI_COLUMN_NAME = "URI";
    public static final String TABLE_COLUMN_NAME = "Table_Name";
    public static final String IS_PROXY_COLUMN_NAME = "Is_EMF_Proxy";
    public static final String PROXY_URI_COLUMN_NAME = "Proxy_URI";
    public static final String PROXY_TABLE_NAME = "Proxy_Table";
    public static final String ID_TABLE_NAME = "Id_Table";
    protected String databaseName;
    protected DbmodelFactory dbFactory;
    protected DBMap map;
    protected Map classesToNames;
    protected Map classesToReferences;
    protected Database database;
    protected List allPackages;
    protected List allClasses;
    protected List allReferences;
    protected List referencesForTables;
    protected int primaryKeyCount = 0;
    protected int indexCount = 0;
    protected TypeMap typeMap;
    protected RDBHelper rdbHelper;

    public DBMapBuilder(String databaseName, TypeMap typeMap) {
        this.databaseName = databaseName;
        this.dbFactory = DbmodelFactory.eINSTANCE;
        this.typeMap = typeMap;
        this.rdbHelper = new RDBHelper();
    }

    public DBMap getMap(EPackage pkg) {
        ArrayList<EPackage> pkgs = new ArrayList<EPackage>();
        pkgs.add(pkg);
        return this.getMap(pkgs);
    }

    public DBMap getMap(List packages) {
        if (this.map != null) {
            return this.map;
        }
        this.map = new DBMapImpl();
        this.allPackages = this.getAllPackages(packages);
        this.database = this.dbFactory.createDatabase();
        this.database.setName(this.databaseName);
        int l = this.allPackages.size();
        for (int i = 0; i < l; ++i) {
            this.map.add((EModelElement)this.allPackages.get(i), this.database);
        }
        this.processClassifiers();
        this.processReferences();
        this.createResourceTable();
        this.createProxyTable();
        this.createIdTable();
        return this.map;
    }

    protected List getAllPackages(List packages) {
        ArrayList pkgs = new ArrayList();
        int l = packages.size();
        for (int i = 0; i < l; ++i) {
            pkgs.addAll(this.getPackagesFromPackage((EPackage)packages.get(i)));
        }
        return pkgs;
    }

    protected List getPackagesFromPackage(EPackage pkg) {
        ArrayList<EPackage> packages = new ArrayList<EPackage>();
        packages.add(pkg);
        EList subpackages = pkg.getESubpackages();
        int l = subpackages.size();
        for (int i = 0; i < l; ++i) {
            packages.addAll(this.getPackagesFromPackage((EPackage)subpackages.get(i)));
        }
        return packages;
    }

    protected void processClassifiers() {
        this.getAllClasses();
        this.assignClassNames();
        this.getAllReferences();
        int l = this.allClasses.size();
        for (int i = 0; i < l; ++i) {
            this.processClass((EClass)this.allClasses.get(i));
        }
    }

    protected void getAllClasses() {
        this.allClasses = new ArrayList();
        int l = this.allPackages.size();
        for (int i = 0; i < l; ++i) {
            EPackage pkg = (EPackage)this.allPackages.get(i);
            EList classifiers = pkg.getEClassifiers();
            int l2 = classifiers.size();
            for (int j = 0; j < l2; ++j) {
                EClassifier classifier = (EClassifier)classifiers.get(j);
                if (!(classifier instanceof EClass)) continue;
                this.allClasses.add(classifier);
            }
        }
    }

    protected void assignClassNames() {
        this.classesToNames = new HashMap();
        this.assignNames(this.allClasses, 0);
    }

    protected void assignNames(List classes, int packageNumber) {
        HashSet uniqueNames = new HashSet();
        HashMap namesToClasses = new HashMap();
        ArrayList duplicates = new ArrayList();
        int l = classes.size();
        for (int i = 0; i < l; ++i) {
            EClass eClass = (EClass)classes.get(i);
            this.assignNameToClass(eClass, uniqueNames, namesToClasses, duplicates, packageNumber);
        }
        if (duplicates.size() > 0) {
            this.assignNames(duplicates, ++packageNumber);
        }
    }

    protected void assignNameToClass(EClass eClass, Set uniqueNames, Map namesToClasses, List duplicates, int packageNumber) {
        String name = this.getName(eClass, packageNumber);
        if (!uniqueNames.contains(name)) {
            this.classesToNames.put(eClass, name);
            uniqueNames.add(name);
            namesToClasses.put(name, eClass);
        } else {
            duplicates.add(eClass);
            EClass original = (EClass)namesToClasses.get(name);
            if (original != null) {
                this.classesToNames.remove(original);
                namesToClasses.remove(name);
                duplicates.add(original);
            }
        }
    }

    protected String getName(EClass eClass, int packageNumber) {
        String name = eClass.getName();
        for (EPackage ePackage = eClass.getEPackage(); ePackage != null && packageNumber > 0; --packageNumber, ePackage = ePackage.getESuperPackage()) {
            String pkgName = ePackage.getName();
            pkgName = this.upperCaseFirst(pkgName);
            name = pkgName + "_" + name;
        }
        return name;
    }

    protected String upperCaseFirst(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected String getName(EClass eClass) {
        return (String)this.classesToNames.get(eClass);
    }

    protected void getAllReferences() {
        this.allReferences = new ArrayList();
        int l = this.allClasses.size();
        for (int i = 0; i < l; ++i) {
            EClass eClass = (EClass)this.allClasses.get(i);
            EList references = eClass.getEReferences();
            this.allReferences.addAll(references);
        }
    }

    protected void processClass(EClass cls) {
        Table table = this.rdbHelper.createTable(this.database, this.getName(cls));
        DBMap.ClassData data = new DBMap.ClassData(table, true, null);
        this.map.add((EModelElement)cls, data);
        Column parentPath = this.rdbHelper.addColumnToTable(table, "p_p");
        this.rdbHelper.setColumnType(parentPath, "Blah", this.typeMap);
        this.processFeatures(table, cls);
        this.processMultiValuedAttributes(cls);
    }

    protected void processFeatures(Table table, EClass cls) {
        List references;
        Column primaryKey = null;
        HashSet columnNames = new HashSet();
        EList attributes = cls.getEAttributes();
        int l = attributes.size();
        for (int i = 0; i < l; ++i) {
            EAttribute attrib = (EAttribute)attributes.get(i);
            Column column = this.addAttributeToClassTable(attrib, table, columnNames);
            if (column == null || !this.isKeyAttribute(attrib)) continue;
            primaryKey = column;
        }
        if (this.classesToReferences == null) {
            this.computeClassTableReferences();
        }
        if (primaryKey == null) {
            primaryKey = this.rdbHelper.addColumnToTable(table, this.createPrimaryKeyName(columnNames));
            this.rdbHelper.setColumnType(primaryKey, "EInt", this.typeMap);
        }
        if ((references = (List)this.classesToReferences.get(cls)) != null) {
            int l2 = references.size();
            for (int i = 0; i < l2; ++i) {
                EReference reference = (EReference)references.get(i);
                this.addReferenceToClassTable(reference, table, primaryKey);
            }
        }
        primaryKey.setAllowNull(false);
        this.rdbHelper.addPrimaryKeyToTable(table, primaryKey, PRIMARY_KEY_NAME + ++this.primaryKeyCount);
        Column proxyURI = this.rdbHelper.addColumnToTable(table, IS_PROXY_COLUMN_NAME);
        this.rdbHelper.setColumnType(proxyURI, "EBoolean", this.typeMap);
    }

    protected Column addAttributeToClassTable(EAttribute attribute, Table table, Set columnNames) {
        if (attribute.isTransient() || attribute.isMany()) {
            return null;
        }
        Column column = this.rdbHelper.addColumnToTable(table, attribute.getName());
        column.setDefaultValue(attribute.getDefaultValue());
        this.rdbHelper.setColumnType(column, attribute, this.typeMap);
        DBMap.AttributeData data = new DBMap.AttributeData(column);
        this.map.add((EModelElement)attribute, data);
        columnNames.add(column.getName());
        if (attribute.isID()) {
            Constraint index = this.rdbHelper.addIndexToTable(table, INDEX_NAME + ++this.indexCount);
            column.getConstraints().add((Object)index);
        }
        return column;
    }

    protected void addReferenceToClassTable(EReference reference, Table table, Column primaryKey) {
        Column target;
        Column source;
        Column column = this.rdbHelper.addColumnToTable(table, this.getReferenceColumnName(reference));
        column.setDefaultValue(reference.getDefaultValue());
        this.rdbHelper.setColumnType(column, "EInt", this.typeMap);
        Column order = null;
        if (reference.isMany()) {
            String name = column.getName() + "_Order";
            order = this.rdbHelper.addColumnToTable(table, name);
            this.rdbHelper.setColumnType(order, "EInt", this.typeMap);
        }
        if (reference.isMany()) {
            source = column;
            target = primaryKey;
        } else {
            source = primaryKey;
            target = column;
        }
        DBMap.ReferenceData data = new DBMap.ReferenceData(table, source, target, order);
        this.map.add((EModelElement)reference, data);
        EReference opposite = reference.getEOpposite();
        if (opposite != null) {
            data = new DBMap.ReferenceData(table, target, source, null);
            this.map.add((EModelElement)opposite, data);
        }
    }

    protected String getReferenceColumnName(EReference reference) {
        if (!reference.isMany()) {
            return reference.getName();
        }
        EReference opposite = reference.getEOpposite();
        if (opposite == null) {
            if (reference.getEContainingClass() != reference.getEReferenceType()) {
                String name = reference.getEContainingClass().getName();
                return name.substring(0, 1).toLowerCase() + name.substring(1);
            }
            return reference.getName();
        }
        return opposite.getName();
    }

    protected String createPrimaryKeyName(Set names) {
        if (!names.contains("id")) {
            return "id";
        }
        if (!names.contains("databaseId")) {
            return "databaseId";
        }
        return "emfDatabaseId";
    }

    protected void computeClassTableReferences() {
        this.referencesForTables = new ArrayList();
        this.classesToReferences = new HashMap();
        HashSet<EReference> processedReferences = new HashSet<EReference>();
        int l = this.allReferences.size();
        for (int i = 0; i < l; ++i) {
            EReference reference = (EReference)this.allReferences.get(i);
            if (processedReferences.contains(reference)) continue;
            EReference opposite = reference.getEOpposite();
            if (!this.ignoreReference(reference, opposite)) {
                this.processClassForReference(reference, opposite);
            }
            processedReferences.add(reference);
            if (opposite == null) continue;
            processedReferences.add(opposite);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processClassForReference(EReference reference, EReference opposite) {
        EReference referenceToAdd;
        EClass eClass;
        if (opposite == null) {
            if (reference.isMany()) {
                this.referencesForTables.add(reference);
                return;
            }
            eClass = this.getClass(reference);
            referenceToAdd = reference;
        } else {
            if (reference.isTransient() && !opposite.isTransient()) {
                EReference temp = opposite;
                opposite = reference;
                reference = temp;
            }
            if (reference.isMany() && opposite.isMany()) {
                this.referencesForTables.add(reference);
                return;
            }
            if (!reference.isMany() && !opposite.isMany()) {
                eClass = reference.getEContainingClass();
                referenceToAdd = reference;
            } else {
                referenceToAdd = reference.isMany() ? reference : opposite;
                if (!referenceToAdd.isUnique()) {
                    this.referencesForTables.add(referenceToAdd);
                    return;
                }
                eClass = referenceToAdd.getEReferenceType();
            }
        }
        this.addReferenceToMap(eClass, referenceToAdd);
    }

    protected boolean ignoreReference(EReference reference, EReference opposite) {
        return reference.isTransient() && (opposite == null || opposite.isTransient());
    }

    protected EClass getClass(EReference reference) {
        if (!reference.isMany()) {
            return reference.getEContainingClass();
        }
        return reference.getEReferenceType();
    }

    protected void addReferenceToMap(EClass eClass, EReference reference) {
        ArrayList<EReference> references = (ArrayList<EReference>)this.classesToReferences.get(eClass);
        if (references == null) {
            references = new ArrayList<EReference>();
            this.classesToReferences.put(eClass, references);
        }
        references.add(reference);
    }

    protected void processMultiValuedAttributes(EClass cls) {
        EList attributes = cls.getEAttributes();
        int l = attributes.size();
        for (int i = 0; i < l; ++i) {
            EAttribute attribute = (EAttribute)attributes.get(i);
            if (!attribute.isMany()) continue;
            this.createAttributeTable(cls, attribute);
        }
    }

    protected void createAttributeTable(EClass cls, EAttribute attribute) {
        String tableName = this.getName(cls) + "_" + attribute.getName();
        Table table = this.rdbHelper.createTable(this.database, tableName);
        Column id = this.addIdToAttributeTable(table, cls);
        Column value = this.addValueColumn(table, attribute);
        Column order = this.addOrderColumn(table);
        DBMap.AttributeData data = new DBMap.AttributeData(table, id, value, order);
        this.map.add((EModelElement)attribute, data);
    }

    protected Column addIdToAttributeTable(Table table, EClass cls) {
        Column id = this.rdbHelper.addColumnToTable(table, ID_COLUMN_NAME);
        this.rdbHelper.setColumnType(id, "EInt", this.typeMap);
        return id;
    }

    protected Column addValueColumn(Table table, EAttribute attribute) {
        Column value = this.rdbHelper.addColumnToTable(table, VALUE_COLUMN_NAME);
        this.rdbHelper.setColumnType(value, attribute, this.typeMap);
        return value;
    }

    protected Column addOrderColumn(Table table) {
        Column order = this.rdbHelper.addColumnToTable(table, ORDER_COLUMN_NAME);
        this.rdbHelper.setColumnType(order, "EInt", this.typeMap);
        return order;
    }

    protected boolean isKeyAttribute(EAttribute attribute) {
        return false;
    }

    protected void processReferences() {
        int l = this.referencesForTables.size();
        for (int i = 0; i < l; ++i) {
            EReference reference = (EReference)this.referencesForTables.get(i);
            this.createReferenceTable(reference);
        }
    }

    protected void createReferenceTable(EReference reference) {
        EClass cls = reference.getEContainingClass();
        String tableName = this.getName(cls) + "_" + reference.getName();
        Table table = this.rdbHelper.createTable(this.database, tableName);
        Column source = this.rdbHelper.addColumnToTable(table, SOURCE_ID_COLUMN_NAME);
        this.rdbHelper.setColumnType(source, "EInt", this.typeMap);
        Column targetOrder = this.rdbHelper.addColumnToTable(table, "");
        targetOrder.setName(TARGET_ORDER_COLUMN_NAME);
        this.rdbHelper.setColumnType(targetOrder, "EInt", this.typeMap);
        Column target = this.rdbHelper.addColumnToTable(table, TARGET_ID_COLUMN_NAME);
        this.rdbHelper.setColumnType(target, "EInt", this.typeMap);
        EReference opposite = reference.getEOpposite();
        Column sourceOrder = null;
        if (opposite != null && opposite.isMany()) {
            sourceOrder = this.rdbHelper.addColumnToTable(table, SOURCE_ORDER_COLUMN_NAME);
            this.rdbHelper.setColumnType(sourceOrder, "EInt", this.typeMap);
        }
        this.addReferenceToMap(reference, table, source, target, targetOrder);
        if (opposite != null) {
            this.addReferenceToMap(opposite, table, target, source, sourceOrder);
        }
    }

    protected void addReferenceToMap(EReference reference, Table table, Column source, Column target, Column targetOrder) {
        DBMap.ReferenceData data = new DBMap.ReferenceData(table, source, target, targetOrder);
        this.map.add((EModelElement)reference, data);
    }

    protected void createResourceTable() {
        Table table = this.rdbHelper.createTable(this.database, RESOURCE_TABLE_NAME);
        Column uri = this.rdbHelper.addColumnToTable(table, URI_COLUMN_NAME);
        this.rdbHelper.setColumnType(uri, "Blah", this.typeMap);
        Column tableColumn = this.rdbHelper.addColumnToTable(table, TABLE_COLUMN_NAME);
        this.rdbHelper.setColumnType(tableColumn, "Blah", this.typeMap);
        Column id = this.rdbHelper.addColumnToTable(table, ID_COLUMN_NAME);
        this.rdbHelper.setColumnType(id, "EInt", this.typeMap);
        this.map.setResourceTable(table);
    }

    protected void createProxyTable() {
        Table table = this.rdbHelper.createTable(this.database, PROXY_TABLE_NAME);
        Column uri = this.rdbHelper.addColumnToTable(table, URI_COLUMN_NAME);
        this.rdbHelper.setColumnType(uri, "Blah", this.typeMap);
        Column tableColumn = this.rdbHelper.addColumnToTable(table, TABLE_COLUMN_NAME);
        this.rdbHelper.setColumnType(tableColumn, "Blah", this.typeMap);
        Column id = this.rdbHelper.addColumnToTable(table, ID_COLUMN_NAME);
        this.rdbHelper.setColumnType(id, "EInt", this.typeMap);
        Column proxyURIColumn = this.rdbHelper.addColumnToTable(table, PROXY_URI_COLUMN_NAME);
        this.rdbHelper.setColumnType(proxyURIColumn, "Blah", this.typeMap);
        this.map.setProxyTable(table);
    }

    protected void createIdTable() {
        Table table = this.rdbHelper.createTable(this.database, ID_TABLE_NAME);
        Column id = this.rdbHelper.addColumnToTable(table, ID_COLUMN_NAME);
        this.rdbHelper.setColumnType(id, "EInt", this.typeMap);
        this.map.setIdTable(table);
    }
}

