/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.local;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.execution.recorder.http.HttpRecorderPlugin;
import org.eclipse.hyades.internal.execution.recorder.local.IRecorderDataProcessor;
import org.eclipse.hyades.internal.execution.recorder.utilities.RecorderFileUtil;

public class HttpRecorderDataProcessor
implements IRecorderDataProcessor {
    private IFile traceFile = null;
    private File javaTraceFile = null;
    private boolean sslWarningShown = false;

    public void initialize() throws IOException {
        String string = HttpRecorderPlugin.getPreference("recording_path");
        try {
            this.traceFile = RecorderFileUtil.createTraceFile((String)string);
            this.javaTraceFile = this.traceFile.getRawLocation().toFile();
            if (!this.javaTraceFile.exists()) {
                throw new IOException(HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.UNABLE_TO_CREATE_TRACE_FILE_ERROR"));
            }
        }
        catch (CoreException coreException) {
            throw new IOException(HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.UNABLE_TO_CREATE_TRACE_FILE_ERROR") + coreException.getMessage());
        }
        RecorderFileUtil.createTraceModel((String)string, (String)this.traceFile.getFullPath().toString());
    }

    public void complete() {
        try {
            if (this.traceFile != null) {
                this.traceFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void processData(byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.javaTraceFile, true);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void processControlString(String string) {
        if (string.startsWith("-1") && !this.sslWarningShown) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            RecorderPlugin.reportExceptionToUser((Exception)new Exception(HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.SSL_RECORDERING_ATTEMPTED_ERROR_MESSAGE")), (String)HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.PLAYBACK_MAY_BE_AFFECTED_WARNING"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.SSL_PACKET_IN_RECORDING_AND_NOT_SUPPORTED_WARNING"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.WARNING"));
            this.sslWarningShown = true;
        } else if (string.startsWith("-2") && !this.sslWarningShown) {
            RecorderPlugin.reportExceptionToUser((Exception)new Exception(HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.SSL_RECORDERING_ATTEMPTED_ERROR_MESSAGE")), (String)HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.PLAYBACK_MAY_BE_AFFECTED_WARNING"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.TESTKEYS_NOT_FOUND"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.WARNING"));
            this.sslWarningShown = true;
        } else if (string.startsWith("-3") && !this.sslWarningShown) {
            RecorderPlugin.reportExceptionToUser((Exception)new Exception(HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.PROBLEM_CREATING_CLIENTSIDEREADER")), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.PROBLEM_CREATING_CLIENTSIDEREADER"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.SOCKET_BIND_ERROR"));
            this.sslWarningShown = true;
        }
    }

    public void processDebugString(String string) {
        System.out.println(string);
    }
}

