/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEComponentIdentification;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.ImageManager;
import org.eclipse.hyades.statistical.ui.editor.internal.AgentChangeListener;
import org.eclipse.hyades.statistical.ui.editor.internal.EntityExistsException;
import org.eclipse.hyades.statistical.ui.editor.internal.GraphWindow;
import org.eclipse.hyades.statistical.ui.editor.internal.HexData;
import org.eclipse.hyades.statistical.ui.editor.internal.ModelChangeListener;
import org.eclipse.hyades.statistical.ui.editor.internal.ModifiableVariableBar;
import org.eclipse.hyades.statistical.ui.editor.internal.ModuleNodeChangeListener;
import org.eclipse.hyades.statistical.ui.editor.internal.SDSnapshotObservationGraphSource;
import org.eclipse.hyades.statistical.ui.editor.internal.SDTextObservationGraphSource;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConDropListener;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConInterface;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConModule;
import org.eclipse.hyades.statistical.ui.editor.internal.XMLConfigUtil;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Dirtiable;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.EnumerationGraph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.EnumerationGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.HistogramGraph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.LineGraph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.TestGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBar;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomImageBar;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ResourceTransfer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StatisticalModelGraphViewer
implements DisposeListener,
SelectionListener,
DropTargetListener,
MouseListener,
StatConInterface {
    private static final boolean DEBUG_LOADING = true;
    protected ArrayList disposables = new ArrayList();
    protected HashMap module_refs = new HashMap();
    protected ArrayList modules = new ArrayList();
    protected int next = 0;
    protected int[] colours = new int[]{3, 5, 9, 7, 2, 13, 11};
    protected TabFolder tabfolder;
    protected SashForm sashfolder;
    protected Composite leftsash;
    protected Composite rightsash;
    protected GraphWindow graph_window;
    protected Tree chooser_tree;
    protected Menu chooser_menu;
    protected ArrayList chooser_disposables;
    protected MenuItem chooser_add;
    protected ImageManager img;
    protected HashMap reverse_map = new HashMap();
    protected HashMap trcagent_map = new HashMap();
    protected HashMap msglist_map = new HashMap();
    protected HashMap sddescriptor_map = new HashMap();
    protected HashMap counter_map = new HashMap();
    protected HashMap modifiable_map = new HashMap();
    protected HashMap graph_map = new HashMap();
    protected HashMap bar_map = new HashMap();
    protected HashMap bar_slider_map = new HashMap();
    protected HashMap source_map = new HashMap();
    protected HashMap source_graph_map = new HashMap();
    protected Dirtiable dirtiable;
    protected ArrayList agents = new ArrayList();
    protected ArrayList global_actions = new ArrayList();
    protected ArrayList drop_listeners = new ArrayList();
    protected ArrayList root_nodes = new ArrayList();
    protected ArrayList model_change_listeners = new ArrayList();
    protected ArrayList agent_change_listeners = new ArrayList();
    protected ArrayList node_change_listeners = new ArrayList();
    protected URI current_project;
    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    protected HashMap updates = new HashMap();
    protected SDDescriptor selected_descriptor = null;
    protected long prev_used = 0L;

    public void setCurrentProjectURI(URI uri) {
        this.current_project = uri;
    }

    public URI getCurrentProjectURI() {
        return this.current_project;
    }

    public void showTab(int i) {
        this.graph_window.showTab(i);
    }

    public StatisticalModelGraphViewer(Composite parent, int style, boolean tabfolder) {
        EditorPlugin.DBG.info("constructor");
        this.initAsSash(parent);
    }

    public StatisticalModelGraphViewer(Composite parent, int style, boolean tabfolder, Dirtiable d, URI current_project) {
        EditorPlugin.DBG.info("constructor");
        this.dirtiable = d;
        this.current_project = current_project;
        this.initAsSash(parent);
        this.loadModules();
    }

    public void addModuleNodeChangeListener(ModuleNodeChangeListener listener) {
        this.node_change_listeners.add(listener);
    }

    public void removeModuleNodeChangeListener(ModuleNodeChangeListener listener) {
        this.node_change_listeners.remove(listener);
    }

    public void addModelChangeListener(ModelChangeListener listener) {
        this.model_change_listeners.add(listener);
    }

    public void removeModelChangeListener(ModelChangeListener listener) {
        this.model_change_listeners.remove(listener);
    }

    public void addAgentChangeListener(AgentChangeListener listener) {
        this.agent_change_listeners.add(listener);
    }

    public void removeAgentChangeListener(AgentChangeListener listener) {
        this.agent_change_listeners.remove(listener);
    }

    public String[] getModuleRefs() {
        String[] refs = new String[this.modules.size()];
        for (int i = 0; i < this.modules.size(); ++i) {
            refs[i] = ((StatConModule)this.modules.get(i)).getModuleRef();
        }
        return refs;
    }

    public StatConModule getModuleByRef(String ref) {
        return (StatConModule)this.module_refs.get(ref);
    }

    public void unloadModules() {
        EditorPlugin.DBG.info("unloading modules");
        for (int i = 0; i < this.modules.size(); ++i) {
            try {
                StatConModule module = (StatConModule)this.modules.get(i);
                EditorPlugin.DBG.info("unloading module " + i);
                module.unload();
                continue;
            }
            catch (Throwable t) {
                EditorPlugin.DBG.error("failed to unload module", t);
            }
        }
        this.modules.clear();
        this.module_refs.clear();
    }

    public ZoomSlider getSelectedSlider() {
        return this.graph_window.getSelectedSlider();
    }

    public double getSelectedSliderValue() {
        return this.graph_window.getSelectedSliderValue();
    }

    public void addSliderAction(String id, String name, Image image, Runnable runnable, boolean horizontal) {
        this.graph_window.addSliderAction(id, name, image, runnable, horizontal);
    }

    public void removeSliderAction(String id) {
        this.graph_window.removeSliderAction(id);
    }

    public void loadModules() {
        EditorPlugin.DBG.info("loading modules");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.hyades.statistical.ui.StatConModule");
        IExtension[] extensions = point.getExtensions();
        EditorPlugin.DBG.info("found " + extensions.length + " modules");
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] configs = extensions[i].getConfigurationElements();
            for (int z = 0; z < configs.length; ++z) {
                String clazz = configs[z].getAttribute("class");
                StatConModule module = null;
                try {
                    EditorPlugin.DBG.info("loading module " + i);
                    module = (StatConModule)configs[z].createExecutableExtension("class");
                    module.load(this);
                    this.module_refs.put(module.getModuleRef(), module);
                    this.modules.add(module);
                    EditorPlugin.DBG.info("loaded OK");
                    continue;
                }
                catch (Throwable e) {
                    try {
                        this.modules.remove(module);
                    }
                    catch (Throwable x) {
                        // empty catch block
                    }
                    try {
                        this.module_refs.remove(module);
                    }
                    catch (Throwable x) {
                        // empty catch block
                    }
                    EditorPlugin.DBG.logVisibleError(e, EditorPlugin.getString("ERROR_LOAD_MODULE") + " \"" + clazz + "\" ", false);
                    EditorPlugin.DBG.error("failed to load module", e);
                }
            }
        }
        EditorPlugin.DBG.info("finished loading modules");
    }

    private BasicAction findAction(String id, ArrayList actions) {
        for (int i = 0; i < actions.size(); ++i) {
            BasicAction action = (BasicAction)actions.get(i);
            if (!action.id.equals(id)) continue;
            return action;
        }
        return null;
    }

    private RootNode getRootNodeName(String name) {
        for (int i = 0; i < this.root_nodes.size(); ++i) {
            RootNode node = (RootNode)this.root_nodes.get(i);
            if (!node.name.equals(name)) continue;
            return node;
        }
        return null;
    }

    private RootNode getRootNodeID(String id) {
        for (int i = 0; i < this.root_nodes.size(); ++i) {
            RootNode node = (RootNode)this.root_nodes.get(i);
            if (!node.id.equals(id)) continue;
            return node;
        }
        return null;
    }

    private StatAgent getStatAgent(TRCAgent agent) {
        for (int i = 0; i < this.agents.size(); ++i) {
            StatAgent node = (StatAgent)this.agents.get(i);
            if (node.agent != agent) continue;
            return node;
        }
        return null;
    }

    private StatAgent getStatAgent(EList events) {
        for (int i = 0; i < this.agents.size(); ++i) {
            StatAgent node = (StatAgent)this.agents.get(i);
            if (node.agent.getDefaultEvents() != events) continue;
            return node;
        }
        return null;
    }

    public void addGlobalAction(String id, String name, Image image, Runnable runnable) {
        BasicAction action = this.findAction(id, this.global_actions);
        if (action == null) {
            action = new BasicAction();
            this.global_actions.add(action);
        }
        action.id = id;
        action.name = name;
        action.image = image;
        action.runnable = runnable;
        action.menuitem = new MenuItem(this.chooser_menu, 0);
        action.menuitem.setText(name);
        action.menuitem.setImage(image);
        action.menuitem.addSelectionListener((SelectionListener)action);
    }

    public void removeGlobalAction(String id) {
        BasicAction action = this.findAction(id, this.global_actions);
        if (action != null) {
            action.dispose();
            this.global_actions.remove(action);
        }
    }

    public void addDropTargetListener(String extension, StatConDropListener listener) {
        DropListener drop = new DropListener();
        drop.extension = extension;
        drop.listener = listener;
        this.drop_listeners.add(drop);
    }

    public void removeDropTargetListener(String extension) {
        for (int i = 0; i < this.drop_listeners.size(); ++i) {
            DropListener drop = (DropListener)this.drop_listeners.get(i);
            if (!drop.extension.equals(extension)) continue;
            this.drop_listeners.remove(drop);
        }
    }

    public void addModuleNode(String name, String id, Image image) throws EntityExistsException {
        if (this.getRootNodeID(id) != null) {
            throw new EntityExistsException(EditorPlugin.getString("ROOT_NODE_EXISTS") + " " + name + " " + EditorPlugin.getString("ROOT_NODE_EXISTS_2"));
        }
        RootNode node = new RootNode();
        node.name = name;
        node.image = image;
        node.id = id;
        node.item = new TreeItem(this.chooser_tree, 0, 0);
        node.item.setText(name);
        node.item.setImage(image);
        node.item.setGrayed(true);
        this.root_nodes.add(node);
        for (int i = 0; i < this.node_change_listeners.size(); ++i) {
            ModuleNodeChangeListener listener = (ModuleNodeChangeListener)this.node_change_listeners.get(i);
            listener.nodeAdded(id);
        }
    }

    public void addModuleNode(String name, String id, String parent_id, Image image) throws EntityExistsException, NullPointerException {
        if (this.getRootNodeID(id) != null) {
            throw new EntityExistsException(EditorPlugin.getString("ROOT_NODE_EXISTS") + " " + name + " " + EditorPlugin.getString("ROOT_NODE_EXISTS_2"));
        }
        RootNode parent = this.getRootNodeID(parent_id);
        if (parent == null) {
            throw new NullPointerException("");
        }
        RootNode node = new RootNode();
        node.name = name;
        node.image = image;
        node.id = id;
        node.parent_id = parent_id;
        node.item = new TreeItem(parent.item, 0, 0);
        node.item.setText(name);
        node.item.setImage(image);
        node.item.setGrayed(true);
        parent.node_children.add(node);
        this.root_nodes.add(node);
        for (int i = 0; i < this.node_change_listeners.size(); ++i) {
            ModuleNodeChangeListener listener = (ModuleNodeChangeListener)this.node_change_listeners.get(i);
            listener.nodeAdded(id);
        }
    }

    public void removeModuleNode(String id) {
        int i;
        RootNode node = this.getRootNodeID(id);
        if (node != null) {
            if (node.parent_id != null) {
                RootNode parent = this.getRootNodeID(node.parent_id);
                parent.node_children.remove(node);
            }
            for (i = 0; i < node.node_children.size(); ++i) {
                RootNode child = (RootNode)node.node_children.get(i);
                this.removeModuleNode(child.id);
            }
            node.dispose();
            this.root_nodes.remove(node);
        }
        for (i = 0; i < this.node_change_listeners.size(); ++i) {
            ModuleNodeChangeListener listener = (ModuleNodeChangeListener)this.node_change_listeners.get(i);
            listener.nodeRemoved(id);
        }
    }

    public void addModuleNodeAction(String node_id, String action_id, String action_name, Image action_image, Runnable runnable) {
        RootNode node = this.getRootNodeID(node_id);
        if (node != null) {
            BasicAction action = this.findAction(action_id, node.actions);
            if (action == null) {
                action = new BasicAction();
                node.actions.add(action);
            }
            action.id = action_id;
            action.name = action_name;
            action.image = action_image;
            action.runnable = runnable;
        }
    }

    public void removeModuleNodeAction(String node_id, String action_id) {
        RootNode node = this.getRootNodeID(node_id);
        if (node != null) {
            for (int i = 0; i < node.actions.size(); ++i) {
                BasicAction action = (BasicAction)node.actions.get(i);
                if (!action.id.equals(action_id)) continue;
                node.actions.remove(i);
                break;
            }
        }
    }

    public SDDescriptor[] addAgent(IFile ifile) throws IOException {
        return this.addAgent(ifile.getProjectRelativePath());
    }

    private Resource createResource(URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(uri, false);
        if (resource == null) {
            return resourceSet.createResource(uri);
        }
        return resource;
    }

    public SDDescriptor[] addAgent(IPath ipath) throws IOException {
        EditorPlugin.DBG.info("add trace agent");
        URI fileURI = URI.createPlatformResourceURI((String)ipath.toString());
        EditorPlugin.DBG.info("agent URI:" + fileURI);
        if (fileURI == null) {
            throw new IOException(EditorPlugin.getString("NULL_URI_WHILE_LOADING") + " " + ipath);
        }
        Resource resource = this.createResource(fileURI);
        if (resource == null) {
            throw new IOException(EditorPlugin.getString("NULL_RESOURCE_WHILE_LOADING") + " " + ipath);
        }
        if (resource instanceof XMLResource) {
            EditorPlugin.DBG.info("found XML resource for agent");
            XMLResource xresource = (XMLResource)resource;
            String msg = "";
            try {
                EditorPlugin.DBG.info("trying to load resource as an unzipped file");
                xresource.setUseZip(false);
                xresource.load(Collections.EMPTY_MAP);
                EditorPlugin.DBG.info("loaded resource OK as an unzipped file");
            }
            catch (Throwable e) {
                EditorPlugin.DBG.info("load failed as an unzipped file");
                msg = msg + e.toString() + " / ";
                resource = this.createResource(fileURI);
                xresource = (XMLResource)resource;
                try {
                    EditorPlugin.DBG.info("trying to load resource as a zipped file");
                    xresource.setUseZip(true);
                    xresource.load(Collections.EMPTY_MAP);
                    EditorPlugin.DBG.info("loaded resource OK as a zipped file");
                }
                catch (Throwable t) {
                    msg = msg + t.toString();
                    throw new IOException(msg);
                }
            }
        } else {
            EditorPlugin.DBG.info("found a non-XML resource for agent - trying to load anyway");
            if (!resource.isLoaded()) {
                resource.load(Collections.EMPTY_MAP);
            }
        }
        EList list = resource.getContents();
        EditorPlugin.DBG.info("got contents of agent resource (size " + list.size() + ")");
        return this.addAgentFromTree(list, fileURI);
    }

    private SDDescriptor[] addAgentFromTree(EList list, URI fileURI) {
        EditorPlugin.DBG.info("Searching Resource Contents (" + list.size() + ")");
        for (int k = 0; k < list.size(); ++k) {
            Object o = list.get(k);
            EditorPlugin.DBG.info("resource content " + k + " = " + o.getClass());
            if (o instanceof TRCAgentProxy) {
                TRCAgentProxy proxy = (TRCAgentProxy)o;
                return this.addAgent(proxy.getAgent(), fileURI);
            }
            if (!(o instanceof TRCAgent)) continue;
            return this.addAgent((TRCAgent)o, fileURI);
        }
        SDDescriptor[] descriptors = null;
        for (int k = 0; k < list.size(); ++k) {
            EObject o = (EObject)list.get(k);
            if (o instanceof TRCProcessProxy) {
                EditorPlugin.DBG.info("resource subcontent ProcessProxy");
                descriptors = this.addAgentFromTree(((TRCProcessProxy)o).getAgentProxies(), fileURI);
            } else if (o instanceof TRCNode) {
                EditorPlugin.DBG.info("resource subcontent Node");
                descriptors = this.addAgentFromTree(((TRCNode)o).getProcessProxies(), fileURI);
            } else if (o instanceof TRCMonitor) {
                EditorPlugin.DBG.info("resource subcontent Monitor");
                descriptors = this.addAgentFromTree(((TRCMonitor)o).getNodes(), fileURI);
            } else {
                EditorPlugin.DBG.info("resource subcontent " + k + " = " + o.getClass());
                descriptors = this.addAgentFromTree(o.eContents(), fileURI);
            }
            if (descriptors == null) continue;
            return descriptors;
        }
        return null;
    }

    public SDDescriptor[] addAgent(TRCAgent agent) {
        return this.addAgent(agent, null);
    }

    private StringBuffer cbeToString(CBECommonBaseEvent e, StringBuffer sb) {
        Date create = new Date((long)e.getCreationTime());
        this.sdf.format(create, sb, new FieldPosition(0));
        sb.append(" ");
        short sev = e.getSeverity();
        if (sev <= 10) {
            sb.append("(info)");
        } else if (sev <= 30) {
            sb.append("(warning)");
        } else if (sev <= 40) {
            sb.append("(error)");
        } else if (sev <= 60) {
            sb.append("(critical)");
        }
        sb.append(" ");
        if (e.getRepeatCount() > 0) {
            sb.append("(x");
            sb.append(e.getRepeatCount());
            sb.append(") ");
        }
        sb.append(e.getSourceComponentId().getComponent());
        if (e.getSourceComponentId().getSubComponent() != null) {
            sb.append(" / ");
            sb.append(e.getSourceComponentId().getSubComponent());
        }
        sb.append(" - ");
        sb.append(e.getMsg());
        sb.append("\n");
        return sb;
    }

    private int appendCBEs(List events, int index) {
        StringBuffer sb = new StringBuffer();
        for (int i = index; i < events.size(); ++i) {
            CBECommonBaseEvent e = (CBECommonBaseEvent)events.get(i);
            this.cbeToString(e, sb);
        }
        this.graph_window.appendCBEText(sb.toString());
        return events.size();
    }

    private int setCBEs(List events, int index) {
        StringBuffer sb = new StringBuffer();
        for (int i = index; i < events.size(); ++i) {
            CBECommonBaseEvent e = (CBECommonBaseEvent)events.get(i);
            this.cbeToString(e, sb);
        }
        this.graph_window.setCBEText(sb.toString());
        return events.size();
    }

    private void sortCBEs(List events) {
        Collections.sort(events, new CBEComparator());
    }

    private void appendCBEs(StatAgent agent) {
        if (agent.show_messages) {
            agent.msgindex = this.appendCBEs((List)agent.agent.getDefaultEvents(), agent.msgindex);
        }
    }

    private void appendAllCBEs() {
        for (int i = 0; i < this.agents.size(); ++i) {
            StatAgent agent = (StatAgent)this.agents.get(i);
            agent.msgindex = this.appendCBEs((List)agent.agent.getDefaultEvents(), agent.msgindex);
        }
    }

    private void redoAllCBEs() {
        ArrayList all_events = new ArrayList();
        for (int i = 0; i < this.agents.size(); ++i) {
            StatAgent agent = (StatAgent)this.agents.get(i);
            if (!agent.show_messages) continue;
            agent.msgindex = agent.agent.getDefaultEvents().size();
            all_events.addAll(agent.agent.getDefaultEvents());
        }
        this.sortCBEs(all_events);
        this.setCBEs(all_events, 0);
    }

    public void updateCBELog() {
        this.appendAllCBEs();
    }

    public void reloadCBELog() {
        this.redoAllCBEs();
    }

    public SDDescriptor[] updateAgent(TRCAgent agent) {
        for (int i = 0; i < this.agents.size(); ++i) {
            StatAgent node = (StatAgent)this.agents.get(i);
            EditorPlugin.DBG.info("agent " + i + " = " + node.agent.getName());
        }
        StatAgent statagent = this.getStatAgent(agent);
        if (statagent == null) {
            EditorPlugin.DBG.info("update requested on non-existent agent " + agent.getName());
            return null;
        }
        EList direct_children = agent.eContents();
        EditorPlugin.DBG.info("checking agent's " + direct_children.size() + " children for Statistical Models");
        ArrayList<Object> added = new ArrayList<Object>();
        for (int z = 0; z < direct_children.size(); ++z) {
            Object co = direct_children.get(z);
            EditorPlugin.DBG.info("agent child " + z + " = " + co.getClass());
            if (!(co instanceof SDDescriptor)) continue;
            EditorPlugin.DBG.info("adding agent SDDescriptor (statistical model)");
            if (statagent.model_roots.contains(co)) {
                this.updateModel((SDDescriptor)co, statagent);
                added.add(co);
                continue;
            }
            this.addModel((SDDescriptor)co, statagent);
            added.add(co);
        }
        SDDescriptor[] des = new SDDescriptor[added.size()];
        for (int i = 0; i < des.length; ++i) {
            des[i] = (SDDescriptor)added.get(i);
        }
        this.updateTreeItems();
        return des;
    }

    public SDDescriptor[] addAgent(TRCAgent agent, URI fileURI) {
        int i;
        StatAgent node;
        int i2;
        if (agent == null) {
            EditorPlugin.DBG.logVisibleError(new Exception("Null Agent"), EditorPlugin.getString("ERROR_NULL_AGENT") + " " + fileURI, false);
            return null;
        }
        if (agent.getName() == null) {
            EditorPlugin.DBG.logVisibleError(new Exception("Null Agent Name"), EditorPlugin.getString("ERROR_NULL_NAME") + " " + fileURI, false);
            return null;
        }
        EditorPlugin.DBG.info("add valid agent " + agent.getName() + " / " + fileURI);
        for (i2 = 0; i2 < this.agents.size(); ++i2) {
            node = (StatAgent)this.agents.get(i2);
            EditorPlugin.DBG.info("agent " + i2 + " = " + node.agent.getName());
        }
        if (fileURI != null) {
            for (i2 = 0; i2 < this.agents.size(); ++i2) {
                node = (StatAgent)this.agents.get(i2);
                URI uri = node.uri;
                if (uri == null || !uri.equals((Object)fileURI)) continue;
                EditorPlugin.DBG.info("URI matched to an existing agent - returning without adding");
                return null;
            }
        }
        EditorPlugin.DBG.info("creating new agent");
        StatAgent statagent = this.getStatAgent(agent);
        if (statagent == null) {
            statagent = new StatAgent();
            this.agents.add(statagent);
        }
        statagent.agent = agent;
        statagent.uri = fileURI;
        TreeItem item = new TreeItem(this.chooser_tree, 0);
        item.setText(agent.getName());
        item.setChecked(true);
        item.setGrayed(false);
        this.trcagent_map.put(item, agent);
        this.reverse_map.put(agent, item);
        this.addAgentAction(statagent.agent, "AGENT_REMOVE", EditorPlugin.getString("AGENT_REMOVE"), this.img.getImage("smodel_remove.gif"), new AgentRemoveAction(statagent.agent));
        EList events = agent.getDefaultEvents();
        EditorPlugin.DBG.info("interleaving all agent CBE messages");
        this.redoAllCBEs();
        TreeItem msg = new TreeItem(item, 0);
        msg.setImage(this.img.getImage("smodel_cbemessage.gif"));
        msg.setText(EditorPlugin.getString("MESSAGES"));
        msg.setChecked(true);
        msg.setGrayed(false);
        this.msglist_map.put(msg, events);
        this.reverse_map.put(events, msg);
        ArrayList<Object> added = new ArrayList<Object>();
        EList direct_children = agent.eContents();
        EditorPlugin.DBG.info("checking agent's " + direct_children.size() + " children for Statistical Models");
        for (int z = 0; z < direct_children.size(); ++z) {
            Object co = direct_children.get(z);
            EditorPlugin.DBG.info("agent child " + z + " = " + co.getClass());
            if (!(co instanceof SDDescriptor)) continue;
            EditorPlugin.DBG.info("adding agent SDDescriptor (statistical model)");
            if (statagent.model_roots.contains(co)) continue;
            this.addModel((SDDescriptor)co, statagent);
            added.add(co);
        }
        SDDescriptor[] des = new SDDescriptor[added.size()];
        for (i = 0; i < des.length; ++i) {
            des[i] = (SDDescriptor)added.get(i);
        }
        EditorPlugin.DBG.info("agent added ok");
        for (i = 0; i < this.agents.size(); ++i) {
            StatAgent node2 = (StatAgent)this.agents.get(i);
            EditorPlugin.DBG.info("agent " + i + " = " + node2.agent.getName());
        }
        EditorPlugin.DBG.info("notifying agent listeners");
        for (i = 0; i < this.agent_change_listeners.size(); ++i) {
            AgentChangeListener listener = (AgentChangeListener)this.agent_change_listeners.get(i);
            EditorPlugin.DBG.info("notifying agent listener " + listener.getClass().getName());
            try {
                listener.agentAdded(agent);
                continue;
            }
            catch (Throwable t) {
                EditorPlugin.DBG.logVisibleError(t, EditorPlugin.getString("ERROR_NOTIFY_ADD"), false);
            }
        }
        this.updateTreeItems();
        return des;
    }

    public void updateModel(SDDescriptor model_node) {
        SDDescriptor parent = model_node.getParent();
        TreeItem parent_item = null;
        if (parent == null) {
            TRCAgent agent = model_node.getAgent();
            parent_item = (TreeItem)this.reverse_map.get(agent);
        } else {
            parent_item = (TreeItem)this.reverse_map.get(parent);
        }
        if (parent_item != null) {
            this.addModelToChooser(model_node, parent_item, true);
            EditorPlugin.DBG.info("model node updated - " + model_node.getName());
            this.treeItemSelected(parent_item);
        }
    }

    private void updateModel(SDDescriptor model_root, StatAgent statagent) {
        EditorPlugin.DBG.mark("updating model - " + model_root.getName());
        this.addModelToChooser(model_root, statagent.agent, true);
        EditorPlugin.DBG.mark("model updated - " + model_root.getName());
        this.updateAgentImages();
    }

    private void addModel(SDDescriptor model_root, StatAgent statagent) {
        this.addModelToChooser(model_root, statagent.agent, false);
        statagent.model_roots.add(model_root);
        EditorPlugin.DBG.info("model added - " + model_root.getName());
        for (int i = 0; i < this.model_change_listeners.size(); ++i) {
            ModelChangeListener listener = (ModelChangeListener)this.model_change_listeners.get(i);
            listener.modelAdded(model_root);
        }
        EditorPlugin.DBG.info("notified listeners");
        this.updateAgentImages();
    }

    public void setAgentFile(TRCAgent trcagent, IFile ifile) {
        URI fileURI = URI.createPlatformResourceURI((String)ifile.getProjectRelativePath().toString());
        this.setAgentFile(trcagent, fileURI);
    }

    public void setAgentFile(TRCAgent trcagent, URI model_uri) {
        StatAgent statmodel = this.getStatAgent(trcagent);
        EditorPlugin.DBG.info("set agent file " + trcagent.getName() + " / " + model_uri);
        if (statmodel != null) {
            URI uri = statmodel.uri;
            if (uri != null) {
                if (!uri.equals((Object)model_uri)) {
                    this.setDirty(true);
                }
            } else if (model_uri != null) {
                this.setDirty(true);
            }
            statmodel.uri = model_uri;
        }
    }

    public void setAgentImage(TRCAgent trcagent, Image image) {
        EditorPlugin.DBG.info("set agent " + trcagent.getName() + " image");
        StatAgent agent = this.getStatAgent(trcagent);
        if (agent != null) {
            agent.image = image;
        }
        this.updateAgentImages();
    }

    private void updateAgentImages() {
        for (int i = 0; i < this.agents.size(); ++i) {
            TreeItem agent_item;
            StatAgent agent = (StatAgent)this.agents.get(i);
            if (agent.agent == null || (agent_item = (TreeItem)this.reverse_map.get(agent.agent)) == null) continue;
            if (agent.image == null) {
                agent_item.setImage(this.img.getImage("smodel_trcagent.gif"));
                continue;
            }
            agent_item.setImage(agent.image);
        }
    }

    public void addModelAction(TRCAgent trcagent, String action_id, String action_name, Image image, Runnable runnable) {
        BasicAction action;
        StatAgent agent = this.getStatAgent(trcagent);
        if (agent == null) {
            agent = new StatAgent();
            agent.agent = trcagent;
            this.agents.add(agent);
        }
        if ((action = this.findAction(action_id, agent.modelactions)) == null) {
            action = new BasicAction();
            agent.modelactions.add(action);
        }
        action.id = action_id;
        action.name = action_name;
        action.image = image;
        action.runnable = runnable;
    }

    public void removeModelAction(TRCAgent trcagent, String action_id) {
        StatAgent agent = this.getStatAgent(trcagent);
        if (agent != null) {
            for (int i = 0; i < agent.modelactions.size(); ++i) {
                BasicAction action = (BasicAction)agent.modelactions.get(i);
                if (!action.id.equals(action_id)) continue;
                agent.modelactions.remove(i);
                break;
            }
        }
    }

    public void addAgentAction(TRCAgent trcagent, String action_id, String action_name, Image image, Runnable runnable) {
        BasicAction action;
        StatAgent agent = this.getStatAgent(trcagent);
        if (agent == null) {
            agent = new StatAgent();
            agent.agent = trcagent;
            this.agents.add(agent);
        }
        if ((action = this.findAction(action_id, agent.actions)) == null) {
            action = new BasicAction();
            agent.actions.add(action);
        }
        action.id = action_id;
        action.name = action_name;
        action.image = image;
        action.runnable = runnable;
    }

    public void removeAgentAction(TRCAgent trcagent, String action_id) {
        StatAgent agent = this.getStatAgent(trcagent);
        if (agent != null) {
            for (int i = 0; i < agent.actions.size(); ++i) {
                BasicAction action = (BasicAction)agent.actions.get(i);
                if (!action.id.equals(action_id)) continue;
                agent.actions.remove(i);
                break;
            }
        }
    }

    public void setDirty(boolean b) {
        if (this.dirtiable != null) {
            this.dirtiable.setDirty(b);
        }
    }

    public Color parseColor(String col, Color def) {
        try {
            if (!col.startsWith("#")) {
                throw new Exception();
            }
            if (col.length() != 7) {
                throw new Exception();
            }
            String sr = col.substring(1, 3);
            String sg = col.substring(3, 5);
            String sb = col.substring(5, 7);
            int r = Integer.parseInt(sr, 16);
            int g = Integer.parseInt(sg, 16);
            int b = Integer.parseInt(sb, 16);
            RGB rgb = XMLConfigUtil.parseColor(col, def.getRGB());
            Color c = new Color((Device)this.graph_window.getDisplay(), rgb);
            this.disposables.add(c);
            return c;
        }
        catch (Throwable e) {
            return def;
        }
    }

    public void applyConfig(InputStream config_xml) throws Exception {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            int n = 0;
            while (n != -1) {
                n = config_xml.read(buf, 0, buf.length);
                if (n <= 0) continue;
                bout.write(buf, 0, n);
            }
            String xml = new String(bout.toByteArray());
            this.applyConfig(xml);
        }
        catch (Exception t) {
            EditorPlugin.DBG.warning("error applying configuration", t);
            throw t;
        }
    }

    public void applyConfig(String config_xml) throws Exception {
        try {
            ByteArrayInputStream config_stream = new ByteArrayInputStream(config_xml.getBytes());
            Document doc = XMLConfigUtil.getDocumentBuilder().parse(config_stream);
            EditorPlugin.DBG.info("applying configuration");
            this.applyConfig(doc);
            EditorPlugin.DBG.info("applying configuration to all modules");
            for (int i = 0; i < this.modules.size(); ++i) {
                StatConModule module = (StatConModule)this.modules.get(i);
                module.applyConfig(config_xml);
            }
        }
        catch (Exception t) {
            EditorPlugin.DBG.warning("error applying configuration", t);
            throw t;
        }
    }

    private void applyConfig(Document doc) throws Exception {
        try {
            Element doc_element = doc.getDocumentElement();
            if (!doc_element.getTagName().equals("smgconfig")) {
                EditorPlugin.DBG.error("bad configuration - no valid root <smgconfig> element");
                throw new Exception(EditorPlugin.getString("BAD_ROOT_XML_NODE"));
            }
            EditorPlugin.DBG.info("loading all module data");
            ArrayList moduledats = XMLConfigUtil.getAllElements(doc_element.getChildNodes(), "module_data");
            for (int k = 0; k < moduledats.size(); ++k) {
                try {
                    Element mod_dat = (Element)moduledats.get(k);
                    String ref = mod_dat.getAttribute("ref");
                    String data = mod_dat.getAttribute("data");
                    StatConModule module = (StatConModule)this.module_refs.get(ref);
                    if (module != null) {
                        module.loadModuleData(HexData.hexStringToByteArray(data));
                        continue;
                    }
                    EditorPlugin.DBG.warning("Found data for missing module " + ref);
                    continue;
                }
                catch (Exception e) {
                    EditorPlugin.DBG.error("Error loading data for module " + k, e);
                }
            }
            ArrayList xml_models = XMLConfigUtil.getAllElements(doc_element.getChildNodes(), "model");
            EditorPlugin.DBG.info("found " + xml_models.size() + " agent references");
            for (int i = 0; i < xml_models.size(); ++i) {
                try {
                    Element model = (Element)xml_models.get(i);
                    String file = model.getAttribute("file");
                    EditorPlugin.DBG.info("trying to load agent " + file);
                    Path path = new Path(file);
                    IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IFile ifile = workspaceRoot.getFile((IPath)path);
                    this.addAgent(ifile);
                    continue;
                }
                catch (Throwable t) {
                    EditorPlugin.DBG.logVisibleError(t, EditorPlugin.getString("ERROR_LOAD_CONFIG"), true);
                }
            }
            ArrayList graphs = XMLConfigUtil.getAllElements(doc_element.getChildNodes(), "graph");
            EditorPlugin.DBG.info("found " + graphs.size() + " graph configurations");
            for (int i = 0; i < graphs.size(); ++i) {
                try {
                    boolean max_locked;
                    boolean min_locked;
                    double resolution;
                    double max_vis;
                    double min_vis;
                    double max_limit;
                    double min_limit;
                    String title;
                    int k;
                    Element graph = (Element)graphs.get(i);
                    if (EditorPlugin.DBG.check("configuration")) {
                        EditorPlugin.DBG.info("applying graph configuration");
                    }
                    Color color = this.parseColor(graph.getAttribute("color"), this.graph_window.getDisplay().getSystemColor(25));
                    boolean match_color = XMLConfigUtil.parseBoolean(graph.getAttribute("match_colors"), false);
                    this.graph_window.setSlidersMatchGraph(match_color);
                    this.graph_window.setGraphBackground(color);
                    ArrayList ysliders = XMLConfigUtil.getAllElements(graph.getChildNodes(), "yslider");
                    ArrayList xsliders = XMLConfigUtil.getAllElements(graph.getChildNodes(), "xslider");
                    EditorPlugin.DBG.info("X slider count of " + xsliders.size());
                    EditorPlugin.DBG.info("Y slider count of " + ysliders.size());
                    while (this.graph_window.getYSliderCount() > ysliders.size()) {
                        this.graph_window.removeYSlider(0);
                    }
                    while (this.graph_window.getYSliderCount() < Math.max(1, ysliders.size())) {
                        this.graph_window.addYSlider();
                    }
                    while (this.graph_window.getXSliderCount() > xsliders.size()) {
                        this.graph_window.removeXSlider(0);
                    }
                    while (this.graph_window.getXSliderCount() < Math.max(1, xsliders.size())) {
                        this.graph_window.addXSlider();
                    }
                    for (k = 0; k < ysliders.size(); ++k) {
                        Element yslider = (Element)ysliders.get(k);
                        title = yslider.getAttribute("title");
                        min_limit = XMLConfigUtil.parseDouble(yslider.getAttribute("min_limit"), -1.0E8);
                        max_limit = XMLConfigUtil.parseDouble(yslider.getAttribute("max_limit"), 1.0E8);
                        min_vis = XMLConfigUtil.parseDouble(yslider.getAttribute("min_vis"), 0.0);
                        max_vis = XMLConfigUtil.parseDouble(yslider.getAttribute("max_vis"), 5000.0);
                        resolution = XMLConfigUtil.parseDouble(yslider.getAttribute("resolution"), 0.01);
                        min_locked = XMLConfigUtil.parseBoolean(yslider.getAttribute("min_locked"), false);
                        max_locked = XMLConfigUtil.parseBoolean(yslider.getAttribute("max_locked"), false);
                        EditorPlugin.DBG.info("Configuring Y slider " + k + " " + title);
                        ZoomSlider slider = this.graph_window.getYSlider(k);
                        slider.setTitle(title);
                        slider.lock(0, min_locked);
                        slider.lock(1, max_locked);
                        slider.configure(min_limit, max_limit, min_vis, max_vis, resolution);
                    }
                    for (k = 0; k < xsliders.size(); ++k) {
                        Element xslider = (Element)xsliders.get(k);
                        title = xslider.getAttribute("title");
                        min_limit = XMLConfigUtil.parseDouble(xslider.getAttribute("min_limit"), 0.0);
                        max_limit = XMLConfigUtil.parseDouble(xslider.getAttribute("max_limit"), 7200000.0);
                        min_vis = XMLConfigUtil.parseDouble(xslider.getAttribute("min_vis"), 0.0);
                        max_vis = XMLConfigUtil.parseDouble(xslider.getAttribute("max_vis"), 180000.0);
                        resolution = XMLConfigUtil.parseDouble(xslider.getAttribute("resolution"), 0.01);
                        min_locked = XMLConfigUtil.parseBoolean(xslider.getAttribute("min_locked"), false);
                        max_locked = XMLConfigUtil.parseBoolean(xslider.getAttribute("max_locked"), false);
                        boolean following = XMLConfigUtil.parseBoolean(xslider.getAttribute("following"), false);
                        EditorPlugin.DBG.info("Configuring X slider " + k);
                        TimeZoomSlider slider = this.graph_window.getXSlider(k);
                        slider.setTitle(title);
                        slider.lock(0, min_locked);
                        slider.lock(1, max_locked);
                        slider.configure(min_limit, max_limit, min_vis, max_vis, resolution);
                        this.graph_window.setTimeSliderFollowing(slider, following);
                    }
                    continue;
                }
                catch (Throwable t) {
                    EditorPlugin.DBG.logVisibleError(t, EditorPlugin.getString("ERROR_APPLY_GRAPH"), true);
                }
            }
            ArrayList agent_roots = XMLConfigUtil.getAllElements(doc_element.getChildNodes(), "agent");
            EditorPlugin.DBG.info("found " + agent_roots.size() + " agent/model configurations");
            for (int i = 0; i < agent_roots.size(); ++i) {
                try {
                    Element agent_root = (Element)agent_roots.get(i);
                    String rootname = agent_root.getAttribute("name");
                    boolean found = false;
                    for (int k = 0; k < this.agents.size(); ++k) {
                        StatAgent agent = (StatAgent)this.agents.get(k);
                        if (agent.agent == null || !agent.agent.getName().equals(rootname)) continue;
                        EditorPlugin.DBG.info("Applying configuration to agent " + rootname + "");
                        found = true;
                        this.applyAgentConfig(agent, agent_root);
                    }
                    if (found) continue;
                    EditorPlugin.DBG.warning("Could not find agent " + rootname + " - unable to apply this config");
                    continue;
                }
                catch (Throwable t) {
                    EditorPlugin.DBG.logVisibleError(t, EditorPlugin.getString("ERROR_APPLY_MODEL"), true);
                }
            }
            TreeItem[] items = this.chooser_tree.getItems();
            for (int i = 0; i < items.length; ++i) {
                try {
                    this.treeItemSelected(items[i]);
                    continue;
                }
                catch (Throwable t) {
                    EditorPlugin.DBG.logVisibleError(t, EditorPlugin.getString("ERROR_UPDATE_MODEL"), true);
                }
            }
            this.graph_window.updateTables();
        }
        catch (Exception t) {
            EditorPlugin.DBG.warning("error applying configuration", t);
            throw t;
        }
    }

    private HashMap mapChildrenByName(StatAgent agent) {
        HashMap<String, SDDescriptor> map = new HashMap<String, SDDescriptor>(128, 0.75f);
        ArrayList list = agent.model_roots;
        for (int i = 0; i < list.size(); ++i) {
            SDDescriptor tmp = (SDDescriptor)list.get(i);
            map.put(tmp.getName(), tmp);
        }
        return map;
    }

    private HashMap mapChildrenByName(TRCAgent agent) {
        HashMap<String, SDDescriptor> map = new HashMap<String, SDDescriptor>(128, 0.75f);
        EList list = agent.getDescriptor();
        for (int i = 0; i < list.size(); ++i) {
            SDDescriptor tmp = (SDDescriptor)list.get(i);
            map.put(tmp.getName(), tmp);
        }
        return map;
    }

    private HashMap mapChildrenByName(SDDescriptor descriptor) {
        HashMap<String, SDDescriptor> map = new HashMap<String, SDDescriptor>(128, 0.75f);
        EList list = descriptor.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            SDDescriptor tmp = (SDDescriptor)list.get(i);
            map.put(tmp.getName(), tmp);
        }
        return map;
    }

    private void applyAgentConfig(StatAgent agent, Element element) throws Exception {
        boolean sd_ticked = XMLConfigUtil.parseBoolean(element.getAttribute("ticked"), true);
        boolean sd_expanded = XMLConfigUtil.parseBoolean(element.getAttribute("expanded"), false);
        TreeItem item = (TreeItem)this.reverse_map.get(agent.agent);
        item.setChecked(sd_ticked);
        item.setExpanded(sd_expanded);
        Element cbeconfig = XMLConfigUtil.getFirstElement(element.getChildNodes(), "cbelog");
        if (cbeconfig != null) {
            EditorPlugin.DBG.info(" agent CBE log configuration");
            this.applyCBEConfig(agent.agent.getDefaultEvents(), cbeconfig, sd_ticked);
        }
        ArrayList descriptor_roots = XMLConfigUtil.getAllElements(element.getChildNodes(), "descriptor");
        EditorPlugin.DBG.info("found " + descriptor_roots.size() + " model configurations");
        HashMap dmap = this.mapChildrenByName(agent);
        for (int i = 0; i < descriptor_roots.size(); ++i) {
            Element model_root = (Element)descriptor_roots.get(i);
            String rootname = model_root.getAttribute("name");
            boolean found = false;
            SDDescriptor descriptor = (SDDescriptor)dmap.get(rootname);
            if (descriptor != null) {
                if (EditorPlugin.DBG.check("configuration")) {
                    EditorPlugin.DBG.info("Applying configuration to model " + rootname);
                }
                try {
                    this.applyModelConfig(descriptor, model_root, sd_ticked);
                }
                catch (Throwable e) {
                    EditorPlugin.DBG.error("problem applying model configuration", e);
                }
                continue;
            }
            EditorPlugin.DBG.warning("Could not find model " + rootname + " - unable to apply this model configuration");
        }
    }

    private void applyCBEConfig(EList events, Element element, boolean parent_checked) throws Exception {
        boolean ticked = XMLConfigUtil.parseBoolean(element.getAttribute("ticked"), true);
        boolean expanded = XMLConfigUtil.parseBoolean(element.getAttribute("expanded"), false);
        TreeItem item = (TreeItem)this.reverse_map.get(events);
        if (item == null) {
            return;
        }
        item.setChecked(ticked);
        item.setExpanded(expanded);
        if (parent_checked) {
            item.setGrayed(false);
        } else {
            item.setGrayed(true);
        }
        ArrayList locations = XMLConfigUtil.getAllElements(element.getChildNodes(), "component");
        for (int i = 0; i < locations.size(); ++i) {
            Element comp_element = (Element)locations.get(i);
            boolean comp_ticked = XMLConfigUtil.parseBoolean(comp_element.getAttribute("ticked"), true);
            boolean comp_expanded = XMLConfigUtil.parseBoolean(comp_element.getAttribute("expanded"), false);
            String comp_type = comp_element.getAttribute("componentIdType");
            String comp_main = comp_element.getAttribute("component");
            String comp_sub = comp_element.getAttribute("subcomponent");
        }
    }

    private void applyModelConfig(SDDescriptor descriptor, Element element, boolean parent_checked) throws Exception {
        boolean sd_ticked = XMLConfigUtil.parseBoolean(element.getAttribute("ticked"), true);
        boolean sd_expanded = XMLConfigUtil.parseBoolean(element.getAttribute("expanded"), false);
        TreeItem item = (TreeItem)this.reverse_map.get(descriptor);
        item.setChecked(sd_ticked);
        item.setExpanded(sd_expanded);
        if (parent_checked) {
            item.setGrayed(false);
        } else {
            item.setGrayed(true);
        }
        ArrayList obs_graphs = XMLConfigUtil.getAllElements(element.getChildNodes(), "obs_graph");
        for (int i = 0; i < obs_graphs.size(); ++i) {
            Element obs_graph = (Element)obs_graphs.get(i);
            boolean ticked = XMLConfigUtil.parseBoolean(obs_graph.getAttribute("ticked"), true);
            int obs_index = (int)XMLConfigUtil.parseDouble(obs_graph.getAttribute("obs_index"), 0.0);
            int x_slider = (int)XMLConfigUtil.parseDouble(obs_graph.getAttribute("x_slider"), 0.0);
            int y_slider = (int)XMLConfigUtil.parseDouble(obs_graph.getAttribute("y_slider"), 0.0);
            Color color = this.parseColor(obs_graph.getAttribute("color"), this.graph_window.getDisplay().getSystemColor(this.colours[this.next++]));
            if (this.next >= this.colours.length) {
                this.next = 0;
            }
            int line_width = (int)XMLConfigUtil.parseDouble(obs_graph.getAttribute("line_width"), 1.0);
            int line_style = XMLConfigUtil.parseLineStyle(obs_graph.getAttribute("line_style"), 1);
            double multiplier = XMLConfigUtil.parseDouble(obs_graph.getAttribute("multiplier"), 1.0);
            if (EditorPlugin.DBG.check("configuration")) {
                EditorPlugin.DBG.info("Applying graph configuration for " + descriptor.getName() + " " + ticked + " " + color);
            }
            if (x_slider < 0) {
                x_slider = 0;
            }
            if (x_slider > this.graph_window.getXSliderCount()) {
                x_slider = 0;
            }
            if (y_slider < 0) {
                y_slider = 0;
            }
            if (y_slider > this.graph_window.getYSliderCount()) {
                y_slider = 0;
            }
            if (descriptor instanceof SDMemberDescriptor) {
                SDMemberDescriptor memdescriptor = (SDMemberDescriptor)descriptor;
                EList obs_list = memdescriptor.getSnapshotObservation();
                if (obs_index >= 0 && obs_index < obs_list.size()) {
                    SDSnapshotObservation observation = (SDSnapshotObservation)obs_list.get(obs_index);
                    TreeItem obs_item = (TreeItem)this.reverse_map.get(observation);
                    obs_item.setChecked(ticked);
                    obs_item.setGrayed(!sd_ticked || !parent_checked);
                    this.treeItemSelected(obs_item);
                    BasicGraphSource source = (BasicGraphSource)this.source_map.get(obs_item);
                    if (source != null) {
                        Graph graph = (Graph)this.source_graph_map.get(source);
                        if (graph != null) {
                            graph.setXSlider(this.graph_window.getXSlider(x_slider));
                            graph.setYSlider(this.graph_window.getYSlider(y_slider));
                            graph.setForeground(color);
                            graph.setLineWidth(line_width);
                            graph.setLineStyle(line_style);
                            graph.setStaticScaling(multiplier);
                            continue;
                        }
                        EditorPlugin.DBG.warning("Could not find graph - no graph found for " + obs_item.getText());
                        continue;
                    }
                    EditorPlugin.DBG.warning("Could not find graph - no graph source found for " + obs_item.getText());
                    continue;
                }
                EditorPlugin.DBG.warning("Could not find graph - observation index out of range " + obs_index + " / " + obs_list.size());
                continue;
            }
            EditorPlugin.DBG.warning("Could not find graph - descriptor is not a member descriptor");
        }
        ArrayList obs_controls = XMLConfigUtil.getAllElements(element.getChildNodes(), "control");
        for (int i = 0; i < obs_controls.size(); ++i) {
            Element obs_control = (Element)obs_controls.get(i);
            boolean ticked = XMLConfigUtil.parseBoolean(obs_control.getAttribute("ticked"), true);
            int y_slider = (int)XMLConfigUtil.parseDouble(obs_control.getAttribute("y_slider"), 0.0);
            if (EditorPlugin.DBG.check("configuration")) {
                EditorPlugin.DBG.info("Applying control configuration for " + descriptor.getName() + " (yslider:" + y_slider + ")");
            }
            if (descriptor instanceof SDMemberDescriptor) {
                SDMemberDescriptor memdescriptor = (SDMemberDescriptor)descriptor;
                SDRepresentation representation = memdescriptor.getRepresentation();
                if (representation instanceof SDModifiableVariableRepresentation) {
                    SDModifiableVariableRepresentation rep = (SDModifiableVariableRepresentation)representation;
                    try {
                        TreeItem rep_item = (TreeItem)this.reverse_map.get(rep);
                        rep_item.setChecked(ticked);
                        rep_item.setGrayed(!sd_ticked || !parent_checked);
                        if (y_slider >= 0 && y_slider < this.graph_window.getYSliderCount()) {
                            this.bar_slider_map.put(rep_item, this.graph_window.getYSlider(y_slider));
                        }
                        this.treeItemSelected(rep_item);
                        ModifiableVariableBar bar = (ModifiableVariableBar)this.bar_map.get(rep_item);
                        if (bar != null) {
                            if (bar.bar != null) {
                                this.graph_window.barMoved(bar.bar, y_slider);
                            }
                        } else {
                            EditorPlugin.DBG.warning("Could not find bar for representation " + rep_item.getText());
                        }
                        if (y_slider < 0 || y_slider >= this.graph_window.getYSliderCount()) continue;
                        this.bar_slider_map.put(rep_item, this.graph_window.getYSlider(y_slider));
                    }
                    catch (NullPointerException e) {
                        EditorPlugin.DBG.warning("Could not find rep item", e);
                    }
                    continue;
                }
                EditorPlugin.DBG.warning("Could not find control - representation is not a modifiable variable representation");
                continue;
            }
            EditorPlugin.DBG.warning("Could not find control - descriptor is not a member descriptor");
        }
        ArrayList descriptor_children = XMLConfigUtil.getAllElements(element.getChildNodes(), "descriptor");
        HashMap dmap = this.mapChildrenByName(descriptor);
        for (int i = 0; i < descriptor_children.size(); ++i) {
            Element child = (Element)descriptor_children.get(i);
            String childname = child.getAttribute("name");
            SDDescriptor child_descriptor = (SDDescriptor)dmap.get(childname);
            if (child_descriptor != null) {
                if (EditorPlugin.DBG.check("configuration")) {
                    EditorPlugin.DBG.info("Applying configuration to descriptor " + childname);
                }
                this.applyModelConfig(child_descriptor, child, sd_ticked && parent_checked);
                continue;
            }
            EditorPlugin.DBG.warning("Could not find descriptor - descriptor of name " + childname + " was not found under descriptor " + descriptor.getName());
        }
    }

    public String generateConfig() {
        return this.generateConfig("");
    }

    public String generateConfig(String extra_xml) {
        ZoomSlider slider;
        StatAgent agent;
        int i;
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xml.append("<!-- Statistical Model Graph Viewer configuration file -->\n");
        xml.append("<!-- Not intended to be human editable - edit at your own risk -->\n");
        xml.append("<smgconfig>\n");
        xml.append(extra_xml);
        for (i = 0; i < this.modules.size(); ++i) {
            StatConModule module = (StatConModule)this.modules.get(i);
            String moduleref = module.getModuleRef();
            try {
                byte[] moduledat = module.saveModuleData();
                String hex = HexData.byteArrayToHexString(moduledat);
                xml.append("<module_data ref=\"" + moduleref + "\" data=\"" + hex + "\" />\n");
                continue;
            }
            catch (Exception e) {
                EditorPlugin.DBG.logVisibleError(e, EditorPlugin.getString("ERROR_SAVING_MODULE") + " " + moduleref, false);
            }
        }
        for (i = 0; i < this.agents.size(); ++i) {
            agent = (StatAgent)this.agents.get(i);
            URI uri = agent.uri;
            if (uri == null) continue;
            xml.append("<model file=\"").append(uri).append("\" />\n");
        }
        xml.append("<graph color=\"").append(XMLConfigUtil.colorToString(this.graph_window.getGraphBackground())).append("\" match_colors=\"").append(this.graph_window.getSlidersMatchGraph()).append("\" >\n");
        for (i = 0; i < this.graph_window.getYSliderCount(); ++i) {
            slider = this.graph_window.getYSlider(i);
            xml.append("  <yslider ");
            xml.append("title=\"").append(slider.getTitle()).append("\" ");
            xml.append("min_limit=\"").append(slider.getMinLimit()).append("\" ");
            xml.append("max_limit=\"").append(slider.getMaxLimit()).append("\" ");
            xml.append("min_vis=\"").append(slider.getMinVisible()).append("\" ");
            xml.append("max_vis=\"").append(slider.getMaxVisible()).append("\" ");
            xml.append("resolution=\"").append(slider.getResolution()).append("\" ");
            xml.append("min_locked=\"").append(slider.isLocked(0)).append("\" ");
            xml.append("max_locked=\"").append(slider.isLocked(1)).append("\" ");
            xml.append("/>\n");
        }
        for (i = 0; i < this.graph_window.getXSliderCount(); ++i) {
            slider = this.graph_window.getXSlider(i);
            xml.append("  <xslider ");
            xml.append("title=\"").append(slider.getTitle()).append("\" ");
            xml.append("min_limit=\"").append(slider.getMinLimit()).append("\" ");
            xml.append("max_limit=\"").append(slider.getMaxLimit()).append("\" ");
            xml.append("min_vis=\"").append(slider.getMinVisible()).append("\" ");
            xml.append("max_vis=\"").append(slider.getMaxVisible()).append("\" ");
            xml.append("resolution=\"").append(slider.getResolution()).append("\" ");
            xml.append("min_locked=\"").append(slider.isLocked(0)).append("\" ");
            xml.append("max_locked=\"").append(slider.isLocked(1)).append("\" ");
            xml.append("following=\"").append(this.graph_window.getTimeSliderFollowing((TimeZoomSlider)slider)).append("\" ");
            xml.append("/>\n");
        }
        xml.append("</graph>\n");
        for (i = 0; i < this.agents.size(); ++i) {
            agent = (StatAgent)this.agents.get(i);
            this.generateConfig(xml, agent, 0);
        }
        xml.append("</smgconfig>\n");
        return xml.toString();
    }

    public String generateConfig(TRCAgent agent) {
        StringBuffer sb = new StringBuffer();
        StatAgent statagent = this.getStatAgent(agent);
        this.generateConfig(sb, statagent, 0);
        return sb.toString();
    }

    private void generateConfig(StringBuffer xml, StatAgent agent, int depth) {
        TreeItem agent_item = (TreeItem)this.reverse_map.get(agent.agent);
        if (agent_item == null) {
            return;
        }
        xml.append("<agent ");
        xml.append("name=\"").append(agent.agent.getName()).append("\" ");
        xml.append("ticked=\"").append(agent_item.getChecked()).append("\" ");
        xml.append("expanded=\"").append(agent_item.getExpanded()).append("\" ");
        xml.append(">\n");
        this.generateConfig(xml, agent.agent.getDefaultEvents(), depth + 1);
        for (int m = 0; m < agent.model_roots.size(); ++m) {
            SDDescriptor root = (SDDescriptor)agent.model_roots.get(m);
            this.generateConfig(xml, root, depth + 1);
        }
        xml.append("</agent>");
    }

    private void generateConfig(StringBuffer xml, EList events, int depth) {
        TreeItem msg_item = (TreeItem)this.reverse_map.get(events);
        if (msg_item != null) {
            xml.append("  <cbelog ");
            xml.append("ticked=\"").append(msg_item.getChecked()).append("\" ");
            xml.append("expanded=\"").append(msg_item.getExpanded()).append("\" ");
            xml.append(">\n");
            ArrayList<CBEComponentIdentification> locations = new ArrayList<CBEComponentIdentification>();
            for (int i = 0; i < events.size(); ++i) {
                CBECommonBaseEvent cbe = (CBECommonBaseEvent)events.get(i);
                CBEComponentIdentification source = cbe.getSourceComponentId();
                if (locations.contains(source)) continue;
                locations.add(source);
                TreeItem comp_item = (TreeItem)this.reverse_map.get(source);
                if (comp_item == null) continue;
                xml.append("    <component ");
                xml.append("componentIdType=\"").append(source.getComponentIdType()).append("\" ");
                xml.append("component=\"").append(source.getComponent()).append("\" ");
                xml.append("subcomponent=\"").append(source.getSubComponent()).append("\" ");
                xml.append("ticked=\"").append(comp_item.getChecked()).append("\" ");
                xml.append("expanded=\"").append(comp_item.getExpanded()).append("\" ");
                xml.append(" />\n");
            }
            xml.append("  </cbelog>\n");
        }
    }

    public String generateConfig(SDDescriptor model_root) {
        try {
            StringBuffer sb = new StringBuffer();
            EditorPlugin.DBG.info("generating StatCon configuration");
            this.generateConfig(sb, model_root, 0);
            return sb.toString();
        }
        catch (Throwable e) {
            EditorPlugin.DBG.error("problem generating StatCon configuration", e);
            return null;
        }
    }

    private void generateConfig(StringBuffer xml, SDDescriptor descriptor, int depth) {
        TreeItem rep_item;
        ZoomSlider slider;
        SDMemberDescriptor mem_descriptor;
        SDRepresentation rep;
        TreeItem sd_item = (TreeItem)this.reverse_map.get(descriptor);
        if (descriptor == null) {
            return;
        }
        if (sd_item == null) {
            return;
        }
        for (int t = 0; t < depth; ++t) {
            xml.append("  ");
        }
        xml.append("<descriptor ");
        xml.append("name=\"").append(descriptor.getName()).append("\" ");
        xml.append("ticked=\"").append(sd_item.getChecked()).append("\" ");
        xml.append("expanded=\"").append(sd_item.getExpanded()).append("\" ");
        xml.append(">\n");
        if (descriptor instanceof SDMemberDescriptor) {
            SDMemberDescriptor mem_descriptor2 = (SDMemberDescriptor)descriptor;
            EList observations = mem_descriptor2.getSnapshotObservation();
            for (int i = 0; i < observations.size(); ++i) {
                TreeItem obs_item;
                BasicGraphSource source;
                Graph graph;
                Object o = observations.get(i);
                if (!(o instanceof SDContiguousObservation) && !(o instanceof SDTextObservation) || (graph = (Graph)this.source_graph_map.get(source = (BasicGraphSource)this.source_map.get(obs_item = (TreeItem)this.reverse_map.get(o)))) == null) continue;
                for (int t = 0; t < depth; ++t) {
                    xml.append("  ");
                }
                xml.append("<obs_graph ");
                xml.append("ticked=\"").append(obs_item.getChecked()).append("\" ");
                xml.append("obs_index=\"").append(i).append("\" ");
                xml.append("x_slider=\"").append(this.graph_window.getXSlider(graph.getXSlider())).append("\" ");
                xml.append("y_slider=\"").append(this.graph_window.getYSlider(graph.getYSlider())).append("\" ");
                xml.append("color=\"").append(XMLConfigUtil.colorToString(graph.getForeground())).append("\" ");
                xml.append("line_width=\"").append(graph.getLineWidth()).append("\" ");
                xml.append("line_style=\"").append(XMLConfigUtil.lineStyleToString(graph.getLineStyle())).append("\" ");
                xml.append("multiplier=\"").append(graph.getStaticScaling()).append("\" ");
                xml.append("/>\n");
            }
        }
        if (descriptor instanceof SDMemberDescriptor && (rep = (mem_descriptor = (SDMemberDescriptor)descriptor).getRepresentation()) instanceof SDModifiableVariableRepresentation && (slider = (ZoomSlider)((Object)this.bar_slider_map.get(rep_item = (TreeItem)this.reverse_map.get(rep)))) != null) {
            for (int t = 0; t < depth; ++t) {
                xml.append("  ");
            }
            xml.append("<control ");
            xml.append("ticked=\"").append(rep_item.getChecked()).append("\" ");
            xml.append("y_slider=\"").append(this.graph_window.getYSlider(slider)).append("\" ");
            xml.append("/>\n");
        }
        EList list = descriptor.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            SDDescriptor child = (SDDescriptor)list.get(i);
            this.generateConfig(xml, child, depth + 1);
        }
        for (int t = 0; t < depth; ++t) {
            xml.append("  ");
        }
        xml.append("</descriptor>\n");
    }

    public GraphWindow getGraphWindow() {
        return this.graph_window;
    }

    public void setConstantUpdate(String request_id, boolean request_on, long ms_refresh) {
        Boolean val = new Boolean(request_on);
        this.updates.put(request_id, val);
        boolean on = false;
        Iterator requests = this.updates.values().iterator();
        while (requests.hasNext()) {
            Boolean b = (Boolean)requests.next();
            if (!b.booleanValue()) continue;
            on = true;
            break;
        }
        if (request_on) {
            this.graph_window.setConstantUpdate(on, ms_refresh);
        } else {
            this.graph_window.setConstantUpdate(on);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }

    public void dispose() {
        for (int i = 0; i < this.disposables.size(); ++i) {
            try {
                Object o = this.disposables.get(i);
                if (o == null) continue;
                if (o instanceof Widget) {
                    ((Widget)o).dispose();
                    continue;
                }
                if (o instanceof Color) {
                    ((Color)o).dispose();
                    continue;
                }
                if (o instanceof Image) {
                    ((Image)o).dispose();
                    continue;
                }
                try {
                    EditorPlugin.disposeObject(o);
                }
                catch (Throwable e) {
                    EditorPlugin.DBG.warning("dispose object failed ", e);
                }
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private void initAsSash(Composite parent) {
        this.sashfolder = new SashForm(parent, 0);
        this.sashfolder.setOrientation(256);
        WorkbenchHelp.setHelp((Control)parent, (String)(EditorPlugin.getDefault().getInfopopsId() + ".statcon_anywhere"));
        this.leftsash = new Group((Composite)this.sashfolder, 0);
        this.rightsash = new Composite((Composite)this.sashfolder, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.leftsash.setLayout((Layout)layout);
        this.rightsash.setLayout((Layout)new FillLayout());
        parent.addDisposeListener((DisposeListener)this);
        this.img = EditorPlugin.img;
        this.initChooser(this.leftsash);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.chooser_tree.setLayoutData((Object)data);
        this.initAggregateGraph(this.rightsash);
        this.sashfolder.setWeights(new int[]{30, 70});
        this.disposables.add(this.sashfolder);
        this.disposables.add(this.leftsash);
        this.disposables.add(this.rightsash);
    }

    private void initChooser(Composite parent) {
        this.chooser_tree = new Tree(parent, 32);
        WorkbenchHelp.setHelp((Control)parent, (String)(EditorPlugin.getDefault().getInfopopsId() + ".statcon_anywhere"));
        WorkbenchHelp.setHelp((Control)this.chooser_tree, (String)(EditorPlugin.getDefault().getInfopopsId() + ".statcon_anywhere"));
        this.disposables.add(this.chooser_tree);
        this.chooser_menu = new Menu((Control)this.chooser_tree);
        this.chooser_add = new MenuItem(this.chooser_menu, 0);
        this.chooser_add.setText(EditorPlugin.getString("ADD_NEW_TRACE"));
        this.chooser_add.setImage(this.img.getImage("smodel_trcagent.gif"));
        this.disposables.add(this.chooser_menu);
        this.disposables.add(this.chooser_add);
        this.chooser_tree.addMouseListener((MouseListener)this);
        this.chooser_add.addSelectionListener((SelectionListener)this);
        this.chooser_tree.addSelectionListener((SelectionListener)this);
        DropTarget target = new DropTarget((Control)this.chooser_tree, 7);
        target.addDropListener((DropTargetListener)this);
        Transfer[] types = new Transfer[]{ResourceTransfer.getInstance()};
        target.setTransfer(types);
        for (int i = 0; i < this.agents.size(); ++i) {
            StatAgent agent = (StatAgent)this.agents.get(i);
            for (int m = 0; m < agent.model_roots.size(); ++m) {
                SDDescriptor sdroot = (SDDescriptor)agent.model_roots.get(m);
                this.addModelToChooser(sdroot, agent.agent, false);
            }
        }
        this.updateAgentImages();
    }

    private void addModelToChooser(SDDescriptor sd, TRCAgent agent, boolean update) {
        TreeItem agent_item = (TreeItem)this.reverse_map.get(agent);
        this.addModelToChooser(sd, agent_item, update);
    }

    private void updateTreeItems() {
        TreeItem[] items = this.chooser_tree.getItems();
        for (int i = 0; i < items.length; ++i) {
            this.treeItemSelected(items[i]);
        }
    }

    private String getTreeName(SDDescriptor sd) {
        String basicname = null;
        basicname = sd.getDescription() != null ? sd.getName() + " (" + sd.getDescription() + ")" : sd.getName();
        if (basicname == null) {
            basicname = "";
        }
        if (basicname.length() == 0) {
            basicname = "(unknown)";
        }
        return basicname;
    }

    private void addObservations(SDDescriptor sd, TreeItem item, boolean update) {
        SDMemberDescriptor sdmem;
        EList obs = null;
        Image obs_image = null;
        if (sd instanceof SDMemberDescriptor && (obs = (sdmem = (SDMemberDescriptor)sd).getSnapshotObservation()) != null) {
            if (obs.size() > 0) {
                obs_image = this.img.getImage("smodel_counter.gif");
            } else {
                obs = null;
            }
        }
        if (obs != null) {
            for (int i = 0; i < obs.size(); ++i) {
                SDSnapshotObservation o = (SDSnapshotObservation)obs.get(i);
                if (!(o instanceof SDContiguousObservation) && !(o instanceof SDDiscreteObservation) && !(o instanceof SDTextObservation)) continue;
                TreeItem obs_item = (TreeItem)this.reverse_map.get(o);
                if (update && obs_item != null) continue;
                obs_item = new TreeItem(item, 0, 0);
                obs_item.setText(sd.getName() + " (" + EditorPlugin.getString("GRAPH") + " " + (i + 1) + ")");
                obs_item.setImage(obs_image);
                obs_item.setGrayed(false);
                obs_item.setChecked(true);
                this.counter_map.put(obs_item, o);
                this.reverse_map.put(o, obs_item);
                this.sddescriptor_map.put(obs_item, sd);
            }
        }
    }

    private void addRepresentation(SDDescriptor sd, TreeItem item, boolean update) {
        SDMemberDescriptor sdmem;
        SDRepresentation reptmp;
        SDModifiableVariableRepresentation rep = null;
        Image rep_image = null;
        if (sd instanceof SDMemberDescriptor && (reptmp = (sdmem = (SDMemberDescriptor)sd).getRepresentation()) instanceof SDModifiableVariableRepresentation) {
            rep = (SDModifiableVariableRepresentation)reptmp;
            rep_image = rep.getImage();
        }
        if (rep != null) {
            TreeItem rep_item = (TreeItem)this.reverse_map.get(rep);
            if (!update || rep_item == null) {
                rep_item = new TreeItem(item, 0, 0);
                rep_item.setText(sd.getName() + " (" + EditorPlugin.getString("CONTROL") + ")");
                rep_item.setImage(rep_image);
                if (rep_image == null) {
                    rep_item.setImage(this.img.getImage("smodel_modifiablerep.gif"));
                }
                rep_item.setGrayed(false);
                rep_item.setChecked(true);
                this.modifiable_map.put(rep_item, rep);
                this.reverse_map.put(rep, rep_item);
                this.sddescriptor_map.put(rep_item, sd);
            }
        }
    }

    private void addModelToChooser(SDDescriptor sd, TreeItem parent_item, boolean update) {
        if (sd == null) {
            return;
        }
        TreeItem item = (TreeItem)this.reverse_map.get(sd);
        if (update && item != null) {
            String tmp = this.getTreeName(sd);
            if (!tmp.equals(item.getText())) {
                item.setText(tmp);
            }
        } else {
            item = parent_item == null ? new TreeItem(this.chooser_tree, 0) : new TreeItem(parent_item, 0);
            item.setText(this.getTreeName(sd));
            item.setImage(this.img.getImage("smodel_descriptor2.gif"));
            item.setChecked(true);
            item.setGrayed(false);
            this.reverse_map.put(sd, item);
            this.sddescriptor_map.put(item, sd);
        }
        this.addObservations(sd, item, update);
        this.addRepresentation(sd, item, update);
        EList children = sd.getChildren();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            SDDescriptor csd = (SDDescriptor)children.get(i);
            this.addModelToChooser(csd, item, update);
        }
    }

    public void initAggregateGraph(Composite parent) {
        this.graph_window = new GraphWindow(parent, 0, this.dirtiable);
        this.graph_window.addUpdateRunnable(new CBEUpdate());
        this.disposables.add(this.graph_window);
    }

    public Control initTestGraph(Composite parent) {
        Color black = parent.getShell().getDisplay().getSystemColor(2);
        Color cyan = parent.getShell().getDisplay().getSystemColor(13);
        Color magenta = parent.getShell().getDisplay().getSystemColor(11);
        GraphWindow window = new GraphWindow(parent, 0);
        this.disposables.add(window);
        window.addXSlider();
        window.addYSlider();
        TestGraphSource sine_source = new TestGraphSource(-1000000.0, 1000000.0, 0);
        LineGraph sine_line = new LineGraph(1, sine_source, window.getXSlider(0), window.getYSlider(0), cyan);
        sine_line.setLineWidth(2);
        TestGraphSource cosine_source = new TestGraphSource(-1000000.0, 1000000.0, 1);
        HistogramGraph cosine_line = new HistogramGraph(cosine_source, window.getXSlider(1), window.getYSlider(1), magenta);
        cosine_line.setLineWidth(2);
        this.graph_window.addGraph("Test Sine", "A test sine wave graph", sine_line, null);
        this.graph_window.addGraph("Test Cosine", "A test cosine wave graph", cosine_line, null);
        return window;
    }

    public SDDescriptor getSelectedDescriptor() {
        return this.selected_descriptor;
    }

    public void setDescriptorImage(SDDescriptor descriptor, Image image) {
        TreeItem item = (TreeItem)this.reverse_map.get(descriptor);
        if (item == null) {
            return;
        }
        item.setImage(image);
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragLeave(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dropAccept(DropTargetEvent event) {
        event.detail = 1;
    }

    public void drop(DropTargetEvent event) {
        event.detail = 1;
        if (event.data == null) {
            event.detail = 0;
            return;
        }
        StringBuffer errors = new StringBuffer();
        try {
            IResource[] resources = (IResource[])event.data;
            for (int i = 0; i < resources.length; ++i) {
                String path = resources[i].getFullPath().toString();
                String extension = path.substring(path.lastIndexOf(".") + 1);
                EditorPlugin.DBG.info("got dragged resource " + path);
                if (extension.equalsIgnoreCase("trcmxmi") || extension.equalsIgnoreCase("trcnxmi") || extension.equalsIgnoreCase("trcpxmi") || extension.equalsIgnoreCase("trcaxmi")) {
                    try {
                        this.addAgent(resources[i].getFullPath());
                        this.setDirty(true);
                    }
                    catch (Throwable e) {
                        errors.append(EditorPlugin.getString("INVALID_TRACE_FILE") + ":" + resources[i].getFullPath() + "\n");
                        EditorPlugin.DBG.warning("bad trace/model file drop ", e);
                    }
                    continue;
                }
                try {
                    boolean accepted = false;
                    for (int k = 0; k < this.drop_listeners.size(); ++k) {
                        DropListener drop = (DropListener)this.drop_listeners.get(k);
                        if (!drop.extension.equalsIgnoreCase(extension) || !drop.listener.drop(this, resources[i])) continue;
                        accepted = true;
                    }
                    if (accepted) continue;
                    event.detail = 0;
                    throw new Exception(EditorPlugin.getString("NO_MODULE_ACCEPTED_DROP"));
                }
                catch (Throwable e) {
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = "";
                    }
                    if (msg.length() > 0) {
                        errors.append(EditorPlugin.getString("INVALID_FILE") + ":" + resources[i].getFullPath() + " (" + e.getMessage() + ")\n");
                    } else {
                        errors.append(EditorPlugin.getString("INVALID_FILE") + ":" + resources[i].getFullPath() + " (no further information)\n");
                    }
                    EditorPlugin.DBG.warning("bad module file drop " + resources[i].getFullPath(), e);
                }
            }
        }
        catch (Throwable e) {
            errors.append(EditorPlugin.getString("INVALID_FILE_DROP") + ":" + e + "\n");
            EditorPlugin.DBG.error("bad file drop", e);
            event.detail = 0;
            return;
        }
        if (errors.length() > 0) {
            MessageBox mbox = new MessageBox(this.graph_window.getShell(), 40);
            mbox.setText(EditorPlugin.getString("INVALID_FILE_DROP_TITLE"));
            mbox.setMessage(errors.toString());
            mbox.open();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        BasicAction action;
        Object node;
        int k;
        Point pt = new Point(e.x, e.y);
        TreeItem item = this.chooser_tree.getItem(pt);
        boolean toplevel = false;
        ArrayList subactions = new ArrayList();
        if (item != null) {
            TRCAgent trcagent = (TRCAgent)this.trcagent_map.get(item);
            StatAgent agent = this.getStatAgent(trcagent);
            if (agent != null) {
                subactions = agent.actions;
            } else {
                for (k = 0; k < this.root_nodes.size(); ++k) {
                    node = (RootNode)this.root_nodes.get(k);
                    if (((RootNode)node).item != item) continue;
                    subactions = ((RootNode)node).actions;
                    toplevel = true;
                }
            }
        }
        ArrayList<BasicAction> slideractions = new ArrayList<BasicAction>();
        if (item != null && !toplevel) {
            int i;
            for (i = 0; i < this.graph_window.getYSliderCount(); ++i) {
                ZoomSlider slider = this.graph_window.getYSlider(i);
                action = new BasicAction();
                action.name = EditorPlugin.getString("SET_ALL_VERTICAL_TO") + " " + slider.getTitle();
                action.image = this.img.getImage("slider_v.gif");
                action.runnable = new SetSliderAction(false, slider, item);
                slideractions.add(action);
            }
            for (i = 0; i < this.graph_window.getXSliderCount(); ++i) {
                TimeZoomSlider slider = this.graph_window.getXSlider(i);
                action = new BasicAction();
                action.name = EditorPlugin.getString("SET_ALL_HORIZONTAL_TO") + " " + slider.getTitle();
                action.image = this.img.getImage("slider_h.gif");
                action.runnable = new SetSliderAction(true, slider, item);
                slideractions.add(action);
            }
        }
        if (item != null) {
            SDDescriptor descriptor;
            this.selected_descriptor = descriptor = (SDDescriptor)this.sddescriptor_map.get(item);
            if (descriptor != null) {
                while (descriptor.getParent() != null) {
                    descriptor = descriptor.getParent();
                }
                for (int z = 0; z < this.agents.size(); ++z) {
                    node = (StatAgent)this.agents.get(z);
                    if (!((StatAgent)node).model_roots.contains(descriptor)) continue;
                    subactions.addAll(((StatAgent)node).modelactions);
                    break;
                }
            }
        }
        if (this.chooser_disposables != null) {
            for (int i = 0; i < this.chooser_disposables.size(); ++i) {
                MenuItem mitem = (MenuItem)this.chooser_disposables.get(i);
                mitem.dispose();
            }
        }
        this.chooser_disposables = new ArrayList();
        if (subactions.size() > 0) {
            MenuItem sep = new MenuItem(this.chooser_menu, 2);
            this.chooser_disposables.add(sep);
            for (k = 0; k < subactions.size(); ++k) {
                action = (BasicAction)subactions.get(k);
                action.menuitem = new MenuItem(this.chooser_menu, 0);
                action.menuitem.setText(action.name);
                action.menuitem.setImage(action.image);
                action.menuitem.addSelectionListener((SelectionListener)action);
                this.chooser_disposables.add(action.menuitem);
            }
        }
        if (slideractions.size() > 0) {
            MenuItem sep = new MenuItem(this.chooser_menu, 2);
            this.chooser_disposables.add(sep);
            for (k = 0; k < slideractions.size(); ++k) {
                action = (BasicAction)slideractions.get(k);
                action.menuitem = new MenuItem(this.chooser_menu, 0);
                action.menuitem.setText(action.name);
                action.menuitem.setImage(action.image);
                action.menuitem.addSelectionListener((SelectionListener)action);
                this.chooser_disposables.add(action.menuitem);
            }
        }
        if (e.button > 1) {
            this.chooser_menu.setVisible(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        this.widgetSelected(e.item, o);
    }

    public void widgetSelected(Widget widget, Object o) {
        if (o == this.chooser_tree) {
            if (widget == null) {
                return;
            }
            if (widget instanceof TreeItem) {
                TreeItem item = (TreeItem)widget;
                boolean checked = item.getChecked();
                this.treeItemSelected(item);
            }
        } else if (o == this.chooser_add) {
            EditorPlugin.DBG.info("add agent file - opening ResourceSelectionDialog");
            ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.graph_window.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "Please choose one or more statistical models");
            dialog.open();
            Object[] results = dialog.getResult();
            if (results != null) {
                for (int i = 0; i < results.length; ++i) {
                    EditorPlugin.DBG.info("" + results[i].getClass());
                    if (!(results[i] instanceof IFile)) continue;
                    try {
                        IFile file = (IFile)results[i];
                        EditorPlugin.DBG.info("trying to add " + file);
                        this.addAgent(file.getFullPath());
                        this.setDirty(true);
                        this.chooser_tree.redraw();
                        continue;
                    }
                    catch (Throwable x) {
                        EditorPlugin.DBG.error("model add failed", x);
                    }
                }
            }
        }
    }

    public void removeAgent(TRCAgent agent) {
        StatAgent statagent = this.getStatAgent(agent);
        this.agents.remove(statagent);
        if (statagent == null) {
            return;
        }
        for (int i = 0; i < this.agent_change_listeners.size(); ++i) {
            AgentChangeListener listener = (AgentChangeListener)this.agent_change_listeners.get(i);
            listener.agentRemoved(agent);
        }
        for (int m = 0; m < statagent.model_roots.size(); ++m) {
            SDDescriptor model_root = (SDDescriptor)statagent.model_roots.get(m);
            for (int i = 0; i < this.model_change_listeners.size(); ++i) {
                ModelChangeListener listener = (ModelChangeListener)this.model_change_listeners.get(i);
                listener.modelRemoved(model_root);
            }
        }
        TreeItem item = (TreeItem)this.reverse_map.get(agent);
        this.removeTreeItemRef(item);
        this.graph_window.updateTables();
        if (item != null) {
            item.dispose();
            this.disposables.remove(item);
        }
        this.setDirty(true);
        EditorPlugin.DBG.info("Reverse Map Items = " + this.reverse_map.values().size());
        EditorPlugin.DBG.info("SDDescriptor Map Items = " + this.sddescriptor_map.values().size());
        EditorPlugin.DBG.info("Counter Map Items = " + this.counter_map.values().size());
        EditorPlugin.DBG.info("Modifiable Map Items = " + this.modifiable_map.values().size());
        EditorPlugin.DBG.info("Graph Map Items = " + this.graph_map.values().size());
        EditorPlugin.DBG.info("Bar Map Items = " + this.bar_map.values().size());
        EditorPlugin.DBG.info("Bar Slider Map Items = " + this.bar_slider_map.values().size());
        EditorPlugin.DBG.info("Source Map Items = " + this.source_map.values().size());
        EditorPlugin.DBG.info("Source Graph Map Items = " + this.source_graph_map.values().size());
        EditorPlugin.DBG.info("Disposables Items = " + this.disposables.size());
        EditorPlugin.DBG.info("Model Items = " + this.agents.size());
        Runtime r = Runtime.getRuntime();
        r.gc();
        long used = r.totalMemory() - r.freeMemory();
        EditorPlugin.DBG.info("USED MEMORY = " + used / 1024L + "k (+" + (used - this.prev_used) + ")");
        this.prev_used = used;
    }

    private void removeTreeItemRef(TreeItem item) {
        if (item == null) {
            return;
        }
        Object agent = this.trcagent_map.remove(item);
        TreeItem trcagent_item = (TreeItem)this.reverse_map.remove(agent);
        Object descriptor = this.sddescriptor_map.remove(item);
        TreeItem descriptor_item = (TreeItem)this.reverse_map.remove(descriptor);
        TreeItem rep_item = null;
        TreeItem obs_item = null;
        if (descriptor instanceof SDMemberDescriptor) {
            SDMemberDescriptor mem_descriptor = (SDMemberDescriptor)descriptor;
            SDRepresentation rep = mem_descriptor.getRepresentation();
            rep_item = (TreeItem)this.reverse_map.remove(rep);
            SDModifiableVariableRepresentation rep_mod = (SDModifiableVariableRepresentation)this.modifiable_map.remove(rep_item);
            try {
                if (rep_mod != null) {
                    this.graph_window.removeControl(rep_mod);
                }
            }
            catch (Throwable e) {
                EditorPlugin.DBG.error("problem removing control from graph window", e);
            }
            ZoomSlider rep_slider = (ZoomSlider)((Object)this.bar_slider_map.remove(rep_item));
            ModifiableVariableBar bar = (ModifiableVariableBar)this.bar_map.remove(rep_item);
            if (bar != null) {
                try {
                    if (bar.bar.getZoomSlider() != null) {
                        bar.bar.getZoomSlider().removeZoomControlBar(bar.bar);
                        bar.bar.dispose();
                        this.disposables.remove(bar.bar);
                    }
                }
                catch (NullPointerException e) {
                    EditorPlugin.DBG.warning("bar zoomslider not found", e);
                }
            }
            EList obs_list = mem_descriptor.getSnapshotObservation();
            for (int i = 0; i < obs_list.size(); ++i) {
                Object obs = obs_list.get(i);
                obs_item = (TreeItem)this.reverse_map.remove(obs);
                SDSnapshotObservation obs_obs = (SDSnapshotObservation)this.counter_map.remove(obs_item);
                Graph obs_graph = (Graph)this.graph_map.remove(obs_item);
                try {
                    if (obs_graph != null) {
                        obs_graph.setUseIndicator(false);
                        this.graph_window.removeGraph(obs_graph);
                    }
                }
                catch (Throwable e) {
                    EditorPlugin.DBG.error("problem removing graph from graph window", e);
                }
                BasicGraphSource source = (BasicGraphSource)this.source_map.remove(obs_item);
                if (source == null) continue;
                this.source_graph_map.remove(source);
            }
        }
        TreeItem[] children = item.getItems();
        for (int i = 0; i < children.length; ++i) {
            this.removeTreeItemRef(children[i]);
        }
        item.dispose();
        if (rep_item != null) {
            rep_item.dispose();
        }
        if (obs_item != null) {
            obs_item.dispose();
        }
    }

    public void treeItemSelected(TreeItem item) {
        try {
            boolean parents_all_checked = true;
            for (TreeItem parent = item.getParentItem(); parent != null; parent = parent.getParentItem()) {
                if (parent.getChecked()) continue;
                parents_all_checked = false;
                break;
            }
            if (item.getParentItem() == null) {
                boolean b = item.getGrayed();
                this.treeItemSelected(item, parents_all_checked);
                item.setGrayed(b);
            } else {
                this.treeItemSelected(item, parents_all_checked);
            }
            this.graph_window.redraw();
        }
        catch (Throwable t) {
            EditorPlugin.DBG.logVisibleError(t, EditorPlugin.getString("ERROR_UPDATE_STATCONTREE"), false);
        }
    }

    public void treeItemSelected(TreeItem item, boolean parents_all_checked) {
        SDSnapshotObservation obs;
        boolean checked = item.getChecked();
        if (!parents_all_checked) {
            checked = false;
            if (!item.getGrayed()) {
                this.setDirty(true);
            }
            item.setGrayed(true);
        } else {
            if (item.getGrayed()) {
                this.setDirty(true);
            }
            item.setGrayed(false);
        }
        EList events = (EList)this.msglist_map.get(item);
        if (events != null) {
            StatAgent agent = this.getStatAgent(events);
            if (checked && !agent.show_messages) {
                agent.show_messages = true;
                this.redoAllCBEs();
                this.setDirty(true);
            } else if (!checked && agent.show_messages) {
                agent.show_messages = false;
                this.redoAllCBEs();
                this.setDirty(true);
            }
        }
        if ((obs = (SDSnapshotObservation)this.counter_map.get(item)) != null) {
            Graph graph = (Graph)this.graph_map.get(item);
            BasicGraphSource source = (BasicGraphSource)this.source_map.get(item);
            if (source == null) {
                if (obs instanceof SDContiguousObservation) {
                    source = new SDSnapshotObservationGraphSource((SDContiguousObservation)obs);
                } else if (obs instanceof SDDiscreteObservation) {
                    source = new SDSnapshotObservationGraphSource((SDDiscreteObservation)obs);
                } else if (obs instanceof SDTextObservation) {
                    source = new SDTextObservationGraphSource((SDTextObservation)obs);
                } else {
                    EditorPlugin.DBG.info("SnapshotObservation neither Contiguous nor Discrete!");
                    return;
                }
                this.source_map.put(item, source);
            }
            if (graph == null && checked) {
                this.setDirty(true);
                graph = (Graph)this.source_graph_map.get(source);
                if (graph == null) {
                    Color col = item.getDisplay().getSystemColor(this.colours[this.next++]);
                    if (this.next >= this.colours.length) {
                        this.next = 0;
                    }
                    if (source instanceof GraphSource) {
                        graph = new LineGraph(1, (SDSnapshotObservationGraphSource)source, this.graph_window.getXSlider(0), this.graph_window.getYSlider(0), col);
                    } else if (source instanceof EnumerationGraphSource) {
                        graph = new EnumerationGraph(this.graph_window.getXSlider(0), this.graph_window.getYSlider(0), col, (SDTextObservationGraphSource)source);
                    }
                    this.source_graph_map.put(source, graph);
                }
                if (graph.getXSlider().isDisposed()) {
                    graph.setXSlider(this.graph_window.getXSlider(0));
                }
                if (graph.getYSlider().isDisposed()) {
                    graph.setYSlider(this.graph_window.getYSlider(0));
                }
                SDDescriptor sd = (SDDescriptor)this.sddescriptor_map.get(item);
                graph.setUseIndicator(true);
                this.graph_window.addGraph(item.getText(), sd.getDescription(), graph, sd);
            } else if (graph != null && !checked) {
                this.setDirty(true);
                graph.setUseIndicator(false);
                this.graph_window.removeGraph(graph);
            }
            if (checked) {
                this.graph_map.put(item, graph);
            } else {
                this.graph_map.remove(item);
            }
            return;
        }
        SDModifiableVariableRepresentation rep = (SDModifiableVariableRepresentation)this.modifiable_map.get(item);
        if (rep != null) {
            ModifiableVariableBar mbar = (ModifiableVariableBar)this.bar_map.get(item);
            if (mbar == null && checked) {
                this.setDirty(true);
                ZoomSlider slider = (ZoomSlider)((Object)this.bar_slider_map.get(item));
                if (slider == null) {
                    slider = this.graph_window.getYSlider(0);
                }
                if (slider.isDisposed()) {
                    slider = this.graph_window.getYSlider(0);
                }
                Image enabled = rep.getImage();
                ZoomImageBar varbar = null;
                if (rep.getModifierType() != 4 && enabled != null && rep.hasBar()) {
                    varbar = new ZoomImageBar(slider, ((Number)rep.getLastRequestedValue()).doubleValue(), enabled, enabled, enabled.getBounds().height + 6);
                    varbar.setToolTipText(item.getText());
                    mbar = new ModifiableVariableBar(this, varbar, rep, this.dirtiable);
                    varbar.addZoomControlBarListener(mbar);
                } else {
                    mbar = new ModifiableVariableBar(this, varbar, rep, this.dirtiable);
                }
                SDDescriptor sd = (SDDescriptor)this.sddescriptor_map.get(item);
                this.graph_window.addControl(item.getText(), sd.getDescription(), enabled, varbar, rep);
                if (varbar != null) {
                    this.disposables.add(varbar);
                }
                if (rep.getModifierType() != 4 && enabled != null && rep.hasBar()) {
                    mbar.bar.getZoomSlider().addZoomControlBar(mbar.bar);
                }
            } else if (mbar != null && !checked) {
                this.setDirty(true);
                ZoomControlBar zbar = mbar.bar;
                try {
                    this.bar_slider_map.put(item, zbar.getZoomSlider());
                    zbar.dispose();
                    zbar.getZoomSlider().removeZoomControlBar(zbar);
                    this.disposables.remove(zbar);
                }
                catch (Throwable x) {
                    // empty catch block
                }
                this.graph_window.removeControl(rep);
            }
            if (checked) {
                this.bar_map.put(item, mbar);
            } else {
                this.bar_map.remove(item);
            }
            return;
        }
        TreeItem[] children = item.getItems();
        for (int i = 0; i < children.length; ++i) {
            this.treeItemSelected(children[i], checked);
        }
    }

    private void setTreeItemSlider(TreeItem item, boolean horizontal, ZoomSlider slider) {
        Graph obs_graph;
        ModifiableVariableBar bar = this.getVariableBar(item);
        if (!horizontal) {
            this.bar_slider_map.put(item, slider);
            try {
                if (bar.bar.getZoomSlider() != null) {
                    bar.bar.getZoomSlider().removeZoomControlBar(bar.bar);
                    bar.bar.setZoomSlider(slider);
                    bar.bar.getZoomSlider().addZoomControlBar(bar.bar);
                }
            }
            catch (NullPointerException e) {
                EditorPlugin.DBG.warning("bar zoomslider not found", e);
            }
        }
        if ((obs_graph = this.getGraph(item)) != null) {
            if (horizontal) {
                obs_graph.setXSlider((TimeZoomSlider)slider);
            } else {
                obs_graph.setYSlider(slider);
            }
        }
        TreeItem[] children = item.getItems();
        for (int i = 0; i < children.length; ++i) {
            this.setTreeItemSlider(children[i], horizontal, slider);
        }
    }

    private SDDescriptor getDescriptor(TreeItem item) {
        SDDescriptor descriptor = (SDDescriptor)this.sddescriptor_map.get(item);
        return descriptor;
    }

    private SDMemberDescriptor getMemberDescriptor(TreeItem item) {
        SDDescriptor descriptor = (SDDescriptor)this.sddescriptor_map.get(item);
        if (descriptor instanceof SDMemberDescriptor) {
            return (SDMemberDescriptor)descriptor;
        }
        return null;
    }

    private SDModifiableVariableRepresentation getRepresentation(TreeItem item) {
        SDModifiableVariableRepresentation rep = (SDModifiableVariableRepresentation)this.modifiable_map.get(item);
        return rep;
    }

    private ModifiableVariableBar getVariableBar(TreeItem item) {
        ModifiableVariableBar bar = (ModifiableVariableBar)this.bar_map.get(item);
        return bar;
    }

    private SDSnapshotObservation getObservation(TreeItem item) {
        SDSnapshotObservation obs = (SDSnapshotObservation)this.counter_map.get(item);
        return obs;
    }

    private BasicGraphSource getGraphSource(TreeItem item) {
        BasicGraphSource obs_source = (BasicGraphSource)this.source_map.get(item);
        return obs_source;
    }

    private Graph getGraph(TreeItem item) {
        BasicGraphSource source = this.getGraphSource(item);
        if (source == null) {
            return null;
        }
        Graph obs_graph = (Graph)this.source_graph_map.get(source);
        return obs_graph;
    }

    class StatAgent {
        TRCAgent agent = null;
        Image image = null;
        ArrayList actions = new ArrayList();
        ArrayList modelactions = new ArrayList();
        ArrayList model_roots = new ArrayList();
        URI uri;
        int msgindex = 0;
        boolean show_messages = true;

        StatAgent() {
        }
    }

    class RootNode {
        String name;
        Image image;
        ArrayList actions = new ArrayList();
        TreeItem item;
        String id;
        String parent_id;
        ArrayList node_children = new ArrayList();

        RootNode() {
        }

        public void dispose() {
            this.item.dispose();
        }
    }

    class CBEUpdate
    implements Runnable {
        CBEUpdate() {
        }

        public void run() {
            StatisticalModelGraphViewer.this.appendAllCBEs();
        }
    }

    class CBEComparator
    implements Comparator {
        CBEComparator() {
        }

        public int compare(Object o1, Object o2) {
            CBECommonBaseEvent e1 = (CBECommonBaseEvent)o1;
            CBECommonBaseEvent e2 = (CBECommonBaseEvent)o2;
            return (int)(e1.getCreationTime() - e2.getCreationTime());
        }
    }

    class SetSliderAction
    implements Runnable {
        boolean horizontal;
        ZoomSlider slider;
        TreeItem item;

        public SetSliderAction(boolean horizontal, ZoomSlider slider, TreeItem item) {
            this.horizontal = horizontal;
            this.slider = slider;
            this.item = item;
        }

        public void run() {
            StatisticalModelGraphViewer.this.setTreeItemSlider(this.item, this.horizontal, this.slider);
            StatisticalModelGraphViewer.this.graph_window.redraw();
            StatisticalModelGraphViewer.this.graph_window.updateTables();
        }
    }

    class BasicAction
    implements SelectionListener {
        String id = "unknown";
        String name;
        Runnable runnable;
        MenuItem menuitem;
        Image image;

        BasicAction() {
        }

        public void dispose() {
            if (this.menuitem != null) {
                this.menuitem.dispose();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.runnable.run();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.runnable.run();
        }
    }

    class DropListener {
        String extension;
        StatConDropListener listener;

        DropListener() {
        }
    }

    abstract class TreeAction {
        TreeAction() {
        }

        public abstract void run(TreeItem var1);
    }

    class AgentRemoveAction
    implements Runnable {
        TRCAgent ragent;

        public AgentRemoveAction(TRCAgent ragent) {
            this.ragent = ragent;
        }

        public void run() {
            StatisticalModelGraphViewer.this.removeAgent(this.ragent);
            StatisticalModelGraphViewer.this.redoAllCBEs();
        }
    }
}

