/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.reports.hitrate;

import org.eclipse.hyades.test.http.internal.reports.IReportGraphDataProvider;

/**
 * @author amathur
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class HitRateData implements IReportGraphDataProvider 
{
	private static int counter = 1;
	String id = null;
	long count = 0;
	long numberHits=0;
	long elapsedTime=0;	
	static long elapsedTimeForTest=0;
	static long totalNumberHits = 0;

	/**
	 * 
	 */
	public HitRateData(String id) 
	{
		this.id = id;
				
	}
	
	public void addHit(long time)
	{
		numberHits++;
		totalNumberHits++;
		this.elapsedTime+=time;
		elapsedTimeForTest+=time;
	}

	/**
	 * @return
	 */
	public static int getNextCounter() {
		return ++counter;
	}

	/**
	 * @return
	 */
	public static void resetCounter() {
		counter = 1;
		totalNumberHits = 0;
		elapsedTimeForTest = 0;
	}
	/**
	 * @return
	 */
	public String getId() {
		return id;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.http.internal.reports.IReportGraphDataProvider#getValue()
	 */
	public String getValue()
	{		
		double noHits = new Double(numberHits).doubleValue();
		double cumulativeTime = new Double(elapsedTimeForTest).doubleValue();
		double translator = 1000.000;
		double retVal = noHits/(cumulativeTime/translator);
		
		return new Double(retVal).toString(); 
	}

	

	/**
	 * @param l
	 */
	public static void setTestElapsedTime(long testElapsedTime)
	{
		elapsedTimeForTest = testElapsedTime;
	}

	public static String getOverallHitRate()
	{
		return new Double(totalNumberHits/new Double(elapsedTimeForTest/1000.00).doubleValue()).toString();
	}

	static class OverallHitRate implements IReportGraphDataProvider
	{
	
		
		public String getId()
		{
		
			return "Overall Hit Rate";
		}

		
		public String getValue()
		{
		
			return HitRateData.getOverallHitRate();
		}

	}
}
