/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.load;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.ui.IWorkbenchPage;

/**
 * Only one loader provides the UML2 Sequence Diagram widget with a frame at one moment.
 * This class ensures this.
 */
public class LoadersManager {

	private static IUml2SDLoader currentLoader;
	private static LoadersManager loadersManager;
	
	/**
	 * Unaccessible default constructor
	 */
	private LoadersManager() {
	}
	
	/**
	 * A static method to get the manager instance
	 * @return the manager instance
	 */
	public static LoadersManager getLoadersManager() {
		if (loadersManager == null) {
			loadersManager = new LoadersManager();
		}
		return loadersManager;
	}
	
	/**
	 * Creates a loader instance
	 * @param className the name of the class to create an instance from
	 * @param cl the class loader convenient for this class (same plugin class loader)
	 * @param view the UML2 Sequence Diagram view instance
	 */
	public IUml2SDLoader createLoader(String className, ClassLoader cl, SDView view) {
		IUml2SDLoader loader = null;
		if (cl == null) {
			cl = getClass().getClassLoader();
		}
		try {
			Class clazz = cl.loadClass(className);
			loader = (IUml2SDLoader)clazz.newInstance();
		} catch(ClassNotFoundException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		}
		setCurrentLoader(loader);
		if (loader != null) {
			loader.setViewer(view);
		}
		return loader;
	}

	/**
	 * Changes the current unique loader
	 * @param loader the loader to become the one
	 */
	public void setCurrentLoader(IUml2SDLoader loader) {
		if (currentLoader != null) {
			if (loader != null) {
				IWorkbenchPage persp =UIPlugin.getActivePage();
				SDView view = (SDView) persp.findView("org.eclipse.hyades.uml2sd.ui.view.SDView"); //$NON-NLS-1$
				if (view != null) {
					view.resetProviders();
				}
			}
			currentLoader.aboutToBeReplaced();
		}
		currentLoader = loader;
		if (currentLoader != null) {
			SDViewerPlugin.getDefault().setLastLoader(currentLoader.getClass().getName());
		}
	}

	/**
	 * Get the instance of the loader that is currently the one
	 */
	public IUml2SDLoader getCurrentLoader() {
		if (currentLoader == null) {
			SDViewerPlugin.getDefault().createLastLoaderIfAny();
		}
		return currentLoader;
	}

}
