package org.eclipse.hyades.trace.views.internal;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

// QuantitativeClassification:  Abstract class representing a classification
//                              of quantitative data values into buckets.
//
//       A i-th bucket is an interval b(i) <= dataValue < b(i+1), i = 0 .. n-1
//       Anything < b(0) is classified into the NULL_BUCKET.
//
public abstract class QuantitativeClassification
	extends Classification
{
	// --- Internal representation ---
	protected int  _numBuckets = 0;
	// Quantitative classifications have a caller-settable range of data being
	// classified into buckets.  This may not make sense for all of the
	// quantitative schemes, but it's probably useful for most of them.
	// These are identifying the values for the lowest and highest buckets.
	// Eventually we should also have a way to reverse low/high interpretation.
	protected long _rangeLow;  // Low end of range of data being classified.
							   // Anything < this value is considered null.
	protected long _rangeHigh; // High end of range of data being classified.

							   // Anything >= this value is classified in
							   // top bucket.
	// --- Public methods ---
	public abstract int bucket(long value);
	public int numBuckets() {
		return _numBuckets;
	}
	public long rangeHigh() {
		return _rangeHigh;
	}
	public long rangeLow() {
		return _rangeLow;
	}
	public void setNumBuckets(int n) {
		_numBuckets = n;
	}
	public void setRange(long low, long high) {
		_rangeLow  = low;
		_rangeHigh = high;
		}
}
