/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.trace.TraceUtils.InvocationInfo;
import org.eclipse.hyades.loaders.trace.TraceUtils.InvocationPool;
import org.eclipse.hyades.models.hierarchy.util.FastList;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCInputOutputContainer;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectValue;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TraceFactory;
/**
 * @author slavescu
 */
public class TraceMethodBaseLoader extends TraceXMLFragmentLoader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------
	protected static final String TICKET = "ticket";
	protected static final String STACK_DEPTH = "stackDepth";
	protected static final String PARAMETER = "parameter";
	protected static final String RETURN_VALUE = "returnValue";
	protected static final String VALUE = "value";
	//~ Instance fields
	// ----------------------------------------------------------------------------
	protected CallStackPerThread cs;
	protected InvocationPool invocationPool;
	protected TRCClass invokerClass;
	protected TRCClass invokerObjectClass;
	protected TRCFullMethodInvocation fullInvocation;
	protected TRCFullMethodInvocation fullInvoker;
	protected TRCFullTraceObject invokerObject;
	protected TRCMethod invokerMethod;
	protected double deltaBaseTime;
	protected double lastChildExitTime;
	protected double previousSiblingExitTime;
	protected long ticket;
	protected short stackDepth;
	protected TRCObjectValue objectValue;
	protected int childCount;
	protected List inputValues = new FastList();
	protected List outputValues = new FastList();
	//~ Methods
	// ------------------------------------------------------------------------------------
	protected void updateTimeStatistics() {
		//update base time
		invokerMethod.setBaseTime(invokerMethod.getBaseTime() + deltaBaseTime);
		if (invokerObject != null) {
			invokerObject.setBaseTime(invokerObject.getBaseTime() + deltaBaseTime);
			if (invokerObjectClass != null) {
				invokerObjectClass.setInheritedBaseTime(invokerObjectClass.getInheritedBaseTime() + deltaBaseTime);
				invokerObjectClass.getPackage().setInheritedBaseTime(invokerObjectClass.getPackage().getInheritedBaseTime() + deltaBaseTime);
				invokerObjectClass.getPackage().getProcess().setInheritedBaseTime(invokerObjectClass.getPackage().getProcess().getInheritedBaseTime() + deltaBaseTime);
			}
		}
		invokerClass.setBaseTime(invokerClass.getBaseTime() + deltaBaseTime);
		invokerClass.getPackage().setBaseTime(invokerClass.getPackage().getBaseTime() + deltaBaseTime);
		invokerClass.getPackage().getProcess().setBaseTime(invokerClass.getPackage().getProcess().getBaseTime() + deltaBaseTime);
		//update cumulative time
		Iterator stackIter = cs.iterator();
		// current invocation should be on the stack for methodExit but not for
		// methodEntry
		while (stackIter.hasNext()) {
			InvocationInfo invocationInfo = (InvocationInfo) stackIter.next();
			if (!invocationInfo.isObjectLocked()) {
				TRCFullTraceObject obj = invocationInfo.getObject();
				obj.setCumulativeTime(obj.getCumulativeTime() + deltaBaseTime);
			}
			TRCClass objectClass = invocationInfo.getObjectClass();
			if ((objectClass != null) && !invocationInfo.isObjectClassLocked()) {
				objectClass.setInheritedCumulativeTime(objectClass.getInheritedCumulativeTime() + deltaBaseTime);
				objectClass.getPackage().setInheritedCumulativeTime(objectClass.getPackage().getInheritedCumulativeTime() + deltaBaseTime);
				objectClass.getPackage().getProcess().setInheritedCumulativeTime(objectClass.getPackage().getProcess().getInheritedCumulativeTime() + deltaBaseTime);
			}
			if (!invocationInfo.isMethodLocked()) {
				invocationInfo.getMethod().setCumulativeTime(invocationInfo.getMethod().getCumulativeTime() + deltaBaseTime);
			}
			if (!invocationInfo.isClassLocked()) {
				invokerClass = invocationInfo.getTheClass();
				invokerClass.setCumulativeTime(invokerClass.getCumulativeTime() + deltaBaseTime);
				invokerClass.getPackage().setCumulativeTime(invokerClass.getPackage().getCumulativeTime() + deltaBaseTime);
				invokerClass.getPackage().getProcess().setCumulativeTime(invokerClass.getPackage().getProcess().getCumulativeTime() + deltaBaseTime);
			}
		}
	}
	protected TRCClass getExtendedClass(TRCObject anObject, TRCClass aClass) {
		if (anObject != null) {
			if (anObject.getIsA() != aClass) {
				if (anObject.getIsA() != theProcess.getClassClass())
					return anObject.getIsA();
			}
		}
		return null;
	}
	/**
	 * @param theThread
	 */
	protected void setMaxStackDepth(TRCThread theThread) {
		if (theThread == null)
			return;
		if (stackDepth > theThread.getMaxStackDepth())
			theThread.setMaxStackDepth(stackDepth);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#startChild(java.lang.String)
	 */
	public void startChild(String name) {
		childCount++;
		if (name.equals(PARAMETER)) {
			objectValue = TraceFactory.eINSTANCE.createTRCObjectValue();
			inputValues.add(objectValue);
		} else if (name.equals(RETURN_VALUE)) {
			objectValue = TraceFactory.eINSTANCE.createTRCObjectValue();
			outputValues.add(objectValue);
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#endChild(java.lang.String)
	 */
	public void endChild(String name) {
		objectValue=null;
	}
	public void addInputOutputValues() {
		List l = (List) getInputOutputContainer().getEntries().get(fullInvocation);
		if (l == null) {
			l = new FastList();
			getInputOutputContainer().getEntries().put(fullInvocation, l);
			l = (List) getInputOutputContainer().getEntries().get(fullInvocation);
		}
		if (!outputValues.isEmpty()) {
			getInputOutputContainer().getInputOutputValues().add(outputValues.get(outputValues.size() - 1));
			l.set(0, outputValues.get(outputValues.size() - 1)); // last value wins
		} else if (l.isEmpty()) {
			TRCObjectValue objectValue = TraceFactory.eINSTANCE.createTRCObjectValue(); 
			getInputOutputContainer().getInputOutputValues().add(objectValue);
			l.add(objectValue); // reserve the first entry for return value
		}
		if (!inputValues.isEmpty()) {
			getInputOutputContainer().getInputOutputValues().addAll(inputValues);
			if (this instanceof XMLmethodExitLoader && l.size() < (inputValues.size() + 1)) {
				for (int i = 0; i < inputValues.size(); i++) {
					l.add(TraceFactory.eINSTANCE.createTRCObjectValue()); // fill gap for methodEntry input values
				}
			}
			l.addAll(inputValues); // concatenate all input values at the end of the list
		}
	}
	/**
	 * @return
	 */
	protected TRCInputOutputContainer getInputOutputContainer() {
		TRCInputOutputContainer inputOutputContainer = getProcess().getInputOutputContainer();
		if (inputOutputContainer == null) {
			inputOutputContainer = TraceFactory.eINSTANCE.createTRCInputOutputContainer();
			inputOutputContainer.setProcess(getProcess());
			Resource r = createInputOutputContainerResource(inputOutputContainer);
			r.getContents().add(inputOutputContainer);
		}
		return inputOutputContainer;
	}
	/**
	 * @param inputOutputContainer
	 */
	private Resource createInputOutputContainerResource(TRCInputOutputContainer inputOutputContainer) {
		String uri = inputOutputContainer.getProcess().eResource().getURI().toString();
		String newUri = uri.substring(0, uri.indexOf(".trca"));
		newUri = newUri.concat(".trciov").concat(uri.substring(uri.indexOf(".trca") + 5));
		return HierarchyResourceSetImpl.getInstance().createResource(SaveUtil.createURI(newUri));
	}
}