/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.cbe.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEComponentIdentification;
import org.eclipse.hyades.models.cbe.CBEContextDataElement;
import org.eclipse.hyades.models.cbe.CBEMsgDataElement;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.cbe.CBESituation;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Common Base Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getLocalInstanceId <em>Local Instance Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getGlobalInstanceId <em>Global Instance Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getCreationTime <em>Creation Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getTimeZone <em>Time Zone</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getSeverity <em>Severity</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getPriority <em>Priority</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getMsg <em>Msg</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getRepeatCount <em>Repeat Count</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getElapsedTime <em>Elapsed Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getSequenceNumber <em>Sequence Number</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getVersion <em>Version</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getOtherData <em>Other Data</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getContextDataElements <em>Context Data Elements</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getReporterComponentId <em>Reporter Component Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getSourceComponentId <em>Source Component Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getMsgDataElement <em>Msg Data Element</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl#getSituation <em>Situation</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CBECommonBaseEventImpl extends CBEDefaultEventImpl implements CBECommonBaseEvent {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The default value of the '{@link #getLocalInstanceId() <em>Local Instance Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocalInstanceId()
	 * @generated
	 * @ordered
	 */
	protected static final String LOCAL_INSTANCE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLocalInstanceId() <em>Local Instance Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocalInstanceId()
	 * @generated
	 * @ordered
	 */
	protected String localInstanceId = LOCAL_INSTANCE_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getGlobalInstanceId() <em>Global Instance Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGlobalInstanceId()
	 * @generated
	 * @ordered
	 */
	protected static final String GLOBAL_INSTANCE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getGlobalInstanceId() <em>Global Instance Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGlobalInstanceId()
	 * @generated
	 * @ordered
	 */
	protected String globalInstanceId = GLOBAL_INSTANCE_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getCreationTime() <em>Creation Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreationTime()
	 * @generated
	 * @ordered
	 */
	protected static final double CREATION_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getCreationTime() <em>Creation Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreationTime()
	 * @generated
	 * @ordered
	 */
	protected double creationTime = CREATION_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getTimeZone() <em>Time Zone</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimeZone()
	 * @generated
	 * @ordered
	 */
	protected static final short TIME_ZONE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTimeZone() <em>Time Zone</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimeZone()
	 * @generated
	 * @ordered
	 */
	protected short timeZone = TIME_ZONE_EDEFAULT;

	/**
	 * The default value of the '{@link #getSeverity() <em>Severity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSeverity()
	 * @generated
	 * @ordered
	 */
	protected static final short SEVERITY_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getSeverity() <em>Severity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSeverity()
	 * @generated
	 * @ordered
	 */
	protected short severity = SEVERITY_EDEFAULT;

	/**
	 * The default value of the '{@link #getPriority() <em>Priority</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPriority()
	 * @generated
	 * @ordered
	 */
	protected static final short PRIORITY_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPriority() <em>Priority</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPriority()
	 * @generated
	 * @ordered
	 */
	protected short priority = PRIORITY_EDEFAULT;

	/**
	 * The default value of the '{@link #getMsg() <em>Msg</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMsg()
	 * @generated
	 * @ordered
	 */
	protected static final String MSG_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMsg() <em>Msg</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMsg()
	 * @generated
	 * @ordered
	 */
	protected String msg = MSG_EDEFAULT;

	/**
	 * The default value of the '{@link #getRepeatCount() <em>Repeat Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRepeatCount()
	 * @generated
	 * @ordered
	 */
	protected static final short REPEAT_COUNT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getRepeatCount() <em>Repeat Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRepeatCount()
	 * @generated
	 * @ordered
	 */
	protected short repeatCount = REPEAT_COUNT_EDEFAULT;

	/**
	 * The default value of the '{@link #getElapsedTime() <em>Elapsed Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getElapsedTime()
	 * @generated
	 * @ordered
	 */
	protected static final long ELAPSED_TIME_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getElapsedTime() <em>Elapsed Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getElapsedTime()
	 * @generated
	 * @ordered
	 */
	protected long elapsedTime = ELAPSED_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getSequenceNumber() <em>Sequence Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSequenceNumber()
	 * @generated
	 * @ordered
	 */
	protected static final long SEQUENCE_NUMBER_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getSequenceNumber() <em>Sequence Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSequenceNumber()
	 * @generated
	 * @ordered
	 */
	protected long sequenceNumber = SEQUENCE_NUMBER_EDEFAULT;

	/**
	 * The default value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected static final String VERSION_EDEFAULT = "commonbaseevent1_0";

	/**
	 * The cached value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected String version = VERSION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOtherData() <em>Other Data</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOtherData()
	 * @generated
	 * @ordered
	 */
	protected EList otherData = null;

	/**
	 * The cached value of the '{@link #getContextDataElements() <em>Context Data Elements</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContextDataElements()
	 * @generated
	 * @ordered
	 */
	protected EList contextDataElements = null;

	/**
	 * The cached value of the '{@link #getReporterComponentId() <em>Reporter Component Id</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReporterComponentId()
	 * @generated
	 * @ordered
	 */
	protected CBEComponentIdentification reporterComponentId = null;

	/**
	 * The cached value of the '{@link #getSourceComponentId() <em>Source Component Id</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceComponentId()
	 * @generated
	 * @ordered
	 */
	protected CBEComponentIdentification sourceComponentId = null;

	/**
	 * The cached value of the '{@link #getMsgDataElement() <em>Msg Data Element</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMsgDataElement()
	 * @generated
	 * @ordered
	 */
	protected CBEMsgDataElement msgDataElement = null;

	/**
	 * The cached value of the '{@link #getSituation() <em>Situation</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSituation()
	 * @generated
	 * @ordered
	 */
	protected CBESituation situation = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CBECommonBaseEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return CBEPackage.eINSTANCE.getCBECommonBaseEvent();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLocalInstanceId() {
		return localInstanceId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLocalInstanceId(String newLocalInstanceId) {
		String oldLocalInstanceId = localInstanceId;
		localInstanceId = newLocalInstanceId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__LOCAL_INSTANCE_ID, oldLocalInstanceId, localInstanceId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getGlobalInstanceId() {
		return globalInstanceId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setGlobalInstanceId(String newGlobalInstanceId) {
		String oldGlobalInstanceId = globalInstanceId;
		globalInstanceId = newGlobalInstanceId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__GLOBAL_INSTANCE_ID, oldGlobalInstanceId, globalInstanceId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getCreationTime() {
		return creationTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCreationTime(double newCreationTime) {
		double oldCreationTime = creationTime;
		creationTime = newCreationTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__CREATION_TIME, oldCreationTime, creationTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public short getTimeZone() {
		return timeZone;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTimeZone(short newTimeZone) {
		short oldTimeZone = timeZone;
		timeZone = newTimeZone;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__TIME_ZONE, oldTimeZone, timeZone));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public short getSeverity() {
		return severity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSeverity(short newSeverity) {
		short oldSeverity = severity;
		severity = newSeverity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__SEVERITY, oldSeverity, severity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public short getPriority() {
		return priority;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPriority(short newPriority) {
		short oldPriority = priority;
		priority = newPriority;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__PRIORITY, oldPriority, priority));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getMsg() {
		return msg;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMsg(String newMsg) {
		String oldMsg = msg;
		msg = newMsg;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__MSG, oldMsg, msg));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public short getRepeatCount() {
		return repeatCount;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRepeatCount(short newRepeatCount) {
		short oldRepeatCount = repeatCount;
		repeatCount = newRepeatCount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__REPEAT_COUNT, oldRepeatCount, repeatCount));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getElapsedTime() {
		return elapsedTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setElapsedTime(long newElapsedTime) {
		long oldElapsedTime = elapsedTime;
		elapsedTime = newElapsedTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__ELAPSED_TIME, oldElapsedTime, elapsedTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getSequenceNumber() {
		return sequenceNumber;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSequenceNumber(long newSequenceNumber) {
		long oldSequenceNumber = sequenceNumber;
		sequenceNumber = newSequenceNumber;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__SEQUENCE_NUMBER, oldSequenceNumber, sequenceNumber));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVersion(String newVersion) {
		String oldVersion = version;
		version = newVersion;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__VERSION, oldVersion, version));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOtherData() {
		if (otherData == null) {
			otherData = new EDataTypeUniqueEList(String.class, this, CBEPackage.CBE_COMMON_BASE_EVENT__OTHER_DATA);
		}
		return otherData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getContextDataElements() {
		if (contextDataElements == null) {
			contextDataElements = new EObjectContainmentEList(CBEContextDataElement.class, this, CBEPackage.CBE_COMMON_BASE_EVENT__CONTEXT_DATA_ELEMENTS);
		}
		return contextDataElements;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CBEComponentIdentification getReporterComponentId() {
		return reporterComponentId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetReporterComponentId(CBEComponentIdentification newReporterComponentId, NotificationChain msgs) {
		CBEComponentIdentification oldReporterComponentId = reporterComponentId;
		reporterComponentId = newReporterComponentId;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__REPORTER_COMPONENT_ID, oldReporterComponentId, newReporterComponentId);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReporterComponentId(CBEComponentIdentification newReporterComponentId) {
		if (newReporterComponentId != reporterComponentId) {
			NotificationChain msgs = null;
			if (reporterComponentId != null)
				msgs = ((InternalEObject)reporterComponentId).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - CBEPackage.CBE_COMMON_BASE_EVENT__REPORTER_COMPONENT_ID, null, msgs);
			if (newReporterComponentId != null)
				msgs = ((InternalEObject)newReporterComponentId).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - CBEPackage.CBE_COMMON_BASE_EVENT__REPORTER_COMPONENT_ID, null, msgs);
			msgs = basicSetReporterComponentId(newReporterComponentId, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__REPORTER_COMPONENT_ID, newReporterComponentId, newReporterComponentId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CBEComponentIdentification getSourceComponentId() {
		return sourceComponentId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSourceComponentId(CBEComponentIdentification newSourceComponentId, NotificationChain msgs) {
		CBEComponentIdentification oldSourceComponentId = sourceComponentId;
		sourceComponentId = newSourceComponentId;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__SOURCE_COMPONENT_ID, oldSourceComponentId, newSourceComponentId);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSourceComponentId(CBEComponentIdentification newSourceComponentId) {
		if (newSourceComponentId != sourceComponentId) {
			NotificationChain msgs = null;
			if (sourceComponentId != null)
				msgs = ((InternalEObject)sourceComponentId).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - CBEPackage.CBE_COMMON_BASE_EVENT__SOURCE_COMPONENT_ID, null, msgs);
			if (newSourceComponentId != null)
				msgs = ((InternalEObject)newSourceComponentId).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - CBEPackage.CBE_COMMON_BASE_EVENT__SOURCE_COMPONENT_ID, null, msgs);
			msgs = basicSetSourceComponentId(newSourceComponentId, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__SOURCE_COMPONENT_ID, newSourceComponentId, newSourceComponentId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CBEMsgDataElement getMsgDataElement() {
		return msgDataElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMsgDataElement(CBEMsgDataElement newMsgDataElement, NotificationChain msgs) {
		CBEMsgDataElement oldMsgDataElement = msgDataElement;
		msgDataElement = newMsgDataElement;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__MSG_DATA_ELEMENT, oldMsgDataElement, newMsgDataElement);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMsgDataElement(CBEMsgDataElement newMsgDataElement) {
		if (newMsgDataElement != msgDataElement) {
			NotificationChain msgs = null;
			if (msgDataElement != null)
				msgs = ((InternalEObject)msgDataElement).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - CBEPackage.CBE_COMMON_BASE_EVENT__MSG_DATA_ELEMENT, null, msgs);
			if (newMsgDataElement != null)
				msgs = ((InternalEObject)newMsgDataElement).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - CBEPackage.CBE_COMMON_BASE_EVENT__MSG_DATA_ELEMENT, null, msgs);
			msgs = basicSetMsgDataElement(newMsgDataElement, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__MSG_DATA_ELEMENT, newMsgDataElement, newMsgDataElement));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CBESituation getSituation() {
		return situation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSituation(CBESituation newSituation, NotificationChain msgs) {
		CBESituation oldSituation = situation;
		situation = newSituation;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__SITUATION, oldSituation, newSituation);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSituation(CBESituation newSituation) {
		if (newSituation != situation) {
			NotificationChain msgs = null;
			if (situation != null)
				msgs = ((InternalEObject)situation).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - CBEPackage.CBE_COMMON_BASE_EVENT__SITUATION, null, msgs);
			if (newSituation != null)
				msgs = ((InternalEObject)newSituation).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - CBEPackage.CBE_COMMON_BASE_EVENT__SITUATION, null, msgs);
			msgs = basicSetSituation(newSituation, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CBEPackage.CBE_COMMON_BASE_EVENT__SITUATION, newSituation, newSituation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case CBEPackage.CBE_COMMON_BASE_EVENT__AGENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, CBEPackage.CBE_COMMON_BASE_EVENT__AGENT, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case CBEPackage.CBE_COMMON_BASE_EVENT__AGENT:
					return eBasicSetContainer(null, CBEPackage.CBE_COMMON_BASE_EVENT__AGENT, msgs);
				case CBEPackage.CBE_COMMON_BASE_EVENT__EXTENDED_PROPERTIES:
					return ((InternalEList)getExtendedProperties()).basicRemove(otherEnd, msgs);
				case CBEPackage.CBE_COMMON_BASE_EVENT__CONTEXT_DATA_ELEMENTS:
					return ((InternalEList)getContextDataElements()).basicRemove(otherEnd, msgs);
				case CBEPackage.CBE_COMMON_BASE_EVENT__REPORTER_COMPONENT_ID:
					return basicSetReporterComponentId(null, msgs);
				case CBEPackage.CBE_COMMON_BASE_EVENT__SOURCE_COMPONENT_ID:
					return basicSetSourceComponentId(null, msgs);
				case CBEPackage.CBE_COMMON_BASE_EVENT__MSG_DATA_ELEMENT:
					return basicSetMsgDataElement(null, msgs);
				case CBEPackage.CBE_COMMON_BASE_EVENT__SITUATION:
					return basicSetSituation(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case CBEPackage.CBE_COMMON_BASE_EVENT__AGENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, HierarchyPackage.TRC_AGENT__DEFAULT_EVENTS, TRCAgent.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CBEPackage.CBE_COMMON_BASE_EVENT__AGENT:
				return getAgent();
			case CBEPackage.CBE_COMMON_BASE_EVENT__ANALYZED:
				return isAnalyzed() ? Boolean.TRUE : Boolean.FALSE;
			case CBEPackage.CBE_COMMON_BASE_EVENT__EXTENSION_NAME:
				return getExtensionName();
			case CBEPackage.CBE_COMMON_BASE_EVENT__SYMPTOMS:
				return getSymptoms();
			case CBEPackage.CBE_COMMON_BASE_EVENT__EXTENDED_PROPERTIES:
				return getExtendedProperties();
			case CBEPackage.CBE_COMMON_BASE_EVENT__LOCAL_INSTANCE_ID:
				return getLocalInstanceId();
			case CBEPackage.CBE_COMMON_BASE_EVENT__GLOBAL_INSTANCE_ID:
				return getGlobalInstanceId();
			case CBEPackage.CBE_COMMON_BASE_EVENT__CREATION_TIME:
				return new Double(getCreationTime());
			case CBEPackage.CBE_COMMON_BASE_EVENT__TIME_ZONE:
				return new Short(getTimeZone());
			case CBEPackage.CBE_COMMON_BASE_EVENT__SEVERITY:
				return new Short(getSeverity());
			case CBEPackage.CBE_COMMON_BASE_EVENT__PRIORITY:
				return new Short(getPriority());
			case CBEPackage.CBE_COMMON_BASE_EVENT__MSG:
				return getMsg();
			case CBEPackage.CBE_COMMON_BASE_EVENT__REPEAT_COUNT:
				return new Short(getRepeatCount());
			case CBEPackage.CBE_COMMON_BASE_EVENT__ELAPSED_TIME:
				return new Long(getElapsedTime());
			case CBEPackage.CBE_COMMON_BASE_EVENT__SEQUENCE_NUMBER:
				return new Long(getSequenceNumber());
			case CBEPackage.CBE_COMMON_BASE_EVENT__VERSION:
				return getVersion();
			case CBEPackage.CBE_COMMON_BASE_EVENT__OTHER_DATA:
				return getOtherData();
			case CBEPackage.CBE_COMMON_BASE_EVENT__CONTEXT_DATA_ELEMENTS:
				return getContextDataElements();
			case CBEPackage.CBE_COMMON_BASE_EVENT__REPORTER_COMPONENT_ID:
				return getReporterComponentId();
			case CBEPackage.CBE_COMMON_BASE_EVENT__SOURCE_COMPONENT_ID:
				return getSourceComponentId();
			case CBEPackage.CBE_COMMON_BASE_EVENT__MSG_DATA_ELEMENT:
				return getMsgDataElement();
			case CBEPackage.CBE_COMMON_BASE_EVENT__SITUATION:
				return getSituation();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CBEPackage.CBE_COMMON_BASE_EVENT__AGENT:
				setAgent((TRCAgent)newValue);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__ANALYZED:
				setAnalyzed(((Boolean)newValue).booleanValue());
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__EXTENSION_NAME:
				setExtensionName((String)newValue);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__SYMPTOMS:
				getSymptoms().clear();
				getSymptoms().addAll((Collection)newValue);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__EXTENDED_PROPERTIES:
				getExtendedProperties().clear();
				getExtendedProperties().addAll((Collection)newValue);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__LOCAL_INSTANCE_ID:
				setLocalInstanceId((String)newValue);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__GLOBAL_INSTANCE_ID:
				setGlobalInstanceId((String)newValue);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__CREATION_TIME:
				setCreationTime(((Double)newValue).doubleValue());
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__TIME_ZONE:
				setTimeZone(((Short)newValue).shortValue());
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__SEVERITY:
				setSeverity(((Short)newValue).shortValue());
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__PRIORITY:
				setPriority(((Short)newValue).shortValue());
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__MSG:
				setMsg((String)newValue);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__REPEAT_COUNT:
				setRepeatCount(((Short)newValue).shortValue());
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__ELAPSED_TIME:
				setElapsedTime(((Long)newValue).longValue());
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__SEQUENCE_NUMBER:
				setSequenceNumber(((Long)newValue).longValue());
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__VERSION:
				setVersion((String)newValue);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__OTHER_DATA:
				getOtherData().clear();
				getOtherData().addAll((Collection)newValue);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__CONTEXT_DATA_ELEMENTS:
				getContextDataElements().clear();
				getContextDataElements().addAll((Collection)newValue);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__REPORTER_COMPONENT_ID:
				setReporterComponentId((CBEComponentIdentification)newValue);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__SOURCE_COMPONENT_ID:
				setSourceComponentId((CBEComponentIdentification)newValue);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__MSG_DATA_ELEMENT:
				setMsgDataElement((CBEMsgDataElement)newValue);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__SITUATION:
				setSituation((CBESituation)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CBEPackage.CBE_COMMON_BASE_EVENT__AGENT:
				setAgent((TRCAgent)null);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__ANALYZED:
				setAnalyzed(ANALYZED_EDEFAULT);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__EXTENSION_NAME:
				setExtensionName(EXTENSION_NAME_EDEFAULT);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__SYMPTOMS:
				getSymptoms().clear();
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__EXTENDED_PROPERTIES:
				getExtendedProperties().clear();
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__LOCAL_INSTANCE_ID:
				setLocalInstanceId(LOCAL_INSTANCE_ID_EDEFAULT);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__GLOBAL_INSTANCE_ID:
				setGlobalInstanceId(GLOBAL_INSTANCE_ID_EDEFAULT);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__CREATION_TIME:
				setCreationTime(CREATION_TIME_EDEFAULT);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__TIME_ZONE:
				setTimeZone(TIME_ZONE_EDEFAULT);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__SEVERITY:
				setSeverity(SEVERITY_EDEFAULT);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__PRIORITY:
				setPriority(PRIORITY_EDEFAULT);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__MSG:
				setMsg(MSG_EDEFAULT);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__REPEAT_COUNT:
				setRepeatCount(REPEAT_COUNT_EDEFAULT);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__ELAPSED_TIME:
				setElapsedTime(ELAPSED_TIME_EDEFAULT);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__SEQUENCE_NUMBER:
				setSequenceNumber(SEQUENCE_NUMBER_EDEFAULT);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__VERSION:
				setVersion(VERSION_EDEFAULT);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__OTHER_DATA:
				getOtherData().clear();
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__CONTEXT_DATA_ELEMENTS:
				getContextDataElements().clear();
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__REPORTER_COMPONENT_ID:
				setReporterComponentId((CBEComponentIdentification)null);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__SOURCE_COMPONENT_ID:
				setSourceComponentId((CBEComponentIdentification)null);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__MSG_DATA_ELEMENT:
				setMsgDataElement((CBEMsgDataElement)null);
				return;
			case CBEPackage.CBE_COMMON_BASE_EVENT__SITUATION:
				setSituation((CBESituation)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CBEPackage.CBE_COMMON_BASE_EVENT__AGENT:
				return getAgent() != null;
			case CBEPackage.CBE_COMMON_BASE_EVENT__ANALYZED:
				return analyzed != ANALYZED_EDEFAULT;
			case CBEPackage.CBE_COMMON_BASE_EVENT__EXTENSION_NAME:
				return EXTENSION_NAME_EDEFAULT == null ? extensionName != null : !EXTENSION_NAME_EDEFAULT.equals(extensionName);
			case CBEPackage.CBE_COMMON_BASE_EVENT__SYMPTOMS:
				return symptoms != null && !symptoms.isEmpty();
			case CBEPackage.CBE_COMMON_BASE_EVENT__EXTENDED_PROPERTIES:
				return extendedProperties != null && !extendedProperties.isEmpty();
			case CBEPackage.CBE_COMMON_BASE_EVENT__LOCAL_INSTANCE_ID:
				return LOCAL_INSTANCE_ID_EDEFAULT == null ? localInstanceId != null : !LOCAL_INSTANCE_ID_EDEFAULT.equals(localInstanceId);
			case CBEPackage.CBE_COMMON_BASE_EVENT__GLOBAL_INSTANCE_ID:
				return GLOBAL_INSTANCE_ID_EDEFAULT == null ? globalInstanceId != null : !GLOBAL_INSTANCE_ID_EDEFAULT.equals(globalInstanceId);
			case CBEPackage.CBE_COMMON_BASE_EVENT__CREATION_TIME:
				return creationTime != CREATION_TIME_EDEFAULT;
			case CBEPackage.CBE_COMMON_BASE_EVENT__TIME_ZONE:
				return timeZone != TIME_ZONE_EDEFAULT;
			case CBEPackage.CBE_COMMON_BASE_EVENT__SEVERITY:
				return severity != SEVERITY_EDEFAULT;
			case CBEPackage.CBE_COMMON_BASE_EVENT__PRIORITY:
				return priority != PRIORITY_EDEFAULT;
			case CBEPackage.CBE_COMMON_BASE_EVENT__MSG:
				return MSG_EDEFAULT == null ? msg != null : !MSG_EDEFAULT.equals(msg);
			case CBEPackage.CBE_COMMON_BASE_EVENT__REPEAT_COUNT:
				return repeatCount != REPEAT_COUNT_EDEFAULT;
			case CBEPackage.CBE_COMMON_BASE_EVENT__ELAPSED_TIME:
				return elapsedTime != ELAPSED_TIME_EDEFAULT;
			case CBEPackage.CBE_COMMON_BASE_EVENT__SEQUENCE_NUMBER:
				return sequenceNumber != SEQUENCE_NUMBER_EDEFAULT;
			case CBEPackage.CBE_COMMON_BASE_EVENT__VERSION:
				return VERSION_EDEFAULT == null ? version != null : !VERSION_EDEFAULT.equals(version);
			case CBEPackage.CBE_COMMON_BASE_EVENT__OTHER_DATA:
				return otherData != null && !otherData.isEmpty();
			case CBEPackage.CBE_COMMON_BASE_EVENT__CONTEXT_DATA_ELEMENTS:
				return contextDataElements != null && !contextDataElements.isEmpty();
			case CBEPackage.CBE_COMMON_BASE_EVENT__REPORTER_COMPONENT_ID:
				return reporterComponentId != null;
			case CBEPackage.CBE_COMMON_BASE_EVENT__SOURCE_COMPONENT_ID:
				return sourceComponentId != null;
			case CBEPackage.CBE_COMMON_BASE_EVENT__MSG_DATA_ELEMENT:
				return msgDataElement != null;
			case CBEPackage.CBE_COMMON_BASE_EVENT__SITUATION:
				return situation != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (localInstanceId: ");
		result.append(localInstanceId);
		result.append(", globalInstanceId: ");
		result.append(globalInstanceId);
		result.append(", creationTime: ");
		result.append(creationTime);
		result.append(", timeZone: ");
		result.append(timeZone);
		result.append(", severity: ");
		result.append(severity);
		result.append(", priority: ");
		result.append(priority);
		result.append(", msg: ");
		result.append(msg);
		result.append(", repeatCount: ");
		result.append(repeatCount);
		result.append(", elapsedTime: ");
		result.append(elapsedTime);
		result.append(", sequenceNumber: ");
		result.append(sequenceNumber);
		result.append(", version: ");
		result.append(version);
		result.append(", otherData: ");
		result.append(otherData);
		result.append(')');
		return result.toString();
	}

} //CBECommonBaseEventImpl
