/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.test.ui.datapool.internal.control;

import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.datapool.internal.action.CopyAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.CutAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.DeleteColumnAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.DeleteRowAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.DeleteRowGroupAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.EditColumnAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.EditRowAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.EditRowGroupAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.InsertColumnAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.InsertRowAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.InsertRowGroupAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.PasteAction;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.ActionFactory;

/**
 * @author psun
 *
 */
public class DatapoolMenuManager 
{

	private InsertRowAction insertRowAction = null;	
	private DeleteRowAction deleteRowAction = null;
 	private EditRowAction editRowAction = null;
	private InsertColumnAction insertColumnAction = null;
	private DeleteColumnAction deleteColumnAction = null;
 	private EditColumnAction editColumnAction = null;
	private InsertRowGroupAction insertRowGroupAction = null;
	private DeleteRowGroupAction deleteRowGroupAction = null;
	private EditRowGroupAction editRowGroupAction = null;
	private CutAction cutAction = null;
	private CopyAction copyAction = null;
	private PasteAction pasteAction = null;
	
	private DatapoolTable table = null;
	private Vector customActions = null;
	private String vendorID = null;
	private boolean showRowGroupActions = true;
	private boolean showColumnActions = true;
	private boolean showRowActions = true;
	private boolean showEditActions = true;
	
	public DatapoolMenuManager(DatapoolTable table, 
								String vendorID, 
								boolean showEquivalenceClassActions,
								boolean showVariableActions,
								boolean showRecordActions)
	{
		if(table == null)
			return;
		this.table = table;
		this.customActions = new Vector();
		this.vendorID = vendorID;
		this.showRowGroupActions = showEquivalenceClassActions;
		this.showColumnActions = showVariableActions;
		this.showRowActions = showRecordActions;
		makeActions();
	}
	
	/*
	 * Creates all the actions
	 */
	private void makeActions()
	{
		ISelectionProvider provider = table.getViewer();
		
		insertRowAction = new InsertRowAction(provider, table);
		deleteRowAction = new DeleteRowAction(provider, table);
		editRowAction = new EditRowAction(provider, table);
		insertColumnAction = new InsertColumnAction(provider, table);
		deleteColumnAction = new DeleteColumnAction(provider, table);
		editColumnAction = new EditColumnAction(provider, table);		
		insertRowGroupAction = new InsertRowGroupAction(provider, table);
		deleteRowGroupAction = new DeleteRowGroupAction(provider, table);
		editRowGroupAction = new EditRowGroupAction(provider, table);
		cutAction = new CutAction(provider, table);
		copyAction = new CopyAction(provider, table);
		pasteAction = new PasteAction(provider, table);

		table.getIDatapoolPart().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), cutAction);
		table.getIDatapoolPart().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), copyAction);
		table.getIDatapoolPart().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), pasteAction);

		if(this.vendorID == null)
			return;
		IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.test.ui.datapool.menuExtension"); //$NON-NLS-1$

		if (extensionPoint != null)
		{
			try {
	  
				IConfigurationElement[] extensionPoints = extensionPoint.getConfigurationElements();
				for(int i = 0; i < extensionPoints.length; i++)
				{
					String extVendorID = extensionPoints[i].getAttribute("vendorID"); //$NON-NLS-1$
					if(this.vendorID.equals(extVendorID))
					{
						String displayName = extensionPoints[i].getAttribute("displayName"); //$NON-NLS-1$
						IDatapoolAction action = (IDatapoolAction)extensionPoints[i].createExecutableExtension("actionClass"); //$NON-NLS-1$
						customActions.add(action);
						action.setDatapoolTable(this.table);
					}
				}
			}
			catch(Exception e)
			{
			}
		}			
	}
			
	public void addActions(IMenuManager imenuMgr)
	{
		MenuManager menuMgr = (MenuManager)imenuMgr;

		// Add actions to menu.
		if(showRowGroupActions)
		{
			menuMgr.add(insertRowGroupAction);				
			menuMgr.add(deleteRowGroupAction);				
			menuMgr.add(editRowGroupAction);				
		}
		if(showRowActions)
		{
			menuMgr.add(insertRowAction);				
			menuMgr.add(deleteRowAction);				
			menuMgr.add(editRowAction);	
		}
		if(showColumnActions)
		{
			menuMgr.add(insertColumnAction);				
			menuMgr.add(deleteColumnAction);
			menuMgr.add(editColumnAction);
		}
		if(showEditActions)
		{
			menuMgr.add(cutAction);				
			menuMgr.add(copyAction);
			menuMgr.add(pasteAction);			
		}
		for(int i = 0; i < customActions.size(); i++)
		{
			IAction action = (IAction)customActions.get(i);
			menuMgr.add(action);
		}
	}
	
	public void setDisplayMode(int mode, boolean isCutCopyPasteable)
	{
		boolean showPaste = !DatapoolClipboard.getInstance().isEmpty();
		// Based on the mode, enable certain menu items.
		switch(mode)
		{
			case 0: 
				insertRowGroupAction.aboutToShow(true);
				deleteRowGroupAction.aboutToShow(true);
				editRowGroupAction.aboutToShow(true);
				insertRowAction.aboutToShow(true);
				deleteRowAction.aboutToShow(true);
				editRowAction.aboutToShow(true);
				insertColumnAction.aboutToShow(true);
				deleteColumnAction.aboutToShow(false);
				editColumnAction.aboutToShow(false);
				cutAction.aboutToShow(true && isCutCopyPasteable);
				copyAction.aboutToShow(true && isCutCopyPasteable);
				pasteAction.aboutToShow(showPaste && isCutCopyPasteable);				
				break;
			case 1:
				insertRowGroupAction.aboutToShow(true);
				deleteRowGroupAction.aboutToShow(true);
				editRowGroupAction.aboutToShow(true);
				insertRowAction.aboutToShow(true);
				deleteRowAction.aboutToShow(true);
				editRowAction.aboutToShow(true);
				insertColumnAction.aboutToShow(true);
				deleteColumnAction.aboutToShow(true);
				editColumnAction.aboutToShow(true);
				cutAction.aboutToShow(true && isCutCopyPasteable);
				copyAction.aboutToShow(true && isCutCopyPasteable);
				pasteAction.aboutToShow(showPaste && isCutCopyPasteable);
				break;
			case 2:				
			case 4:
				insertRowGroupAction.aboutToShow(true);
				deleteRowGroupAction.aboutToShow(false);
				editRowGroupAction.aboutToShow(false);
				insertRowAction.aboutToShow(false || !showRowGroupActions);
				deleteRowAction.aboutToShow(false);
				editRowAction.aboutToShow(false);
				insertColumnAction.aboutToShow(true);
				deleteColumnAction.aboutToShow(false);
				editColumnAction.aboutToShow(false);
				cutAction.aboutToShow(false && isCutCopyPasteable);
				copyAction.aboutToShow(false && isCutCopyPasteable);
				pasteAction.aboutToShow(false && isCutCopyPasteable);
				break;
			case 3:
				insertRowGroupAction.aboutToShow(true);
				deleteRowGroupAction.aboutToShow(false);
				editRowGroupAction.aboutToShow(false);
				insertRowAction.aboutToShow(false || !showRowGroupActions);
				deleteRowAction.aboutToShow(false);
				editRowAction.aboutToShow(false);
				insertColumnAction.aboutToShow(true);
				deleteColumnAction.aboutToShow(true);
				editColumnAction.aboutToShow(false);
				cutAction.aboutToShow(false && isCutCopyPasteable);
				copyAction.aboutToShow(false && isCutCopyPasteable);
				pasteAction.aboutToShow(false && isCutCopyPasteable);
				break;
			case 5:
				insertRowGroupAction.aboutToShow(false);
				deleteRowGroupAction.aboutToShow(false);
				editRowGroupAction.aboutToShow(false);
				insertRowAction.aboutToShow(false);
				deleteRowAction.aboutToShow(false);
				editRowAction.aboutToShow(false);
				insertColumnAction.aboutToShow(false);
				deleteColumnAction.aboutToShow(false);
				editColumnAction.aboutToShow(false);
				cutAction.aboutToShow(false && isCutCopyPasteable);
				copyAction.aboutToShow(true && isCutCopyPasteable);
				pasteAction.aboutToShow(false && isCutCopyPasteable);
				break;
			default:
				insertRowAction.aboutToShow(true);
				deleteRowAction.aboutToShow(true);
				editRowAction.aboutToShow(true);
				insertRowGroupAction.aboutToShow(true);
				deleteRowGroupAction.aboutToShow(true);
				editRowGroupAction.aboutToShow(true);
				insertColumnAction.aboutToShow(true);
				deleteColumnAction.aboutToShow(true);
				editColumnAction.aboutToShow(true);
				cutAction.aboutToShow(true && isCutCopyPasteable);
				copyAction.aboutToShow(true && isCutCopyPasteable);
				pasteAction.aboutToShow(false && isCutCopyPasteable);				
				break;
		}
	}
}
