/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon;

import org.eclipse.swt.widgets.Display;

import org.eclipse.hyades.statistical.ui.variableloader.internal.*;

import org.eclipse.hyades.statistical.ui.editor.internal.*;
import org.eclipse.hyades.model.statistical.*;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.models.hierarchy.util.*;
import org.eclipse.hyades.trace.internal.ui.*;

import org.eclipse.ui.dialogs.*;

import org.eclipse.core.runtime.*;

import org.eclipse.emf.common.util.*;

import org.eclipse.core.resources.*;
import org.eclipse.emf.ecore.resource.*;

import org.eclipse.emf.common.util.URI;

import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.*;

import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;

import java.io.*;
import java.text.*;
import java.util.*;

public class PerfmonModuleTrace implements AgentChangeListener, SDVariableModifierProxy {

//@TODO this should be FALSE when in hyades
private static final boolean USE_CUSTOM_LOADER = false;

ImageManager img = PerfmonPlugin.img;

StatConInterface statcon;
IProgressMonitor pmonitor;
	
String PERFMON_NODE = "Perfmon Trace";

String ACTION_FILTER_COUNTERS = "Set Counter Filters";
String ACTION_STOP_TRACE = "Stop Trace";
String ACTION_UPDATE_TREE = "Update Counter Tree";

String ACTION_START_TRACING = "Start Tracing this Counter";
String ACTION_STOP_TRACING = "Stop Tracing this Counter";

String ACTION_SETSMODELPATH = "Set Statistical Model save path...";

String tracename;

SimpleDateFormat smodel_sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");

boolean new_monitor = true;
TRCMonitor monitor;
TRCAgent agent;
PerfmonLoader loader;

VariablePadder var_padder;

SDModifiableVariableRepresentation freq_var;
double frequency = 1.0;	//seconds

URI smodelpath;
URI monitor_uri;

String rachost;

	public void unloadTrace() {
		var_padder.die = true;

		try {
			loader.shutdown();
		} catch (Exception e) {
			PerfmonPlugin.DBG.warning("failed to shut down Perfmon loader");
		}

		try {
			statcon.setConstantUpdate("PERFMON UPDATE "+loader.hashCode(),false,1000);
			statcon.setAgentImage(agent,img.getImage(ImageManager.IMG_PERFMON_STOP));
			
//			statcon.removeAgentAction(agent,ACTION_SETSMODELPATH);
			statcon.removeAgentAction(agent,ACTION_FILTER_COUNTERS);
			statcon.removeAgentAction(agent,ACTION_STOP_TRACE);
			statcon.removeAgentAction(agent,ACTION_UPDATE_TREE);
		} catch (Exception e) {
			PerfmonPlugin.DBG.warning("failed to remove stuff from statcon");
		}
		
		statcon.removeAgentChangeListener(this);
	}

	public void agentAdded(TRCAgent dead_agent) {
	}

	public void agentRemoved(TRCAgent dead_agent) {
		if (agent == dead_agent) {
			unloadTrace();	
		}
	}

	public void requestValue(String unique_id, int i) throws ClassCastException {
		requestValue(unique_id,(double)i);
	}
	public void requestValue(String unique_id, long i) throws ClassCastException {
		requestValue(unique_id,(double)i);
	}
	public void requestValue(String unique_id, float i) throws ClassCastException {
		requestValue(unique_id,(double)i);
	}
	public void requestValue(String unique_id, double d) throws ClassCastException {
		if (unique_id.equals("PERFMON#FREQUENCY")) {
			if (d < 0.5) d = 0.5;
			int i = (int)(d * 1000.0d);
			try {
				loader.setFrequency(i);
				frequency = d;
				freq_var.setMeasuredValue(System.currentTimeMillis(),d);
			} catch (IOException e) {
				PerfmonPlugin.DBG.logVisibleError(e,PerfmonPlugin.getString("ERROR_SETTING_FREQUENCY")+" "+i,false);
			}
		}
	}
	public void requestValue(String unique_id, Object newval) throws ClassCastException {
		requestValue(unique_id,((Number)newval).doubleValue());
	}
	

	public PerfmonModuleTrace(IProgressMonitor monitor, String rac_host, String reg_host, URI smodelpath, URI monitor_uri) {
		this.pmonitor = monitor;
		this.statcon = null; //programmatic launch
		this.smodelpath = smodelpath;
		this.monitor_uri = monitor_uri;
		rachost = rac_host;
//		init(rac_host, reg_host);	
//		new Init(rac_host,reg_host).start();
		new Init(rac_host,reg_host).run();
	}

	public PerfmonModuleTrace(StatConInterface statcon, String rac_host, String reg_host, URI smodelpath) {
		this.statcon = statcon;
		this.smodelpath = smodelpath;
		rachost = rac_host;
//		init(rac_host, reg_host);	
		new Init(rac_host,reg_host).start();
	}
	
	private String getStatModelFileName() {
		return tracename;
	}
	
	private void removeRepresentations(SDDescriptor descriptor) {
		if (descriptor == null) return;
		if (descriptor instanceof SDMemberDescriptor) {
			SDMemberDescriptor mem = (SDMemberDescriptor)descriptor; 
			mem.setRepresentation(null);
			EList obslist = mem.getSnapshotObservation();
			for (int i = 0; i < obslist.size(); i++) {
				SDSnapshotObservation obs = (SDSnapshotObservation)obslist.get(i);
				if (obs.getWindow() == null) {
					PerfmonPlugin.DBG.warning("NULL OBSERVATION WINDOW UNDER "+descriptor.getName()+" ("+descriptor.getDescription()+")");	
				}	
			}	
		}
		EList list = descriptor.getChildren();
		for (int i = 0; i < list.size(); i++) {
			removeRepresentations((SDDescriptor)list.get(i));	
		}
	}

/*	
	private boolean removeWithoutObservations(SDDescriptor descriptor) {
		if (descriptor == null) return false;
//TODO this doesnt work
		boolean children_have_data = false;

		//recurse on children first
		EList list = descriptor.getChildren();
		for (int i = 0; i < list.size(); i++) {
			if (removeWithoutObservations((SDDescriptor)list.get(i))) {
				children_have_data = true;	
			}	
		}
		
		if (!children_have_data) {
			if (descriptor instanceof SDMemberDescriptor) {
				SDMemberDescriptor sdmem = (SDMemberDescriptor)descriptor;
				if (sdmem.getSnapshotObservation().size() == 0) {
					//no data on this descriptor, return false
					descriptor.setParent(null);	
					descriptor.setAgent(null);
					return false;
				}
			}	
		}
		
		return true;
	}
*/	
	/**
	 * saves the resources of the monitor, node, process, and agent
	 */
	private void saveResources() throws IOException {
		
		URI baseStatisticalModelURI = smodelpath;
		IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();			

		IPath path = null;
		URI monitorURI = null;

		if (monitor_uri == null) {
			path = new Path(baseStatisticalModelURI+"/"+getStatModelFileName()+".trcmxmi"); 
				monitorURI = URI.createPlatformResourceURI(workspaceRoot.getFile(path).getProjectRelativePath().toString());
		} else {
			monitorURI = monitor_uri;
		}
						
		path = new Path(baseStatisticalModelURI+"/"+getStatModelFileName()+".trcnxmi"); 
		URI nodeURI = URI.createPlatformResourceURI(workspaceRoot.getFile(path).getProjectRelativePath().toString());
						
		path = new Path(baseStatisticalModelURI+"/"+getStatModelFileName()+".trcpxmi"); 
		URI processURI = URI.createPlatformResourceURI(workspaceRoot.getFile(path).getProjectRelativePath().toString());

		path = new Path(baseStatisticalModelURI+"/"+getStatModelFileName()+".trcaxmi"); 
		URI agentURI = URI.createPlatformResourceURI(workspaceRoot.getFile(path).getProjectRelativePath().toString());				

		ResourceSet resourceSet = HierarchyResourceSetImpl.getInstance();

		Resource monitorResource = null;
		Resource nodeResource = null;
		Resource processResource = null;
		Resource agentResource = null;


		try {
			monitorResource = resourceSet.getResource(monitorURI,true);
			PerfmonPlugin.DBG.info("got TRCMonitor resource OK");
		} catch (Exception e) {
			monitorResource = resourceSet.createResource(monitorURI);
			PerfmonPlugin.DBG.info("created TRCMonitor resource OK");
		}
		try {
			nodeResource = resourceSet.getResource(nodeURI,true);
			PerfmonPlugin.DBG.info("got TRCNode resource OK");
		} catch (Exception e) {
			nodeResource = resourceSet.createResource(nodeURI);
			PerfmonPlugin.DBG.info("created TRCNode resource OK");
		}
		try {
			processResource = resourceSet.getResource(processURI,true);
			PerfmonPlugin.DBG.info("got TRCProcessProxy resource OK");
		} catch (Exception e) {
			processResource = resourceSet.createResource(processURI);
			PerfmonPlugin.DBG.info("created TRCProcessProxy resource OK");
		}
		try {
			agentResource = resourceSet.getResource(agentURI,true);
			PerfmonPlugin.DBG.info("got TRCAgent resource OK");
		} catch (Exception e) {
			agentResource = resourceSet.createResource(agentURI);
			PerfmonPlugin.DBG.info("created TRCAgent resource OK");
		}

		if (monitor_uri == null) {
			try {
				monitorResource.getContents().add(monitor);
			} catch (Exception e) {
				PerfmonPlugin.DBG.error("problem adding to monitor resource");
			}
		}
		try {
			nodeResource.getContents().add(agent.getAgentProxy().getProcessProxy().getNode());
		} catch (Exception e) {
			PerfmonPlugin.DBG.error("problem adding to node resource");
		}
		try {
			processResource.getContents().add(agent.getAgentProxy().getProcessProxy());
		} catch (Exception e) {
			PerfmonPlugin.DBG.error("problem adding to process resource");
		}
		agentResource.getContents().add(agent);
/*
		ResourceSet resourceSet = HierarchyResourceSetImpl.getInstance();

		Resource monitorResource = resourceSet.createResource(monitorURI);
		Resource nodeResource = resourceSet.createResource(nodeURI);
		Resource processResource = resourceSet.createResource(processURI);
		Resource agentResource = resourceSet.createResource(agentURI);

		monitorResource.getContents().add(monitor);
		nodeResource.getContents().add(agent.getAgentProxy().getProcessProxy().getNode());
		processResource.getContents().add(agent.getAgentProxy().getProcessProxy());
		agentResource.getContents().add(agent);
*/		
	
	}
	private void saveStatisticalModel() throws IOException {

		//ArrayList list = new ArrayList();
		//list.addAll(filters.keySet());
		//
		////bring back all the hidden descriptors
		//for (int i = 0; i < list.size(); i++) {
		//	SDDescriptor des = (SDDescriptor)list.get(i);
		//	des.setAgent(agent);
		//} 

		EList descriptors = agent.getDescriptor();
		for (int i = 0; i < descriptors.size(); i++) {
			removeRepresentations((SDDescriptor)descriptors.get(i));	
		}
		//for (int i = 0; i < descriptors.size(); i++) {
		//	removeWithoutObservations((SDDescriptor)descriptors.get(i));	
		//}
		//for (int i = 0; i < descriptors.size(); i++) {
		//	PerfmonPlugin.DBG.info(((SDDescriptor)descriptors.get(i)).getName());	
		//}
		
		URI baseStatisticalModelURI = smodelpath;
		IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();			
		

		IPath path = new Path(baseStatisticalModelURI+"/"+getStatModelFileName()+".trcaxmi"); 
//		URI agentURI = URI.createPlatformResourceURI(workspaceRoot.getFile(path).getProjectRelativePath().toString());				
		URI agentURI = URI.createURI(workspaceRoot.getFile(path).getProjectRelativePath().toString());				

		if (statcon != null) {
			monitor.eResource().save(Collections.EMPTY_MAP);
			agent.getAgentProxy().getProcessProxy().getNode().eResource().save(Collections.EMPTY_MAP);
			agent.getAgentProxy().getProcessProxy().eResource().save(Collections.EMPTY_MAP);
			agent.eResource().save(Collections.EMPTY_MAP);
	
			statcon.setAgentFile(agent,agentURI);
		}
	}

	private void configureSliders() throws Exception {
		TimeZoomSlider xslider = statcon.getGraphWindow().getXSlider(0);
		double minvis = xslider.getMinVisible();
		double maxvis = xslider.getMaxVisible();
		double min = xslider.getMinLimit();
		double max = xslider.getMaxLimit();
		
		double ctime = System.currentTimeMillis();
		
		minvis = ctime;
		maxvis = ctime + (1000 * 60);
		min = Math.min(min,ctime - (double)(1000 * 60 * 60));
		max = Math.max(max,ctime + (double)(1000 * 60 * 60 * 24));

		xslider.configure(min,max,minvis,maxvis,xslider.getResolution());		
		
		ZoomSlider yslider = statcon.getGraphWindow().getYSlider(0);
		minvis = yslider.getMinVisible();
		maxvis = Math.max(yslider.getMaxVisible(),100.0d);
		min = yslider.getMinLimit();
		max = Math.max(yslider.getMaxLimit(),maxvis*10);
		
		yslider.configure(min,max,minvis,maxvis,yslider.getResolution());			
	}

	private void createTRCAgent(String tracename) {
		HierarchyFactory hfactory = HierarchyFactory.eINSTANCE;

		TRCMonitor monitorroot = null;
		TRCNode noderoot;
		TRCProcessProxy pproxyroot;
		TRCAgentProxy aproxyroot;
		TRCAgent agentroot;

		//TRCMonitor setup			

//		IPath path = new Path(baseStatisticalModelURI+"/"+getStatModelFileName()+".trcmxmi"); 
//		URI monitorURI = URI.createPlatformResourceURI(workspaceRoot.getFile(path).getProjectRelativePath().toString());
//		monitorURI = monitor_uri;

		if (monitor_uri != null) {
			PerfmonPlugin.DBG.info("TRCMonitor URI specified - fetching TRCMonitor");

			ResourceSet resourceSet = HierarchyResourceSetImpl.getInstance();
			Resource monitorResource = null;

			try {
				monitorResource = resourceSet.getResource(monitor_uri,true);
				PerfmonPlugin.DBG.info("got TRCMonitor resource OK");
				
				new_monitor = false;
				
			} catch (Exception e) {
				monitorResource = resourceSet.createResource(monitor_uri);
				PerfmonPlugin.DBG.info("had to create new TRCMonitor resource");

				monitorroot = hfactory.createTRCMonitor();
				String mname = monitor_uri.toString();
				mname = mname.substring(mname.lastIndexOf("/")+1);
				mname = mname.substring(0,mname.length()-".trcmxmi".length());
				monitorroot.setName(mname);

				try {
					monitorResource.getContents().add(monitorroot);
				} catch (Exception x) {
					PerfmonPlugin.DBG.error("problem adding to monitor resource",x);
				}
			}
			
			EList resources = monitorResource.getContents();
			for (int i = 0; i < resources.size(); i++) {
				Object o = resources.get(i);
				if (o instanceof TRCMonitor) {
					monitorroot = (TRCMonitor)o;
					break;
				}
			}

		} else {
			PerfmonPlugin.DBG.info("TRCMonitor URI not specified - creating new TRCMonitor");
			monitorroot = hfactory.createTRCMonitor();
			monitorroot.setName(tracename);
		}
		

		//timestamps filled in when monitor is saved
		
		//TRCNode setup			
		noderoot = hfactory.createTRCNode();
		noderoot.setMonitor(monitorroot);
		noderoot.setName(rachost);
		noderoot.setRuntimeId("unknown");
		noderoot.setTimezone(0);
		
		//TRCProcessProxy setup			
		pproxyroot = hfactory.createTRCProcessProxy();
		pproxyroot.setNode(noderoot);
		noderoot.getProcessProxies().add(pproxyroot);
		pproxyroot.setActive(true);
		pproxyroot.setPid(-1);
		pproxyroot.setName(PerfmonPlugin.getString("PERFMON_AGENT"));
		
		//TRCAgentProxy setup		
		aproxyroot = hfactory.createTRCAgentProxy();
		aproxyroot.setProcessProxy(pproxyroot);
		pproxyroot.getAgentProxies().add(aproxyroot);
		aproxyroot.setActive(true);
		aproxyroot.setAttached(true);
		aproxyroot.setMonitored(true);
		aproxyroot.setType("Profiler");
		aproxyroot.setName(PerfmonPlugin.getString("PERFMON_AGENT"));
		
		//TRCAgent setup
		agentroot = hfactory.createTRCAgent();
		agentroot.setAgentProxy(aproxyroot);
		agentroot.setName(tracename);
		agentroot.setType("Profiler");

		HierarchyResourceSetImpl resourceSet = HierarchyResourceSetImpl.getInstance();

//		URI project_uri = statcon.getCurrentProjectURI();
		URI project_uri = smodelpath;
		String project_path = project_uri.toString().replaceFirst("platform:/resource/", "");
		
//PerfmonPlugin.DBG.info("PERFMON PATH "+smodelpath);		
//PerfmonPlugin.DBG.info("STATCON PATH "+statcon.getCurrentProjectURI());		
		
		IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();			
/*
//		IPath dummyPath = new Path(project_uri+"/"+"agent-"+Math.random()+"-"+System.currentTimeMillis()+".trcaxmi"); 
		IPath dummyPath = new Path(project_path+"/"+"agent-"+Math.random()+"-"+System.currentTimeMillis()+".trcaxmi"); 
		URI dummyURI = URI.createPlatformResourceURI(workspaceRoot.getFile(dummyPath).getProjectRelativePath().toString());
		Resource dummyResource = resourceSet.createResource(dummyURI);
		dummyResource.getContents().add(agentroot);
*/
		agent = agentroot;
		monitor = monitorroot;
		
		IPath temp = new Path(project_path.toString().replaceFirst("platform:/resource/", "")); 
//		IPath temp = new Path(smodelpath.toString().replaceFirst("platform:/resource/", "")); 
//		IContainer container = workspaceRoot.getFolder(temp);
		
		try
		{
			saveResources();
		}catch (Exception e)
		{
			e.printStackTrace();
		}
		
		PerfmonPlugin.DBG.info("AGENT PROXY URI = "+agent.getAgentProxy().eResource().getURI());
		
	
		MonitorViewUpdate update = new MonitorViewUpdate();
		update.temp = temp;
		Display.getDefault().syncExec(update);
//		PDContentProvider.addMonitor(createContainer(temp), monitor);

	}
	
	class MonitorViewUpdate implements Runnable {
		IPath temp;
		
		public void run() {
			try {
				if (!new_monitor) {
					PDContentProvider.resetMonitors();
				} else {
					PDContentProvider.addMonitor(createContainer(temp), monitor);
				}
			} catch (Throwable e) {
				PerfmonPlugin.DBG.logVisibleError(e,PerfmonPlugin.getString("ERROR_UPDATE_PROFMON"),true);
			}
		}
	}
	
	class ProfileUpdate implements Runnable {
		ProfileEvent event;
		
		public void run() {
			try {
				UIPlugin.getDefault().notifyProfileEventListener(event);
			} catch (Throwable e) {
				PerfmonPlugin.DBG.logVisibleError(e,PerfmonPlugin.getString("ERROR_SEND_PROFILING"),true);
			}
		}
	}
	
	class StatconUpdate1 implements Runnable {
		public void run() {
			try {

				statcon.setConstantUpdate("PERFMON UPDATE "+loader.hashCode(),true,1000);
	
				statcon.addAgent(agent);
	//			statcon.addAgentAction(agent,ACTION_FILTER_COUNTERS,PerfmonPlugin.getString("ACTION_FILTER_COUNTERS"),img.getImage(ImageManager.IMG_PERFMON_START),new FilterCountersAction(loader,agent));
				statcon.addAgentAction(agent,ACTION_STOP_TRACE,PerfmonPlugin.getString("STOP_TRACE"),img.getImage(ImageManager.IMG_PERFMON_STOP),new StopTraceAction(loader,agent));
	//			statcon.addAgentAction(agent,ACTION_SETSMODELPATH,PerfmonPlugin.getString("ACTION_SETSMODELPATH")+" ("+PerfmonStatConModule.uriToHumanReadable(smodelpath)+")", img.getImage(ImageManager.IMG_PERFMON_SAVE), new PerfmonSetPath());
	
				statcon.addModelAction(agent,ACTION_UPDATE_TREE,PerfmonPlugin.getString("UPDATE_TREE"),img.getImage(ImageManager.IMG_PERFMON_UPDATE_TREE),new UpdateTreeAction(loader,agent));
				statcon.addModelAction(agent,ACTION_START_TRACING,PerfmonPlugin.getString("START_TRACING"),img.getImage(ImageManager.IMG_PERFMON_START),new CounterON(loader));
				statcon.addModelAction(agent,ACTION_STOP_TRACING,PerfmonPlugin.getString("STOP_TRACING"),img.getImage(ImageManager.IMG_PERFMON_STOP),new CounterOFF(loader));
	
				configureSliders();
			} catch (Throwable e) {
				PerfmonPlugin.DBG.logVisibleError(e,PerfmonPlugin.getString("ERROR_STATCON_UPDATE")+" (1)",true);
			}
		}
	}

	class StatconUpdate2 implements Runnable {
		public void run() {
			try {
				PerfmonPlugin.DBG.info("Setting requested frequency to "+frequency);
				freq_var.setRequestedValue(System.currentTimeMillis(),frequency);

				PerfmonPlugin.DBG.info("setting up trcagent + variable padder");
				statcon.addAgentChangeListener(PerfmonModuleTrace.this);
					
				statcon.setAgentImage(agent,img.getImage(ImageManager.IMG_PERFMON_START));
				//			statcon.updateAgent(agent);
				
				var_padder = new VariablePadder();
				var_padder.start();	
			} catch (Throwable e) {
				PerfmonPlugin.DBG.logVisibleError(e,PerfmonPlugin.getString("ERROR_STATCON_UPDATE")+" (2)",true);
			}
		}
	}
	
	  /**
     * Insert the method's description here.
     * Creation date: (10/05/2000 10:03:14 AM)
     * @param path com.ibm.itp.common.IPath
     */
    public static final IContainer createContainer(IPath path) {
        IContainer container = null;
        IWorkspace workbench = UIPlugin.getPluginWorkbench();
        int segCount = path.segmentCount();

        for (int idx = 0; idx < segCount; idx++) {
            String seg = path.segment(idx);

            if (idx == 0) { //project

                IProject project = workbench.getRoot().getProject(path.uptoSegment(idx + 1).toString());

                if ((project == null) || !project.exists()) { //create the project

                    try {
                        project.create(null);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                try {
                    project.open(null);
                } catch (Exception e) {
                }

                container = project;
            } else // (idx > 1)
             { //folder

                IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx + 1));

                if ((folder == null) || !folder.exists()) { //create the folder

                    try {
                        folder.create(false, true, null);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                container = folder;
            }
        }

        try {
            container.getProject().refreshLocal(IResource.DEPTH_INFINITE, null);
        } catch (CoreException exc) {
            exc.printStackTrace();
        }

        return container;
    }

	private void redoActions() {
//		statcon.addAgentAction(agent,ACTION_SETSMODELPATH,PerfmonPlugin.getString("ACTION_SETSMODELPATH")+" ("+PerfmonStatConModule.uriToHumanReadable(smodelpath)+")", img.getImage(ImageManager.IMG_PERFMON_SAVE), new PerfmonSetPath());
	}	

	class Init extends Thread {
		String rac_host, reg_host;
		public Init(String rac_host, String reg_host) {
			this.rac_host = rac_host;
			this.reg_host = reg_host;
		}

		public void run() {
//		private void init(String rac_host, String reg_host) {

			if (pmonitor != null) pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_LAUNCHING"));

			try {
				if (reg_host.equalsIgnoreCase(rac_host)) {
					reg_host = "null";	
				}

				HierarchyFactory hfactory = HierarchyFactory.eINSTANCE;
			
				long started = System.currentTimeMillis();

				String host = rac_host;
				int port = 10002;
				String reg_host_name = reg_host;

				if (reg_host_name.equalsIgnoreCase("null")) {
					reg_host_name = host;	
				} else {
					if (!reg_host.startsWith("\\\\")) {
						reg_host = "\\\\" + reg_host;	
					}
				}
				
				tracename = "Perfmon "+PerfmonPlugin.getString("TRACE")+" - "+reg_host_name+" ("+host+") "+smodel_sdf.format(new Date(started));
				String modelname = "Perfmon "+PerfmonPlugin.getString("HOST_TRACE")+" - "+smodel_sdf.format(new Date(started));

				createTRCAgent(tracename);

				PerfmonPlugin.DBG.info("Creating variable loader");

				//
				// Create this early on so that the controls appear at the top
				//
				SDVariableLoader varloader = null;
				if (statcon != null) varloader = new SDVariableLoader(agent,PerfmonPlugin.getString("PERFMON_CONTROLS"));

//				agent = hfactory.createTRCAgent();
//				agent.setName(tracename);

				AgentUpdateThread agentupdate = null;
				if (statcon != null) {
					agentupdate = new AgentUpdateThread(agent);
					agentupdate.start(); 
				}

				if (USE_CUSTOM_LOADER) {
					loader = new PerfmonCustomLoader(started,agent,modelname,host,port,reg_host,(int)(1000.0*frequency));
				} else {
					loader = new PerfmonGenericLoader(pmonitor,started,agent,modelname,host,port,reg_host,(int)(1000.0*frequency));
				}

				if (statcon != null) loader.addLoaderListener(agentupdate);

				if (pmonitor != null) pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CONFIGURING"));

				ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
				event.setSource(agent.getAgentProxy());
				event.setType(ProfileEvent.START_MONITOR);
				ProfileUpdate update = new ProfileUpdate();
				update.event = event;
				Display.getDefault().syncExec(update);
//				UIPlugin.getDefault().notifyProfileEventListener(event);

				if (statcon != null) {

					PerfmonPlugin.DBG.info("Creating frequency variable");
					freq_var = varloader.createSDModifiableVariable(
												"PERFMON#FREQUENCY",
												PerfmonPlugin.getString("FREQUENCY_SEC"),
												PerfmonPlugin.getString("FREQUENCY_DESCRIPTION"),
												null,
												false,
												SDMeasuredVariable.DOUBLE,
												SDModifiableVariable.DOUBLE,
												PerfmonPlugin.getString("FREQUENCY"),
												PerfmonPlugin.getString("PERFMON_CONTROLS"),
												PerfmonModuleTrace.this,
												0.5d,
												Double.MAX_VALUE
												);
												
					
					Display.getDefault().syncExec(new StatconUpdate1());

					Display.getDefault().syncExec(new StatconUpdate2());
					
				}
				Display.getDefault().asyncExec(new SliderFollow());

				//progress monitor done
				if (pmonitor != null) pmonitor.done();

			} catch (Throwable t) {
				//progress monitor done
				if (pmonitor != null) pmonitor.done();

				PerfmonPlugin.DBG.logVisibleError(t,PerfmonPlugin.getString("ERROR_STARTING_TRACE"),true);
			}
		}
	}
	
	class SliderFollow implements Runnable {
		public void run() {
			if (statcon != null) {
				statcon.getGraphWindow().setTimeSliderFollowing(statcon.getGraphWindow().getXSlider(0),true);
			}
		}
	}
	
	class VariablePadder extends Thread {
		boolean die = false;
		public void run() {
			while (!die) {
				try {
					Thread.sleep(750);	
				} catch (Exception e) {
				}
				try {
					freq_var.padRequestedValue(System.currentTimeMillis());
					freq_var.setMeasuredValue(System.currentTimeMillis(),freq_var.getLastMeasuredValue());	
				} catch (Exception e) {
					PerfmonPlugin.DBG.warning("unable to pad variable requested and measured - "+e);
				}
			}
		}
	}

	class UpdateTreeAction implements Runnable {
		PerfmonLoader loader;
		TRCAgent agent;
		public UpdateTreeAction(PerfmonLoader loader, TRCAgent agent) {
			this.loader = loader;
			this.agent = agent;
		}
		public void run() {
			try {
				SDDescriptor selected = statcon.getSelectedDescriptor();
				loader.getUpdatedTree(selected);
			} catch (IOException e) {
				PerfmonPlugin.DBG.logVisibleError(e,PerfmonPlugin.getString("ERROR_UPDATE_TREE"),false);	
			}
		}	
	}

/*
HashMap filters = new HashMap();
	class FilterCountersAction implements Runnable {
		PerfmonLoader loader;
		TRCAgent agent;
		public FilterCountersAction(PerfmonLoader loader, TRCAgent agent) {
			this.loader = loader;
			this.agent = agent;
		}
		public void run() {
			PerfmonPlugin.DBG.info("filter counters");
			EList models = agent.getDescriptor();
			for (int i = 0; i < models.size(); i++) {
				SDDescriptor des = (SDDescriptor)models.get(i);
				if (des != null) {
					Boolean filter = (Boolean)filters.get(des);
					if (filter == null) {
						//default to showing new counters
						filters.put(des,new Boolean(true));	
					}
				}
			}
			
			//TODO start up a dialog that gets new set of filters from the user
			PerfmonFilterDialog dialog = new PerfmonFilterDialog(statcon.getGraphWindow().getShell(),filters);
			dialog.open();
			HashMap map = dialog.getFilters();
			
			if (map != null) {
				
				ArrayList list = new ArrayList();
				list.addAll(map.keySet());
				
				for (int i = 0; i < list.size(); i++) {
					SDDescriptor des = (SDDescriptor)list.get(i);
					boolean on = ((Boolean)map.get(des)).booleanValue();
					
					if (!on) {
//						PerfmonPlugin.DBG.warning("Set "+des.getName()+" agent to NULL");
						des.setAgent(null);
					} else {
						des.setAgent(agent);
					}	

					statcon.updateModel(des);				
				}

				filters = map;
				System.err.println("FILTER MAP = "+filters.hashCode());						
			}
			
		}	
	}
*/

	class StopTraceAction implements Runnable {
		PerfmonLoader loader;
		TRCAgent agent;
		public StopTraceAction(PerfmonLoader loader, TRCAgent agent) {
			this.loader = loader;
			this.agent = agent;
		}
		public void run() {
			unloadTrace();
			
			try {
				saveStatisticalModel();
			} catch (Exception e) {
				PerfmonPlugin.DBG.error("problem saving statistical model",e);
			}
			try {
				loader.killProcess();
			} catch (Exception e) {
				PerfmonPlugin.DBG.error("problem killing perfmon process",e);
			}
		}	
	}


	class CounterON implements Runnable {
		PerfmonLoader loader;
		public CounterON(PerfmonLoader loader) {
			this.loader = loader;	
		}
		public void run() {
			//this should recursively turn on / off subchildren too
			//and it should set the images in StatCon
			try {
				//turn it and all its children on
				applyDown(statcon.getSelectedDescriptor());
				//turn on its parents
				applyUp(statcon.getSelectedDescriptor());
			} catch (Exception e) {
				PerfmonPlugin.DBG.error("unable to set counter to ON",e);	
			}
		}
		void apply(SDDescriptor descriptor) throws IOException {
			try {
				loader.counterON(descriptor);
			} catch (NullPointerException e) {}	//descriptor not found (root)
			statcon.setDescriptorImage(descriptor,img.getImage(ImageManager.IMG_PERFMON_START));
		}
		void applyUp(SDDescriptor descriptor) throws IOException {
			SDDescriptor parent = descriptor.getParent();
			if (parent != null) {
				apply(parent);
				applyUp(parent);					
			}	
		}
		void applyDown(SDDescriptor descriptor) throws IOException {
			apply(descriptor);
			List children = descriptor.getChildren();
			for (int i = 0; i < children.size(); i++) {
				applyDown((SDDescriptor)children.get(i));
			}
		}
	}
	
	class CounterOFF implements Runnable {
		PerfmonLoader loader;
		public CounterOFF(PerfmonLoader loader) {
			this.loader = loader;	
		}
		public void run() {
			try {
				apply(statcon.getSelectedDescriptor());
			} catch (Exception e) {
				PerfmonPlugin.DBG.error("unable to set counter to ON",e);	
			}
		}
		void apply(SDDescriptor descriptor) throws IOException {
			loader.counterOFF(descriptor);
			statcon.setDescriptorImage(descriptor,img.getImage(ImageManager.IMG_PERFMON_STOP));
			List children = descriptor.getChildren();
			for (int i = 0; i < children.size(); i++) {
				apply((SDDescriptor)children.get(i));
			}
		}
	}

	class PerfmonSetPath implements Runnable {
		public void run() {
			PerfmonPlugin.DBG.info("set test model save path");

			IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
			Path container_savepath = null;
			IContainer container = null;
			try {
				container_savepath = new Path(""+smodelpath);
				container = workspaceRoot.getFolder(container_savepath);
			} catch (Throwable e) {
				PerfmonPlugin.DBG.warning("could not find valid IContainer for model save path");
			}

			PerfmonPlugin.DBG.info("showing container selection dialog");
			//pop up a dialog	
			ContainerSelectionDialog dialog = null;
			dialog = new ContainerSelectionDialog(statcon.getGraphWindow().getShell(), container, false, PerfmonPlugin.getString("SMODEL_SELECT_PATH_DESCRIPTION"));
			dialog.open();
			Object[] result = dialog.getResult();

			if (result != null) {			
				if (result.length > 0) {

					Path container_path = (Path)result[0];
					URI savepath = URI.createPlatformResourceURI(container_path.toString());

					smodelpath = savepath;

					PerfmonPlugin.DBG.info("updating menuitems to reflect new model save path");
					
					redoActions();
					statcon.setDirty(true);
				}
			}
		}
			
	}

	class ListUpdate extends Thread {
		ArrayList items;
		public ListUpdate(ArrayList items) {
			this.items = items;
		}
		public void run() {
			try {
				for (int i = 0; i < items.size(); i++) {
					Object o = items.get(i);
					if (o instanceof SDDescriptor) {
						statcon.updateModel((SDDescriptor)o);
					} else if (o instanceof TRCAgent) {
						statcon.updateAgent((TRCAgent)o);
						//we exit here because updating the agent updates everything
						return;
					}
				}
				
			} catch (Throwable t) {
				PerfmonPlugin.DBG.warning("couldnt update perfmon agent "+t);	
			}	
		}	
	}

	class AgentUpdateThread extends Thread implements StatisticalLoaderListener {
		public boolean die;
		TRCAgent agent;
		
		Object list_lock = new Object();
		ArrayList descriptor_updates = new ArrayList();
		HashMap descriptor_map = new HashMap();
		ArrayList agent_updates = new ArrayList();
		
		public AgentUpdateThread(TRCAgent trcagent) {
			this.agent = trcagent;
		}
		public void modelChanged(SDDescriptor des) {
//			SDDescriptor parent = des.getParent();
			SDDescriptor parent = des;
			synchronized(list_lock) {

				if (parent == null) {
					if (agent_updates.size() == 0) {
						agent_updates.add(agent);
					}
				} else {
					
					if (descriptor_map.get(parent) != null) {
						return;	
					}
					
					SDDescriptor tmp = parent.getParent();
					while (tmp != null) {
						if (descriptor_map.get(tmp) != null) {
//						if (descriptor_updates.contains(tmp)) {
							//its parent is there - no need to update it
							return;
						}
						tmp = tmp.getParent();
					}
					
					descriptor_updates.add(parent);
					descriptor_map.put(parent,parent);
				}

			}
		}
		
		private void collapse() {
			synchronized(list_lock) {
				
				if (agent_updates.size() > 0) {
//PerfmonPlugin.DBG.info("WHOLE AGENT UPDATE");					
					return;	
				}
				
				//lots of changes - might as well update the whole tree
				if (descriptor_updates.size() > 350) {
//PerfmonPlugin.DBG.info(descriptor_updates.size()+" DESCRIPTORS - WHOLE AGENT UPDATE");					
					agent_updates.add(agent);
					return;
				}

//PerfmonPlugin.DBG.info(descriptor_updates.size()+" DESCRIPTORS - COLLAPSING");					
				
				for (int i = 0; i < descriptor_updates.size(); i++) {
					SDDescriptor descriptor = (SDDescriptor)descriptor_updates.get(i);
	
					SDDescriptor tmp = descriptor.getParent();
					while (tmp != null) {
						if (descriptor_map.get(tmp) != null) {
//						if (descriptor_updates.contains(tmp)) {
							//its parent is there - no need to update it
							descriptor_updates.remove(i--);
							descriptor_map.remove(tmp);
							break;
						}
						tmp = tmp.getParent();
					}
				}	

//PerfmonPlugin.DBG.info(descriptor_updates.size()+" DESCRIPTORS - UPDATING");					
				
			}
		}
		
		public void run() {
			while (!die) {
				try {
					Thread.sleep(1000);	
				} catch (Exception e) {
				}

				synchronized(list_lock) {

					collapse();

//@@@agent_updates.add(agent);

					//if we are updating the agent, dont bother with its models
					if (agent_updates.size() > 0) {
						statcon.getGraphWindow().getDisplay().syncExec(new ListUpdate(agent_updates));
	
					//update bits of the agent's models
					} else if (descriptor_updates.size() > 0) {
						statcon.getGraphWindow().getDisplay().syncExec(new ListUpdate(descriptor_updates));
					}
					descriptor_updates = new ArrayList();
					descriptor_map = new HashMap();
					agent_updates = new ArrayList();
					
				}	
			}	
		}	
	}
		
}