/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;

/**
 * A sample item that appears under every EMF object in the
 * Profiling Monitor navigator. The items can be opened with
 * the package statistics view, and will contain the same
 * content as their parent.
 */
public class SampleItem implements INavigatorItem {
	private static final String TYPE = "Sample";
	
	private static Image _image;
	private Object _parent;
	
	public SampleItem(Object parent) {
		_parent = parent;
	}
	
	public void delete(boolean referentialIntegrity, boolean deleteContents) {
		SampleItemRegistry.removeChild(_parent, this);
		_parent = null;
	}

	/*
	 * The navigator looks for IAdaptables that have
	 * IWorkbenchAdapters. If present, they are used for
	 * content. 
	 */
	public Object getAdapter(Class adapter) {
		if (IWorkbenchAdapter.class.equals(adapter)) {
			return new WorkbenchAdapter() {
				public Object[] getChildren(Object object) {
					return SampleItem.this.getChildren().toArray();
				}
				public ImageDescriptor getImageDescriptor(Object object) {
					return SampleItem.this.getImageDescriptor();
				}
				public String getLabel(Object object) {
					return SampleItem.this.getText();
				}
				public Object getParent(Object object) {
					return SampleItem.this.getParent();
				}
			};
		}
		else
			return null;
	}
	
	// no children
	public List getChildren() {
		return new ArrayList();
	}
	
	// repeat the parent's data
	public Object getData() {
		return _parent;
	}
	
	public Image getImage() {
		if (_image == null) {
			_image = getImageDescriptor().createImage();
			Display.getDefault().addListener(SWT.Dispose, new Listener() {
				public void handleEvent(Event event) {
					_image.dispose();
				}
			});
		}
		return _image;
	}

	private ImageDescriptor getImageDescriptor() {
		URL url = SamplePlugin.getDefault().find(new Path("icons/full/obj16/sample.gif"));
		return ImageDescriptor.createFromURL(url);
	}
	
	public Object getParent() {
		return _parent;
	}

	// the text displayed in the label
	public String getText() {
		return SamplePlugin.getResourceString("NAVIGATOR_EXTENSION_ITEM_LABEL");
	}
	
	public String getType() {
		return TYPE;
	}
	
	// no children
	public boolean hasChildren() {
		return false;
	}
	
	public boolean isDeleteEnabled() {
		return true;
	}
	
	// non-persistent; can't be saved
	public boolean isSaveEnabled() {
		return false;
	}
	
	public boolean isUnloadEnabled() {
		return false;
	}
	
	// not enabled
	public void save(boolean referentialIntegrity) {
	}
	
	// not enabled
	public void unload(boolean referentialIntegrity) {
	}
}
