/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.editors;

import org.eclipse.emf.ecore.*;
import org.eclipse.hyades.models.internal.sdb.*;
import org.eclipse.hyades.sdb.internal.*;
import org.eclipse.hyades.sdb.internal.help.*;
import org.eclipse.hyades.sdb.internal.util.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.help.*;

public class DBDetails extends Composite implements IDetails, Listener {

	private Text txtDBName;
	private Text txtURL;
	private Text txtExtLocation;
	private Text txtDescription;
    private boolean isDisplaying = false;
    private SymptomDBEditor editor; 
    private SDBRuntime currentSel = null;
	
	
	public DBDetails(RASWidgetFactory factory, Composite composite, int style){

		super(composite, style);

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 1;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		
		Label lblDBName = factory.createLabel(this, SDbPlugin.getResourceString("STR_SYPMTOMDBNAME_LABEL"), SWT.NONE);
	
		txtDBName = factory.createText(this, "", SWT.NONE);
		txtDBName.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
		txtDBName.setData(new Integer(0));
			
		Label lblURL = factory.createLabel(this, SDbPlugin.getResourceString("STR_URL_LABEL"),SWT.NONE);
	
		txtURL = factory.createText(this, "", SWT.NONE);
		txtURL.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		txtURL.setData(new Integer(1));
	
		Label lblExtLocation = factory.createLabel(this,SDbPlugin.getResourceString("STR_EXTERNALLOC_LABEL"),SWT.NONE);
		txtExtLocation = factory.createText(this, "",SWT.NONE);
		txtExtLocation.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		txtExtLocation.setData(new Integer(2));
	
		Label lblDescription = factory.createLabel(this,SDbPlugin.getResourceString("STR_DESCRIPTION_LABEL"),SWT.NONE);
		txtDescription = factory.createText(this, "",SWT.NONE|SWT.V_SCROLL|SWT.H_SCROLL | SWT.MULTI);
		GridData descLayout =  new GridData(GridData.FILL_BOTH);
		//descLayout.heightHint = 45;
		//descLayout.verticalSpan = 3;	
		txtDescription.setLayoutData(descLayout);
		txtDescription.setData(new Integer(3));
		
		WorkbenchHelp.setHelp(txtDBName, ContextIds.SYMDB_EDITOR_DETAILS_NAME);
		WorkbenchHelp.setHelp(txtURL, ContextIds.SYMDB_EDITOR_DETAILS_URL);
		WorkbenchHelp.setHelp(txtExtLocation, ContextIds.SYMDB_EDITOR_DETAILS_LOCATION);
		WorkbenchHelp.setHelp(txtDescription, ContextIds.SYMDB_EDITOR_DETAILS_DESCRIPTION);

		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
		txtDBName.addListener(SWT.Modify, this);
		txtURL.addListener(SWT.Modify, this);
		txtExtLocation.addListener(SWT.Modify, this);
		txtDescription.addListener(SWT.Modify, this);
		
	}
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {

		currentSel = (SDBRuntime)object;
		isDisplaying = true;
		txtDBName.setText(currentSel.getName()==null?"":currentSel.getName());
		txtURL.setText(currentSel.getSymptomUrl()==null?"":currentSel.getSymptomUrl());
		txtExtLocation.setText(currentSel.getLocalExternalFileLocation()==null?"":currentSel.getLocalExternalFileLocation());
		txtDescription.setText(currentSel.getDescription()==null?"":currentSel.getDescription());
		isDisplaying = false;
	}

    public void init(SymptomDBEditor editor){
		this.editor = editor;
    }

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {

		currentSel = (SDBRuntime)currentSelection;
		currentSel.setName(txtDBName.getText());
		currentSel.setSymptomUrl(txtURL.getText());
		currentSel.setLocalExternalFileLocation(txtExtLocation.getText());
		currentSel.setDescription(txtDescription.getText());
		return false;

	}
	
	public void setFocusToTextBox(){
	        txtDBName.setFocus();
	        txtDBName.setSelection(0, txtDBName.getText().length());
	}

	/**
	 * @see Listener#handleEvent(Event)
	 */
	public void handleEvent(Event event) {
    	Widget source = event.widget;
		boolean status = false;

    	if(currentSel!=null && isDisplaying==false){
    		switch(((Integer)source.getData()).intValue()){
    			case 0: status = editor.validateState(txtDBName, this, currentSel.getName()==null?"":currentSel.getName());
    					break;
    			case 1: status = editor.validateState(txtURL, this, currentSel.getSymptomUrl()==null?"":currentSel.getSymptomUrl());
    					break;
				case 2: status = editor.validateState(txtExtLocation, this, currentSel.getLocalExternalFileLocation()==null?"":currentSel.getLocalExternalFileLocation());
						break;
				case 3: status = editor.validateState(txtDescription, this, currentSel.getDescription()==null?"":currentSel.getDescription());
						break;
    		}
			
			if(status){
	    		editor.updateUIDirtyStatus(true);
				editor.updateModelDirtyStatus(true);
    		}

    	}


	}
	
}
