/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;

public class ProfileBasePreferencePage
	extends PreferencePage
	implements IWorkbenchPreferencePage {

	private TraceCollectionPreferencePage _collections;
	
	/**
	 * Constructor for ProfileBasePreferencePage.
	 */
	public ProfileBasePreferencePage() {
		super();
		setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());
	}
	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		UIPlugin.getPluginId()+".pbpp0000");
		
		Composite composite = new Composite(parent, SWT.NONE);

		GridData data = GridUtil.createFill();
		data.heightHint = 100;
		composite.setLayoutData(data);
		GridLayout layout = new GridLayout();
		layout.marginWidth = 10;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);

		_collections = new TraceCollectionPreferencePage(getPreferenceStore(),this);
		_collections.createContents(composite);

		return composite;
	}
	/**
	 * @see IWorkbenchPreferencePage#init(IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		super.performDefaults();
		_collections.performDefaults();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		_collections.performOk();
		return true;
	}
}
