/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.launcher;

import org.eclipse.hyades.models.hierarchy.*;


/**
 * 
 * Launcher Handler Type Interface
 * Related to the launcherHandler schema.
 * Classes implementing this interface are given control to the agent
 * and the process proxy during various points throughout the launch/attach
 * scenario.
 * They can set and get properties midway through a profile.
 **/
public interface ILauncherHandler{

	/**
	 * 
	 * @param processProxy
	 * invoked when the process proxy is created and launched
	 */
	public void handleProcessLaunched(TRCProcessProxy processProxy);
	
	/**
	 * 
	 * @param processProxy
	 * invoked immediately before the process proxy is destroyed
	 */
	public void handleProcessExited(TRCProcessProxy processProxy);
	
	/**
	 * @param agentProxy
	 * invoked immediately before the agent resumes
	 */
	public void handlePreAgentActive(TRCAgentProxy agentProxy);
	
	/**
	 * invoked immediately after the agent has resumed
	 * @param agentProxy
	 */
	public void handlePostAgentActive(TRCAgentProxy agentProxy);
	
	/**
	 * invoked immediately before the agent becomes inactive
	 * @param agentProxy
	 */
	public void handleAgentInactive(TRCAgentProxy agentProxy);
	
	
	}

