/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal;

import org.eclipse.emf.common.util.URI;
/**
 * This exception is thrown if a resource is already in the database and you
 * attempt to add it again.
 */
public class ResourceAddedException extends Exception {
	protected URI uri;

	/**
	 * Constructor for ResourceAddedException.
	 */
	public ResourceAddedException(URI uri) {
		super();
		this.uri = uri;
	}

	/**
	 * The URI of the resource that was already added.
	 */
	public URI getURI() {
		return uri;
	}
} // ResourceAddedException
