/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.dbmodel.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Constraint;
import org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage;
/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Constraint</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.ConstraintImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.impl.ConstraintImpl#getColumns <em>Columns</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ConstraintImpl extends DBElementImpl implements Constraint {
	/**

	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see #getType()

	 * @generated

	 * @ordered

	 */

	protected static final String TYPE_EDEFAULT = null;

	/**

	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see #getType()

	 * @generated

	 * @ordered

	 */

	protected String type = TYPE_EDEFAULT;

	/**

	 * The cached value of the '{@link #getColumns() <em>Columns</em>}' reference list.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see #getColumns()

	 * @generated

	 * @ordered

	 */

	protected EList columns = null;

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	protected ConstraintImpl() {
		super();

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	protected EClass eStaticClass() {
		return DbmodelPackage.eINSTANCE.getConstraint();

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public String getType() {
		return type;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void setType(String newType) {
		String oldType = type;

		type = newType;

		if (eNotificationRequired())

			eNotify(new ENotificationImpl(this, Notification.SET, DbmodelPackage.CONSTRAINT__TYPE, oldType, type));

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EList getColumns() {
		if (columns == null) {
			columns = new EObjectWithInverseResolvingEList.ManyInverse(Column.class, this, DbmodelPackage.CONSTRAINT__COLUMNS, DbmodelPackage.COLUMN__CONSTRAINTS);

		}

		return columns;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case DbmodelPackage.CONSTRAINT__COLUMNS :

					return ((InternalEList) getColumns()).basicAdd(otherEnd, msgs);

				default :

					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);

			}

		}

		if (eContainer != null)

			msgs = eBasicRemoveFromContainer(msgs);

		return eBasicSetContainer(otherEnd, featureID, msgs);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case DbmodelPackage.CONSTRAINT__COLUMNS :

					return ((InternalEList) getColumns()).basicRemove(otherEnd, msgs);

				default :

					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);

			}

		}

		return eBasicSetContainer(null, featureID, msgs);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.CONSTRAINT__NAME :

				return getName();

			case DbmodelPackage.CONSTRAINT__TYPE :

				return getType();

			case DbmodelPackage.CONSTRAINT__COLUMNS :

				return getColumns();

		}

		return eDynamicGet(eFeature, resolve);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.CONSTRAINT__NAME :

				setName((String) newValue);

				return;

			case DbmodelPackage.CONSTRAINT__TYPE :

				setType((String) newValue);

				return;

			case DbmodelPackage.CONSTRAINT__COLUMNS :

				getColumns().clear();

				getColumns().addAll((Collection) newValue);

				return;

		}

		eDynamicSet(eFeature, newValue);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.CONSTRAINT__NAME :

				setName(NAME_EDEFAULT);

				return;

			case DbmodelPackage.CONSTRAINT__TYPE :

				setType(TYPE_EDEFAULT);

				return;

			case DbmodelPackage.CONSTRAINT__COLUMNS :

				getColumns().clear();

				return;

		}

		eDynamicUnset(eFeature);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DbmodelPackage.CONSTRAINT__NAME :

				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);

			case DbmodelPackage.CONSTRAINT__TYPE :

				return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);

			case DbmodelPackage.CONSTRAINT__COLUMNS :

				return columns != null && !columns.isEmpty();

		}

		return eDynamicIsSet(eFeature);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());

		result.append(" (type: ");

		result.append(type);

		result.append(')');

		return result.toString();

	}

} //ConstraintImpl

