/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

/**
 * An element with differently typed properties.
 * Changing a property sends out a DomainEvent.
 */
public class RecordTableElement
{
	protected String fName;
	protected String fValue;

	/**
	 * Initialize a new TestElement from the given data.
	 */
	public RecordTableElement(String name, String value)
	{
		fName = name; 		
		fValue = value;
		
		if(fValue == null)
		  fValue = "";      
		
	}
	public String getName() {
		return fName;
	}
	public String getValue() {
		return fValue;
	}
	public void setName(String name) {
		fName = name;
	}
	public void setValue(String value) {
		fValue = value;
	}
}
