/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.execution.local;

import java.util.Enumeration;
import java.util.Hashtable;

import org.eclipse.hyades.execution.core.ISession;

/**
 * This class is used by HyadesSessionImpl and 
 * TestExecutionHarness to facilitate reuse of Sessions.  
 * */
public class SessionContextToSessionMap {

	// We need an instance so we can pass it as an interface to the value
	// classes as
	private static SessionContextToSessionMap myself = new SessionContextToSessionMap();
	SessionContextToSessionMap() {
	}

	private static Hashtable sessionFromContext = new Hashtable();
	
	public static void addSession(SessionContext ctx, ISession session){
		sessionFromContext.put(ctx, session);
	}
	
	public static void removeSession(SessionContext ctx){
		sessionFromContext.remove(ctx);
	}

	public static ISession getSession(SessionContext ctx){
		return (ISession) sessionFromContext.get(ctx);
	}
	
	public static boolean removeSession(ISession session){
		Enumeration enum = sessionFromContext.keys();
		SessionContext ctx = null;
		// TODO is this safe to remove element while enumerating?
		while(enum.hasMoreElements()){
			ctx = (SessionContext) enum.nextElement();
			ISession value = getSession(ctx);
			if (value != null){
				if (value.equals(session)){
					removeSession(ctx);
					break;				
				}
			}
		}
		return false;
	}
}
