/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.file;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

import org.eclipse.hyades.execution.security.IConnectionHandler;
import org.eclipse.hyades.internal.execution.local.common.Constants;

/**
 * @author Giridhar.S
 *
 * This is the file server class which is instantiated from RAC during startup, and listens for 
 * incoming file transfer requests from clients, and creates client handlers for each client requests.
 * The client handlers perform the actual file transfer.
 * 
 */
public class FileServer implements Runnable,FileServiceConstants, Constants {
	/**
	 * members
	 */
	/* The port on which the file server listens for incoming requests. Default = 10005 */
	private int port ,result = -1;
	
	/* The server socket on which the server listens for requests from clients */
	private ServerSocket serverSocket;

	/* The single file connection handler, which accepts recieves client information and
	 * passes these to a file client handler which does the file processing */	
	private IConnectionHandler connHandler ;
	
	public FileServer() {
		super();
	}
	
	/**
	 * Method to initialize file server with parameters.
	 * @param ifsp - FileServerParametersImpl object containing required information.
	 */
	/* The init method is called from native code (RAC) */
	
	public void init(IFileServerParameters ifsp)	{
		/* We get references to FileConnectionHandlerImpl and the configured file transfer port*/
		connHandler=ifsp.getConnectionHandler();
		port=ifsp.getPort();
	}
	
	/*
	 * The file server just listens for incoming requests on the configured port.
	 * 
	 */
	
	public void run() {
		
		try {
			serverSocket = new ServerSocket(port);
			
			/* Run forever */
			while (true){
				try {
					Socket newSocket = serverSocket.accept();							/* Wait for client requests */
					connHandler.connectionAccepted(newSocket);
				}
				catch (IOException e)	{
					/* Ignore this */
				}
			}
		}
		
		catch (IOException e1) {
			e1.printStackTrace();
		}
	}
	
	/* Quit method called from RAC */
	public synchronized void quit()	{
		try {
			serverSocket.close();
		} catch (IOException e) {
			/* Is this necessary? */
		}
	}
}