/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.file;

import java.net.Socket;

import org.eclipse.hyades.execution.security.IConnectionHandler;

/**
 * @author Giridhar.S
 * 
 * A connection handler class for file transfer.
 *
 */
public interface IFileConnectionHandler extends IConnectionHandler {
	
	/**
	 * A method which accepts the connected socket, and performs required operations 
	 * on the parameters passed.
	 *  
	 * @param s
	 * @param operation
	 * @param fileName
	 */
	public void connectionAccepted (Socket s, long operation, String fileName);
}
