/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.invocation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.hyades.execution.invocation.CallData;
import org.eclipse.hyades.execution.invocation.RemoteReferenceInputStream;
import org.eclipse.hyades.execution.invocation.RemoteReferenceOutputStream;
import org.eclipse.hyades.execution.invocation.ReturnData;

public class Marshaller {
    private static final int RETURN_VALUE_IN_STREAM = 88;
    private static final int RETURN_VALUE_NOT_IN_STREAM = 188;
    private static HashMap instanceMap = new HashMap();
    private static ArrayList returnValueQueue = new ArrayList();

    private Marshaller() throws IOException {
    }

    public static void addInstanceToMap(Integer n, Object object) {
        HashMap hashMap = instanceMap;
        synchronized (hashMap) {
            instanceMap.put(n, object);
        }
    }

    public static Object getInstanceFromMap(Integer n) {
        Object var1_1 = null;
        HashMap hashMap = instanceMap;
        synchronized (hashMap) {
            var1_1 = instanceMap.get(n);
        }
        return var1_1;
    }

    public static void removeInstanceFromMap(Integer n) {
        HashMap hashMap = instanceMap;
        synchronized (hashMap) {
            if (instanceMap.containsKey(n)) {
                Object v = instanceMap.get(n);
                instanceMap.remove(v);
            }
        }
    }

    public static byte[] marshalMethodCall(CallData callData) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        RemoteReferenceOutputStream remoteReferenceOutputStream = new RemoteReferenceOutputStream(byteArrayOutputStream);
        remoteReferenceOutputStream.writeInt(callData.getTargetId());
        remoteReferenceOutputStream.writeObject(callData.getArgTypes());
        remoteReferenceOutputStream.writeObject(callData.getCallArgs());
        remoteReferenceOutputStream.writeObject(callData.getCall());
        remoteReferenceOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static CallData unmarshalMethodCall(byte[] byArray) throws IOException, ClassNotFoundException {
        RemoteReferenceInputStream remoteReferenceInputStream = new RemoteReferenceInputStream(new ByteArrayInputStream(byArray));
        Object object = null;
        int n = remoteReferenceInputStream.readInt();
        object = remoteReferenceInputStream.readObject();
        if (!(object instanceof Class[])) {
            throw new ClassCastException("Expected an Class[] but got \"" + object.getClass().getName() + "\"");
        }
        Class[] classArray = (Class[])object;
        object = remoteReferenceInputStream.readObject();
        if (!(object instanceof Object[])) {
            throw new ClassCastException("Expected an Object[] but got \"" + object.getClass().getName() + "\"");
        }
        Object[] objectArray = (Object[])object;
        object = remoteReferenceInputStream.readObject();
        if (!(object instanceof String)) {
            throw new ClassCastException("Expected a String but got \"" + object.getClass().getName() + "\"");
        }
        String string = (String)object;
        return new CallData(new Integer(n), classArray, objectArray, string);
    }

    public static byte[] marshalReturnValue(ReturnData returnData) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        RemoteReferenceOutputStream remoteReferenceOutputStream = new RemoteReferenceOutputStream(byteArrayOutputStream);
        remoteReferenceOutputStream.writeInt(returnData.getTargetId());
        remoteReferenceOutputStream.writeObject(returnData.getArgTypes());
        remoteReferenceOutputStream.writeObject(returnData.getCall());
        if (returnData.getReturnValue() != null) {
            remoteReferenceOutputStream.writeInt(88);
            remoteReferenceOutputStream.writeObject(returnData.getReturnValue());
        } else {
            remoteReferenceOutputStream.writeInt(188);
        }
        remoteReferenceOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static ReturnData unmarshalReturnValue(byte[] byArray) throws IOException, ClassNotFoundException {
        RemoteReferenceInputStream remoteReferenceInputStream = new RemoteReferenceInputStream(new ByteArrayInputStream(byArray));
        Object object = null;
        int n = remoteReferenceInputStream.readInt();
        object = remoteReferenceInputStream.readObject();
        if (!(object instanceof Class[])) {
            throw new ClassCastException("Expected an Class[] but got \"" + object.getClass().getName() + "\"");
        }
        Class[] classArray = (Class[])object;
        object = remoteReferenceInputStream.readObject();
        if (!(object instanceof String)) {
            throw new ClassCastException("Expected a String but got \"" + object.getClass().getName() + "\"");
        }
        String string = (String)object;
        int n2 = remoteReferenceInputStream.readInt();
        Object object2 = null;
        if (n2 == 88) {
            object2 = remoteReferenceInputStream.readObject();
        }
        return new ReturnData(new Integer(n), classArray, string, object2);
    }

    public static void queueReturnValue(ReturnData returnData) {
        ArrayList arrayList = returnValueQueue;
        synchronized (arrayList) {
            returnValueQueue.add(returnData);
            returnValueQueue.notifyAll();
        }
    }

    public static ReturnData unqueueReturnValue() {
        ReturnData returnData = null;
        ArrayList arrayList = returnValueQueue;
        synchronized (arrayList) {
            if (!returnValueQueue.isEmpty()) {
                returnData = (ReturnData)returnValueQueue.remove(0);
            }
        }
        return returnData;
    }

    public static ReturnData peekReturnValue() {
        ReturnData returnData = null;
        ArrayList arrayList = returnValueQueue;
        synchronized (arrayList) {
            if (!returnValueQueue.isEmpty()) {
                returnData = (ReturnData)returnValueQueue.get(0);
            }
        }
        return returnData;
    }

    public static boolean isReturnDataAvailable() {
        boolean bl = false;
        ArrayList arrayList = returnValueQueue;
        synchronized (arrayList) {
            bl = !returnValueQueue.isEmpty();
        }
        return bl;
    }

    public static void waitForReturnData() {
        while (!Marshaller.isReturnDataAvailable()) {
            try {
                ArrayList arrayList = returnValueQueue;
                synchronized (arrayList) {
                    returnValueQueue.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

