/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.java;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.core.IExternalizableToXml;
import org.eclipse.hyades.logging.events.CbeFormatter;
import org.eclipse.hyades.logging.events.IAssociatedEvent;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.IContextDataElement;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.IMsgDataElement;

public class CommonBaseEventLogRecord
extends LogRecord
implements IExternalizableToXml {
    private ICommonBaseEvent commonBaseEvent = null;

    public CommonBaseEventLogRecord(Level level, String string) {
        super(level, string);
    }

    public CommonBaseEventLogRecord(Level level) {
        super(level, "");
    }

    public long getMillis() {
        long l = this.getCreationTimeInMillis(this.commonBaseEvent);
        return l;
    }

    public String getMessage() {
        if (this.commonBaseEvent == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.commonBaseEvent.getMsg();
        String string2 = null;
        IMsgDataElement iMsgDataElement = this.commonBaseEvent.getMsgDataElement();
        if (iMsgDataElement != null) {
            string2 = iMsgDataElement.getMsgId();
        }
        if (string2 != null && string2.length() != 0) {
            stringBuffer.append(string2).append(": ");
        }
        if (string != null && string.length() != 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public long getSequenceNumber() {
        if (this.commonBaseEvent == null) {
            return -1L;
        }
        long l = this.commonBaseEvent.getSequenceNumber();
        return l;
    }

    public Object[] getParameters() {
        if (this.commonBaseEvent == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        IAssociatedEvent[] iAssociatedEventArray = this.commonBaseEvent.getAssociatedEvents();
        IContextDataElement[] iContextDataElementArray = this.commonBaseEvent.getContextDataElements();
        IExtendedDataElement[] iExtendedDataElementArray = this.commonBaseEvent.getExtendedDataElements();
        n += iAssociatedEventArray != null ? iAssociatedEventArray.length : 0;
        n += iContextDataElementArray != null ? iContextDataElementArray.length : 0;
        Object[] objectArray = new Object[n += iExtendedDataElementArray != null ? iExtendedDataElementArray.length : 0];
        if (iAssociatedEventArray != null) {
            System.arraycopy(iAssociatedEventArray, 0, objectArray, n2, iAssociatedEventArray.length);
        }
        n2 += iAssociatedEventArray.length;
        if (iContextDataElementArray != null) {
            System.arraycopy(iContextDataElementArray, 0, objectArray, n2, iContextDataElementArray.length);
        }
        n2 += iContextDataElementArray.length;
        if (iExtendedDataElementArray != null) {
            System.arraycopy(iExtendedDataElementArray, 0, objectArray, n2, iExtendedDataElementArray.length);
        }
        n2 += iExtendedDataElementArray.length;
        return objectArray;
    }

    public ICommonBaseEvent getCommonBaseEvent() {
        return this.commonBaseEvent;
    }

    public void setCommonBaseEvent(ICommonBaseEvent iCommonBaseEvent) {
        this.commonBaseEvent = iCommonBaseEvent;
    }

    public void setMessage(String string) {
        this.commonBaseEvent.setMsg(string);
    }

    public void setMillis(long l) {
        this.commonBaseEvent.setCreationTime(String.valueOf(l));
    }

    public void setParameters(Object[] objectArray) {
        int n = objectArray.length - 1;
        while (n >= 0) {
            if (objectArray[n] instanceof IAssociatedEvent) {
                this.commonBaseEvent.addAssociatedEvent((IAssociatedEvent)objectArray[n]);
            } else if (objectArray[n] instanceof IContextDataElement) {
                this.commonBaseEvent.addContextDataElement((IContextDataElement)objectArray[n]);
            } else if (objectArray[n] instanceof IExtendedDataElement) {
                this.commonBaseEvent.addExtendedDataElement((IExtendedDataElement)objectArray[n]);
            } else {
                throw new IllegalArgumentException("Type of element " + n + " in the passed argument is not supported");
            }
            --n;
        }
    }

    public void setSequenceNumber(long l) {
        this.commonBaseEvent.setSequenceNumber(l);
    }

    public String externalizeCanonicalXmlString() {
        if (this.commonBaseEvent != null) {
            return CbeFormatter.toCanonicalXMLString((ICommonBaseEvent)this.commonBaseEvent);
        }
        return null;
    }

    public String externalizeCanonicalXmlDocString() {
        if (this.commonBaseEvent != null) {
            return CbeFormatter.toCanonicalXMLDocString((ICommonBaseEvent)this.commonBaseEvent);
        }
        return null;
    }

    private long getCreationTimeInMillis(ICommonBaseEvent iCommonBaseEvent) {
        SimpleDateFormat simpleDateFormat;
        Date date;
        int n;
        String string;
        if (iCommonBaseEvent != null && (string = iCommonBaseEvent.getCreationTime()) != null && string.length() != 0 && (n = string.lastIndexOf(45)) != -1 && (date = (simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSzzzz")).parse(string = string.substring(0, n).concat("GMT").concat(string.substring(n)), new ParsePosition(0))) != null) {
            return date.getTime();
        }
        return -1L;
    }
}

