/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.common.DataServerListener;
import org.eclipse.hyades.internal.execution.local.common.Message;

public final class TCPDataServer {
    private ServerSocket _sock = null;
    private TCPDataProcessor _server = null;
    private BufferFlusher _flusher = null;
    private int _port;
    private static final short NUM_BUFFERS = 32;
    private SingleBuffer[] _bufferArray;
    private short _currentFullBuffers = 0;
    public static final byte BINARY_DATA = 0;
    public static final byte UTF8_STRING_DATA = 1;
    public static final byte UNICODE_STRING_DATA = 2;
    private Vector _dataServerListeners = new Vector();

    public int getPort() {
        return this._port;
    }

    public InetAddress getServerAddress() {
        return this._sock.getInetAddress();
    }

    public void startServer(DataProcessor dataProcessor, int n) throws SocketException, IOException {
        this._bufferArray = new SingleBuffer[32];
        int n2 = 0;
        while (n2 < 32) {
            this._bufferArray[n2] = new SingleBuffer();
            ++n2;
        }
        this._sock = new ServerSocket(n);
        this._port = this._sock.getLocalPort();
        this._server = new TCPDataProcessor();
        this._server.setSocket(this._sock);
        this._server.setName("TCPDataFiller");
        this._flusher = new BufferFlusher();
        this._flusher.setProcessor(dataProcessor);
        this._flusher.setName("TCPDataFlusher");
        this._server.setDaemon(true);
        this._flusher.setDaemon(true);
        this._flusher.setPriority(this._server.getPriority() + 3);
        this._server.start();
        this._flusher.start();
    }

    public void startServer(DataProcessor dataProcessor) throws SocketException, IOException {
        this.startServer(dataProcessor, 0);
    }

    public boolean isProcessing() {
        return this._server.isAlive();
    }

    public void stopServer() {
        this._server.pauseProcessing();
    }

    public void resumeServer() {
        this._server.resumeProcessing();
    }

    public void resumeServer(DataProcessor dataProcessor) {
        this._flusher.setProcessor(dataProcessor);
        this._server.resumeProcessing();
    }

    public void shutdownServer() {
        this._server.shutdown();
    }

    static /* synthetic */ short access$008(TCPDataServer tCPDataServer) {
        short s = tCPDataServer._currentFullBuffers;
        tCPDataServer._currentFullBuffers = (short)(s + 1);
        return s;
    }

    static /* synthetic */ short access$010(TCPDataServer tCPDataServer) {
        short s = tCPDataServer._currentFullBuffers;
        tCPDataServer._currentFullBuffers = (short)(s - 1);
        return s;
    }

    class BufferFlusher
    extends Thread
    implements Constants {
        private DataProcessor _processor = null;
        private byte[] _binaryForwardBuffer = new byte[8096];
        private char[] _stringForwardBuffer = new char[8096];
        private byte[] _messageHeader = new byte[10];
        private long _currentBufferSize = 8096L;
        private short _currentFlusherBuffer = 0;
        private int _currentHeaderOffset = 0;
        private int _bytesWritten = 0;

        BufferFlusher() {
        }

        public void setProcessor(DataProcessor dataProcessor) {
            this._processor = dataProcessor;
        }

        protected int loadMessageHeader(byte[] byArray, int n, int n2) {
            while (n < n2 && this._currentHeaderOffset < 10) {
                this._messageHeader[this._currentHeaderOffset++] = byArray[n++];
            }
            return n;
        }

        protected long getMessageLength() {
            return Message.readRALongFromBuffer(this._messageHeader, 5);
        }

        protected byte getMessageType() {
            return this._messageHeader[9];
        }

        protected boolean checkMessageMagic() {
            long l = (long)(this._messageHeader[0] << 24 & 0xFF000000) | (long)(this._messageHeader[1] << 16 & 0xFF0000) | (long)this._messageHeader[2] << 8 & 0xFF00L | (long)this._messageHeader[3];
            return true;
        }

        /*
         * Unable to fully structure code
         */
        protected int processData(byte[] var1_1, int var2_2, int var3_3, InetAddress var4_4) {
            var8_5 = var2_2;
            if (var2_2 >= var3_3) {
                return var3_3;
            }
            if (this._currentHeaderOffset < 10) {
                if ((var8_5 = this.loadMessageHeader(var1_1, var8_5, var3_3)) == var3_3) {
                    return var8_5;
                }
                if (this.getMessageLength() >= this._currentBufferSize) {
                    var7_6 = this.getMessageType();
                    if (var7_6 == 0 || var7_6 == 1) {
                        var9_8 = new byte[(int)this.getMessageLength()];
                        System.arraycopy(var1_1, var8_5, var9_8, 0, var3_3 - var8_5);
                        this._bytesWritten = var3_3 - var8_5;
                        this._binaryForwardBuffer = var9_8;
                    } else {
                        var9_9 = new char[(int)this.getMessageLength()];
                        var10_10 = 0;
                        while (var10_10 < var3_3 - var8_5 + 1) {
                            var9_9[var10_10] = (char)var1_1[var10_10 + var8_5];
                            ++var10_10;
                        }
                        this._bytesWritten = var3_3 - var8_5;
                        this._stringForwardBuffer = var9_9;
                    }
                    return var3_3;
                }
            }
            if (!this.checkMessageMagic()) {
                System.out.println("Corrupt data");
                this._currentHeaderOffset = 0;
                return this.processData(var1_1, var2_2 + 1, var3_3, var4_4);
            }
            var5_11 = this.getMessageLength();
            var7_7 = this.getMessageType();
            while (var8_5 < var3_3) {
                if (var7_7 == 0 || var7_7 == 1) {
                    while (var8_5 < var3_3 && (long)this._bytesWritten < var5_11) {
                        this._binaryForwardBuffer[this._bytesWritten++] = var1_1[var8_5++];
                    }
                    if ((long)this._bytesWritten != var5_11) continue;
                    this._processor.incommingData(this._binaryForwardBuffer, this._bytesWritten, var4_4);
                    this._bytesWritten = 0;
                    this._currentHeaderOffset = 0;
                    var8_5 = this.processData(var1_1, var8_5, var3_3, var4_4);
                    continue;
                }
                if (var7_7 != 2) ** GOTO lbl53
                while (var2_2 < var3_3 && (long)this._bytesWritten < var5_11) {
                    this._stringForwardBuffer[this._bytesWritten >> 1] = (char)((char)var1_1[var8_5++] | (char)(var1_1[var8_5++] << 8));
                    this._bytesWritten += 2;
                }
                if ((long)this._bytesWritten != var5_11) continue;
                this._processor.incommingData(this._stringForwardBuffer, this._bytesWritten, var4_4);
                this._bytesWritten = 0;
                this._currentHeaderOffset = 0;
                var8_5 = this.processData(var1_1, var8_5, var3_3, var4_4);
                continue;
lbl-1000:
                // 1 sources

                {
                    this._binaryForwardBuffer[this._bytesWritten++] = var1_1[var8_5++];
lbl53:
                    // 2 sources

                    ** while (var2_2 < var3_3 && (long)this._bytesWritten < var5_11)
                }
lbl54:
                // 1 sources

                if ((long)this._bytesWritten != var5_11) continue;
                this._processor.incommingData(this._binaryForwardBuffer, this._bytesWritten, var4_4);
                this._bytesWritten = 0;
                this._currentHeaderOffset = 0;
                var8_5 = this.processData(var1_1, var8_5, var3_3, var4_4);
            }
            return var8_5;
        }

        public void run() {
            block8: while (TCPDataServer.this.isProcessing() || TCPDataServer.this._currentFullBuffers != 0) {
                SingleBuffer singleBuffer;
                if (TCPDataServer.this._currentFullBuffers == 0) {
                    this._processor.waitingForData();
                    do {
                        singleBuffer = TCPDataServer.this._bufferArray[0];
                        synchronized (singleBuffer) {
                            try {
                                TCPDataServer.this._bufferArray[0].wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (!TCPDataServer.this.isProcessing() && TCPDataServer.this._currentFullBuffers == 0) break block8;
                    } while (TCPDataServer.this._currentFullBuffers == 0);
                }
                if (((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].length > 0) {
                    this.processData(((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].data, 0, ((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].length, ((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].addr);
                    ((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].length = 0;
                }
                singleBuffer = TCPDataServer.this._bufferArray[0];
                synchronized (singleBuffer) {
                    TCPDataServer.access$010(TCPDataServer.this);
                    this._currentFlusherBuffer = (short)(this._currentFlusherBuffer + 1);
                    if (this._currentFlusherBuffer == 32) {
                        this._currentFlusherBuffer = 0;
                    }
                    if (TCPDataServer.this._currentFullBuffers == 0) {
                        TCPDataServer.this._bufferArray[0].notifyAll();
                    }
                }
            }
            if (this._processor instanceof DataServerListener) {
                ((DataServerListener)this._processor).dataServerExited();
            }
        }
    }

    class TCPDataProcessor
    extends Thread
    implements Constants {
        ServerSocket _socket;
        boolean _processing = true;
        boolean _shutdown = false;
        private short _currentFillerBuffer = 0;

        TCPDataProcessor() {
        }

        public void setSocket(ServerSocket serverSocket) {
            this._socket = serverSocket;
        }

        public void resumeProcessing() {
            TCPDataProcessor tCPDataProcessor = this;
            synchronized (tCPDataProcessor) {
                this._processing = true;
            }
        }

        public void pauseProcessing() {
            TCPDataProcessor tCPDataProcessor = this;
            synchronized (tCPDataProcessor) {
                this._processing = false;
            }
        }

        public boolean isProcessing() {
            TCPDataProcessor tCPDataProcessor = this;
            synchronized (tCPDataProcessor) {
                boolean bl = this._processing;
                return bl;
            }
        }

        public void shutdown() {
            this._shutdown = true;
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            block22: while (!this._shutdown || TCPDataServer.access$000(TCPDataServer.this) != 0) {
                block30: {
                    if (!this.isProcessing()) break block30;
                    var1_1 = null;
                    var2_3 = null;
                    try {
                        var1_1 = this._socket.accept();
                        var2_3 = var1_1.getInputStream();
                        var1_1.setSoTimeout(1000);
                        if (true) ** GOTO lbl27
                    }
                    catch (SocketException var3_4) {
                        this.pauseProcessing();
                        continue;
                    }
                    catch (IOException var4_8) {
                        continue;
                    }
                    block23: while (true) {
                        var3_5 = TCPDataServer.access$100(TCPDataServer.this)[0];
                        synchronized (var3_5) {
                            try {
                                TCPDataServer.access$100(TCPDataServer.this)[0].wait();
                            }
                            catch (InterruptedException var4_10) {
                                // empty catch block
                            }
                        }
lbl27:
                        // 3 sources

                        while (true) {
                            if (TCPDataServer.access$000(TCPDataServer.this) == 32) continue block23;
                            TCPDataServer.access$100((TCPDataServer)TCPDataServer.this)[this._currentFillerBuffer].addr = var1_1.getInetAddress();
                            try {
                                TCPDataServer.access$100((TCPDataServer)TCPDataServer.this)[this._currentFillerBuffer].length = var2_3.read(TCPDataServer.access$100((TCPDataServer)TCPDataServer.this)[this._currentFillerBuffer].data);
                            }
                            catch (InterruptedIOException var3_6) {
                                if (this._shutdown && TCPDataServer.access$000(TCPDataServer.this) == 0) {
                                    this.pauseProcessing();
                                    try {
                                        var1_1.close();
                                    }
                                    catch (IOException var4_11) {}
                                    break block22;
                                }
                            }
                            catch (IOException var4_12) {
                                this.pauseProcessing();
                                try {
                                    var1_1.close();
                                }
                                catch (IOException var5_14) {}
                                break block22;
                            }
                            if (TCPDataServer.access$100((TCPDataServer)TCPDataServer.this)[this._currentFillerBuffer].length < 0) {
                                this.pauseProcessing();
                                try {
                                    var1_1.close();
                                }
                                catch (IOException var3_7) {}
                                break block22;
                            }
                            var3_5 = TCPDataServer.access$100(TCPDataServer.this)[0];
                            synchronized (var3_5) {
                                if (TCPDataServer.access$100((TCPDataServer)TCPDataServer.this)[this._currentFillerBuffer].length > 0) {
                                    this._currentFillerBuffer = (short)(this._currentFillerBuffer + 1);
                                    if (this._currentFillerBuffer == 32) {
                                        this._currentFillerBuffer = 0;
                                    }
                                    TCPDataServer.access$008(TCPDataServer.this);
                                    if (TCPDataServer.access$000(TCPDataServer.this) == 1) {
                                        TCPDataServer.access$100(TCPDataServer.this)[0].notifyAll();
                                    }
                                }
                            }
                        }
                        break;
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException var1_2) {
                    // empty catch block
                }
            }
        }
    }

    class SingleBuffer
    implements Constants {
        public InetAddress addr;
        public int length = 0;
        public int size = 8096;
        public byte[] data = new byte[8096];

        SingleBuffer() {
        }
    }
}

