/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.xmlschema.beans;

import com.ibm.etools.xmlschema.beans.BaseType;
import com.ibm.etools.xmlschema.beans.SimpleType;
import java.text.ParseException;
import java.util.Date;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComplexType
extends BaseType {
    public boolean removeElement(int index, String elementName) {
        Node deleteNode;
        NodeList nodes;
        int length;
        if (this.isElementQualified()) {
            elementName = String.valueOf(this.getPrefix()) + elementName;
        }
        if (index < (length = (nodes = this.xmlElement.getElementsByTagName(elementName)).getLength()) && (deleteNode = nodes.item(index)) != null) {
            try {
                this.xmlElement.removeChild(deleteNode);
                return true;
            }
            catch (DOMException ex) {
                System.out.println("DOM Exception from removeElement." + ex);
            }
        }
        return false;
    }

    public void setElementValue(int index, String elementName, BaseType baseType) {
        Element childXml = baseType.getXMLElement();
        this.insertXMLElementAtLocation(childXml, index, elementName);
    }

    public void setElementValue(int index, String elementName, String elementValue) {
        Element newChild = this.factory.createXMLElementAndText(elementName, elementValue);
        this.insertXMLElementAtLocation(newChild, index, elementName);
    }

    public void setElementValue(int index, String elementName, boolean value) {
        this.setElementValue(index, elementName, new Boolean(value).toString());
    }

    public void setElementValue(int index, String elementName, int value) {
        this.setElementValue(index, elementName, new Integer(value).toString());
    }

    public void setElementValue(int index, String elementName, float value) {
        this.setElementValue(index, elementName, new Float(value).toString());
    }

    public void setElementValue(int index, String elementName, double value) {
        this.setElementValue(index, elementName, new Double(value).toString());
    }

    public void setElementValue(int index, String elementName, long value) {
        this.setElementValue(index, elementName, new Long(value).toString());
    }

    public void setElementValue(int index, String elementName, short value) {
        this.setElementValue(index, elementName, new Short(value).toString());
    }

    public void setElementValue(int index, String elementName, byte value) {
        this.setElementValue(index, elementName, new Byte(value).toString());
    }

    public void setElementValue(int index, String elementName, Date value) {
        this.setElementValue(index, elementName, this.simpleDateFormat.format(value));
    }

    public boolean getElementBooleanValue(String elementName, int index) {
        return new Boolean(this.getElementValue(elementName, index));
    }

    public int getElementIntegerValue(String elementName, int index) {
        return new Integer(this.getElementValue(elementName, index));
    }

    public float getElementFloatValue(String elementName, int index) {
        return new Float(this.getElementValue(elementName, index)).floatValue();
    }

    public double getElementDoubleValue(String elementName, int index) {
        return new Double(this.getElementValue(elementName, index));
    }

    public long getElementLongValue(String elementName, int index) {
        return new Long(this.getElementValue(elementName, index));
    }

    public short getElementShortValue(String elementName, int index) {
        return new Short(this.getElementValue(elementName, index));
    }

    public byte getElementByteValue(String elementName, int index) {
        return new Byte(this.getElementValue(elementName, index));
    }

    public Date getElementDateValue(String elementName, int index) {
        try {
            String result = this.getElementValue(elementName, index);
            if (result != null) {
                return this.simpleDateFormat.parse(result);
            }
        }
        catch (ParseException ex) {
            System.out.println("getElementDateValue exception.." + ex);
        }
        return null;
    }

    public void setAttributeValue(String attrname, String attrvalue) {
        if (this.xmlElement == null) {
            this.xmlAttr.setValue(attrvalue);
        } else {
            Attr attr;
            String prefix = "";
            if (this.isAttributeQualified()) {
                prefix = this.getPrefix();
            }
            if ((attr = this.xmlElement.getAttributeNode(String.valueOf(prefix) + attrname)) == null) {
                attr = this.factory.createAttribute(attrname, this.xmlElement);
            }
            attr.setValue(attrvalue);
        }
    }

    public void setAttributeValue(String attrname, SimpleType attrObject) {
        this.setAttributeValue(attrname, attrObject.getElementValue());
    }

    public void setAttributeValue(String attrname, boolean attrObject) {
        this.setAttributeValue(attrname, new Boolean(attrObject).toString());
    }

    public void setAttributeValue(String attrname, int attrObject) {
        this.setAttributeValue(attrname, new Integer(attrObject).toString());
    }

    public void setAttributeValue(String attrname, float attrObject) {
        this.setAttributeValue(attrname, new Float(attrObject).toString());
    }

    public void setAttributeValue(String attrname, double attrObject) {
        this.setAttributeValue(attrname, new Double(attrObject).toString());
    }

    public void setAttributeValue(String attrname, long attrObject) {
        this.setAttributeValue(attrname, new Long(attrObject).toString());
    }

    public void setAttributeValue(String attrname, short attrObject) {
        this.setAttributeValue(attrname, new Short(attrObject).toString());
    }

    public void setAttributeValue(String attrname, byte attrObject) {
        this.setAttributeValue(attrname, new Byte(attrObject).toString());
    }

    public void setAttributeValue(String attrname, Date attrObject) {
        this.setAttributeValue(attrname, this.simpleDateFormat.format(attrObject));
    }

    public String getAttributeValue(String attrname) {
        Attr attr;
        String prefix = "";
        if (this.isAttributeQualified()) {
            prefix = this.getPrefix();
        }
        if ((attr = this.xmlElement.getAttributeNode(String.valueOf(prefix) + attrname)) != null) {
            return attr.getValue();
        }
        return null;
    }

    public boolean getAttributeBooleanValue(String attrname) {
        return new Boolean(this.getAttributeValue(attrname));
    }

    public int getAttributeIntegerValue(String attrname) {
        return new Integer(this.getAttributeValue(attrname));
    }

    public float getAttributeFloatValue(String attrname) {
        return new Float(this.getAttributeValue(attrname)).floatValue();
    }

    public double getAttributeDoubleValue(String attrname) {
        return new Double(this.getAttributeValue(attrname));
    }

    public long getAttributeLongValue(String attrname) {
        return new Long(this.getAttributeValue(attrname));
    }

    public short getAttributeShortValue(String attrname) {
        return new Short(this.getAttributeValue(attrname));
    }

    public byte getAttributeByteValue(String attrname) {
        return new Byte(this.getAttributeValue(attrname));
    }

    public Date getAttributeDateValue(String attrname) {
        try {
            String result = this.getAttributeValue(attrname);
            if (result != null) {
                return this.simpleDateFormat.parse(result);
            }
        }
        catch (ParseException ex) {
            System.out.println("getElementDateValue exception.." + ex);
        }
        return null;
    }

    public Object getAttributeValue(String property, String className) {
        String prefix = "";
        if (this.isAttributeQualified()) {
            prefix = this.getPrefix();
        }
        Attr attr = this.xmlElement.getAttributeNode(String.valueOf(prefix) + property);
        return this.factory.newInstance(attr, className);
    }

    public boolean removeAttribute(String attrname) {
        String prefix = "";
        if (this.isAttributeQualified()) {
            prefix = this.getPrefix();
        }
        try {
            this.xmlElement.removeAttribute(String.valueOf(prefix) + attrname);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void insertXMLElementAtLocation(Element newChild, int index, String elementName) {
        NodeList nodes;
        int length;
        String prefix = "";
        if (this.isElementQualified()) {
            prefix = this.getPrefix();
        }
        int n = length = (nodes = this.xmlElement.getElementsByTagName(String.valueOf(prefix) + elementName)) != null ? nodes.getLength() : 0;
        if (length == 0 || index >= length) {
            this.xmlElement.appendChild(newChild);
            return;
        }
        Node node = nodes.item(index);
        this.xmlElement.insertBefore(newChild, node);
    }
}

