/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.util;

import org.eclipse.hyades.logging.adapter.impl.Sensor;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.SimpleEventFactoryImpl;

public class AdapterSensor
extends Sensor {
    public static final short OFF_LEVEL = -1;
    public static final short UNKNOWN_LEVEL = 0;
    public static final short INFO_LEVEL = 10;
    public static final short HARMLESS_LEVEL = 20;
    public static final short WARN_LEVEL = 30;
    public static final short MINOR_LEVEL = 40;
    public static final short CRITICAL_LEVEL = 50;
    public static final short FATAL_LEVEL = 60;
    public static final short TRACE_LEVEL = 70;
    public static final short FINE_LEVEL = 72;
    public static final short FINER_LEVEL = 74;
    public static final short FINEST_LEVEL = 76;
    public static final short ALL_LEVEL = 99;
    private int arraySize = 256;
    private ICommonBaseEvent[] events = new ICommonBaseEvent[this.arraySize];
    private int lastAddedEvent = -1;
    private int lastRemovedEvent = -1;
    private static AdapterSensor instance = null;

    public AdapterSensor() {
        instance = this;
    }

    public static synchronized AdapterSensor getInstance() {
        if (instance == null) {
            instance = new AdapterSensor();
        }
        return instance;
    }

    public synchronized Object[] testGetNext() {
        return this.testGetNextEvent();
    }

    public synchronized ICommonBaseEvent[] testGetNextEvent() {
        ICommonBaseEvent[] iCommonBaseEventArray = new ICommonBaseEvent[]{SimpleEventFactoryImpl.getInstance().createCommonBaseEvent()};
        return iCommonBaseEventArray;
    }

    public Object[] flush() {
        return this.getNext();
    }

    public Object[] getNext() {
        return this.getNextEvent();
    }

    public synchronized ICommonBaseEvent[] getNextEvent() {
        AdapterSensor adapterSensor = this;
        synchronized (adapterSensor) {
            if (this.lastAddedEvent == -1 || this.lastRemovedEvent == this.lastAddedEvent) {
                ICommonBaseEvent[] iCommonBaseEventArray = null;
                return iCommonBaseEventArray;
            }
            ICommonBaseEvent[] iCommonBaseEventArray = new ICommonBaseEvent[this.lastAddedEvent - this.lastRemovedEvent];
            System.arraycopy(this.events, this.lastRemovedEvent + 1, iCommonBaseEventArray, 0, this.lastAddedEvent - this.lastRemovedEvent);
            this.lastRemovedEvent = this.lastAddedEvent;
            ICommonBaseEvent[] iCommonBaseEventArray2 = iCommonBaseEventArray;
            return iCommonBaseEventArray2;
        }
    }

    public synchronized void addEvent(ICommonBaseEvent iCommonBaseEvent) {
        AdapterSensor adapterSensor = this;
        synchronized (adapterSensor) {
            if (this.lastAddedEvent + 1 == this.events.length) {
                this.increaseArraySize();
            }
            this.events[++this.lastAddedEvent] = iCommonBaseEvent;
        }
    }

    private synchronized void increaseArraySize() {
        ICommonBaseEvent[] iCommonBaseEventArray = new ICommonBaseEvent[this.arraySize * 2];
        this.arraySize *= 2;
        this.compressArrayInto(iCommonBaseEventArray);
        this.events = iCommonBaseEventArray;
    }

    private synchronized void compressArrayInto(ICommonBaseEvent[] iCommonBaseEventArray) {
        System.arraycopy(this.events, this.lastRemovedEvent + 1, iCommonBaseEventArray, 0, this.lastAddedEvent - this.lastRemovedEvent);
        this.lastAddedEvent -= this.lastRemovedEvent;
        this.lastRemovedEvent = -1;
    }
}

