/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.core;

import java.io.File;
import java.rmi.dgc.VMID;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Guid {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] STRING_BUFFER = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private static final long UTC_OFFSET = 122192928000000000L;
    private static final short GUID_VERSION_1 = 4096;
    private static final byte GUID_RESERVED = -128;
    private static final int MAX_CLOCK_SEQ_ADJUST = 9999;
    private static final Object _internalsLock = new Object();
    private static byte[] _ieee802Addr = new byte[6];
    private static boolean _internalsSet = false;
    private static long _lastTimestamp = 0L;
    private static int _clock_seq_adjust = 0;
    private static int _osProcessId = 0;
    private static int _rand_ia = 0;
    private static int _rand_ib = 0;
    private static int _rand_irand = 0;
    private static int _rand_m = 0;
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private int time_low = 0;
    private short time_mid = 0;
    private short time_hi_and_version = 0;
    private byte clock_seq_hi_and_reserved = 0;
    private byte clock_seq_low = 0;
    private byte[] node = new byte[6];

    public Guid() {
        long l = 0L;
        long l2 = 0L;
        this.initialize();
        Object object = _internalsLock;
        synchronized (object) {
            if (!_internalsSet) {
                this.getPseudoIEEE802Address(_ieee802Addr);
                _osProcessId = this.getPseudoOSProcessId();
                l = Guid.getAdjustedTimestamp();
                Guid.initTrueRandom(l);
                l2 = Guid.getTrueRandom();
                _internalsSet = true;
            }
            boolean bl = true;
            do {
                if ((l = Guid.getAdjustedTimestamp()) < _lastTimestamp) {
                    l2 = Guid.getTrueRandom();
                    _clock_seq_adjust = 0;
                }
                if (l > _lastTimestamp) {
                    _clock_seq_adjust = 0;
                }
                if (l != _lastTimestamp) continue;
                if (_clock_seq_adjust < 9999) {
                    ++_clock_seq_adjust;
                    continue;
                }
                bl = false;
            } while (!bl);
            _lastTimestamp = l;
            if (_clock_seq_adjust != 0) {
                l += (long)_clock_seq_adjust;
            }
        }
        long l3 = l & 0xFFFFFFFFL;
        this.time_low = (int)l3;
        l3 = l >> 32 & 0xFFFL;
        this.time_mid = (short)l3;
        l3 = l >> 48 & 0xFFFL;
        this.time_hi_and_version = (short)l3;
        this.time_hi_and_version = (short)(this.time_hi_and_version + 4096);
        l3 = l2 & 0xFFL;
        this.clock_seq_low = (byte)l3;
        l3 = (l2 & 0x3F00L) >> 8;
        this.clock_seq_hi_and_reserved = (byte)l3;
        this.clock_seq_hi_and_reserved = (byte)(this.clock_seq_hi_and_reserved + -128);
        System.arraycopy(_ieee802Addr, 0, this.node, 0, this.node.length);
    }

    private static long getAdjustedTimestamp() {
        long l = System.currentTimeMillis();
        long l2 = l * 10000L + 122192928000000000L;
        return l2;
    }

    private void initialize() {
        this.time_low = 0;
        this.time_mid = 0;
        this.time_hi_and_version = 0;
        this.clock_seq_low = 0;
        this.clock_seq_hi_and_reserved = 0;
        int n = 0;
        while (n < this.node.length) {
            this.node[n] = 0;
            ++n;
        }
    }

    private static synchronized void initTrueRandom(long l) {
        _rand_m = 971;
        _rand_ia = 11113;
        _rand_ib = 104322;
        _rand_irand = 4181;
        int n = (int)(l >>> 48) ^ (int)(l >>> 32) ^ (int)(l >>> 16) ^ (int)(l & 0xFFFFL);
        _rand_irand = _rand_irand + n + _osProcessId;
    }

    private static synchronized short getTrueRandom() {
        _rand_ia += 1907;
        _rand_ib += 73939;
        if ((_rand_m += 7) >= 9973) {
            _rand_m -= 9871;
        }
        if (_rand_ia >= 99991) {
            _rand_ia -= 89989;
        }
        if (_rand_ib >= 224729) {
            _rand_ib -= 96233;
        }
        _rand_irand = _rand_irand * _rand_m + _rand_ia + _rand_ib;
        _rand_irand = _rand_irand >>> 16 ^ _rand_irand & 0x3FFF;
        return (short)_rand_irand;
    }

    private int getPseudoOSProcessId() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    private void getPseudoIEEE802Address(byte[] byArray) {
        byte[] byArray2 = Guid.getByteArrayFromString(String.valueOf(Runtime.getRuntime().freeMemory()));
        byte[] byArray3 = Guid.getByteArrayFromString(String.valueOf(Runtime.getRuntime().totalMemory()));
        byte[] byArray4 = Guid.getByteArrayFromString(String.valueOf(File.listRoots().length));
        byte[] byArray5 = Guid.getByteArrayFromString(String.valueOf(System.currentTimeMillis()));
        byte[] byArray6 = Guid.getByteArrayFromString(String.valueOf(Thread.currentThread().getThreadGroup().getParent().activeCount()));
        byte[] byArray7 = new VMID().toString().getBytes();
        long l = 0L;
        File file = new File("/");
        File[] fileArray = file.listFiles();
        byte[] byArray8 = new byte[]{0};
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                l += fileArray[n].length();
                ++n;
            }
            byArray8 = Guid.getByteArrayFromString(String.valueOf(l));
        }
        byte[] byArray9 = null;
        byte[] byArray10 = new byte[byArray2.length + byArray3.length + byArray4.length + byArray5.length + byArray6.length + byArray7.length + byArray8.length];
        int n = 0;
        System.arraycopy(byArray2, 0, byArray10, n, byArray2.length);
        System.arraycopy(byArray3, 0, byArray10, n += byArray2.length, byArray3.length);
        System.arraycopy(byArray4, 0, byArray10, n += byArray3.length, byArray4.length);
        System.arraycopy(byArray5, 0, byArray10, n += byArray4.length, byArray5.length);
        System.arraycopy(byArray6, 0, byArray10, n += byArray5.length, byArray6.length);
        System.arraycopy(byArray7, 0, byArray10, n += byArray6.length, byArray7.length);
        System.arraycopy(byArray8, 0, byArray10, n += byArray7.length, byArray8.length);
        n += byArray8.length;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            byArray9 = messageDigest.digest(byArray10);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        System.arraycopy(byArray9, 0, byArray, 0, 6);
        byArray[0] = (byte)(byArray[0] | 0xFFFFFF80);
    }

    private static byte[] getByteArrayFromString(String string) {
        int n = string.length();
        string = string + "  ";
        String string2 = new String(hexChars);
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        while (n2 < n - 1) {
            byArray[n2 / 2] = (byte)(string2.indexOf(string.substring(n2, n2 + 1)) << 4);
            int n3 = n2 / 2;
            byArray[n3] = (byte)(byArray[n3] + string2.indexOf(string.substring(n2 + 1, n2 + 2)));
            n2 += 2;
        }
        return byArray;
    }

    public String toString() {
        int n = 0;
        int n2 = 28;
        n = 0;
        while (n < 8) {
            Guid.STRING_BUFFER[n] = n == 0 ? 78 : HEX_CHARS[this.time_low >> n2 & 0xF];
            n2 -= 4;
            ++n;
        }
        n2 = 12;
        n = 8;
        while (n < 12) {
            Guid.STRING_BUFFER[n] = HEX_CHARS[this.time_mid >> n2 & 0xF];
            n2 -= 4;
            ++n;
        }
        n2 = 12;
        n = 12;
        while (n < 16) {
            Guid.STRING_BUFFER[n] = HEX_CHARS[this.time_hi_and_version >> n2 & 0xF];
            n2 -= 4;
            ++n;
        }
        Guid.STRING_BUFFER[16] = HEX_CHARS[this.clock_seq_hi_and_reserved >> 4 & 0xF];
        Guid.STRING_BUFFER[17] = HEX_CHARS[this.clock_seq_hi_and_reserved & 0xF];
        Guid.STRING_BUFFER[18] = HEX_CHARS[this.clock_seq_low >> 4 & 0xF];
        Guid.STRING_BUFFER[19] = HEX_CHARS[this.clock_seq_low & 0xF];
        int n3 = 0;
        n = 20;
        while (n < 32) {
            Guid.STRING_BUFFER[n] = HEX_CHARS[this.node[n3] >> 4 & 0xF];
            Guid.STRING_BUFFER[n + 1] = HEX_CHARS[this.node[n3] & 0xF];
            ++n3;
            n += 2;
        }
        String string = new String(STRING_BUFFER);
        return string.trim();
    }

    public static void main(String[] stringArray) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        String string = "";
        int n = 0;
        while (n < 10) {
            string = new Guid().toString();
            if (hashtable.containsKey(string)) {
                hashtable.put(string, new Integer((Integer)hashtable.get(string) + 1));
            } else {
                hashtable.put(string, new Integer(1));
            }
            ++n;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            System.out.println("'" + string + "' has been duplicated " + hashtable.get(string) + " time(s).");
        }
    }
}

