/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.security;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.eclipse.hyades.execution.security.IKeystoreManager;
import org.eclipse.hyades.execution.security.ISecureClientParameters;

public final class SecureClient {
    private SSLSocket sslsocket;

    private IKeystoreManager loadKeystore(ISecureClientParameters iSecureClientParameters) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, CertificateException, IOException {
        IKeystoreManager iKeystoreManager = iSecureClientParameters.getKeystoreManager();
        iKeystoreManager.setProvider(iSecureClientParameters.getSecurityProvider());
        iKeystoreManager.loadKeystore(iSecureClientParameters.getKeystoreFileName(), iSecureClientParameters.getKeystoreFilepassword());
        return iKeystoreManager;
    }

    public void init(ISecureClientParameters iSecureClientParameters, String string, int n) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, CertificateException, IOException {
        int n2 = 0;
        IKeystoreManager iKeystoreManager = null;
        System.out.println("Secure Client initialization started");
        Security.addProvider(iSecureClientParameters.getSecurityProvider());
        iKeystoreManager = this.loadKeystore(iSecureClientParameters);
        SSLContext sSLContext = null;
        String[] stringArray = iSecureClientParameters.getEnabledProtocols();
        while (true) {
            try {
                sSLContext = SSLContext.getInstance(stringArray[n2]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (++n2 != stringArray.length) continue;
                throw noSuchAlgorithmException;
                if (n2 < stringArray.length) continue;
            }
            break;
        }
        sSLContext.init(iKeystoreManager.getKeyManagers(), iKeystoreManager.getTrustManagers(), null);
        this.sslsocket = (SSLSocket)sSLContext.getSocketFactory().createSocket(string, n);
        this.sslsocket.setEnabledCipherSuites(iSecureClientParameters.getEnabledCipherSuites());
        this.sslsocket.startHandshake();
        SSLSession sSLSession = this.sslsocket.getSession();
        if (sSLSession == null) {
            System.out.println("Session is null. Socket connection failed");
            throw new IOException("No socket session created");
        }
        System.out.println("Secure Client initialization completed");
    }

    public SSLSocket getSocket() {
        return this.sslsocket;
    }
}

